/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.web.SecurityConstraint;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebResourceCollection;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.WebResourceCollectionTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class WebResourceCollectionTablePanel
extends DefaultTablePanel {
    private DDDataObject dObj;
    private WebResourceCollectionTableModel model;
    private SecurityConstraint constraint;

    public WebResourceCollectionTablePanel(final DDDataObject dDDataObject, final WebResourceCollectionTableModel webResourceCollectionTableModel) {
        super((AbstractTableModel)webResourceCollectionTableModel);
        this.dObj = dDDataObject;
        this.model = webResourceCollectionTableModel;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dDDataObject.modelUpdatedFromUI();
                dDDataObject.setChangedFromUI(true);
                int n = WebResourceCollectionTablePanel.this.getTable().getSelectedRow();
                webResourceCollectionTableModel.removeRow(n);
                dDDataObject.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, SecurityConstraint securityConstraint, WebResourceCollection[] webResourceCollectionArray) {
        this.model.setData((CommonDDBean)securityConstraint, (CommonDDBean[])webResourceCollectionArray);
        this.model.setWebApp(webApp);
        this.constraint = securityConstraint;
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            final int n = this.add ? -1 : WebResourceCollectionTablePanel.this.getTable().getSelectedRow();
            final WebResourceCollectionPanel webResourceCollectionPanel = new WebResourceCollectionPanel();
            if (!this.add) {
                object = WebResourceCollectionTablePanel.this.model.getWebResourceCollection(n);
                webResourceCollectionPanel.setResourceName(object.getWebResourceName());
                webResourceCollectionPanel.setDescription(object.getDefaultDescription());
                webResourceCollectionPanel.setUrlPatterns(object.getUrlPattern());
                webResourceCollectionPanel.setHttpMethods(object.getHttpMethod());
            }
            object = new EditDialog(webResourceCollectionPanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_WebResource"), this.add){

                protected String validate() {
                    String string = webResourceCollectionPanel.getResourceName().trim();
                    WebResourceCollection webResourceCollection = null;
                    if (n != -1) {
                        webResourceCollection = WebResourceCollectionTablePanel.this.model.getWebResourceCollection(n);
                    }
                    if (string.length() == 0) {
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_EmptyWebResourceName");
                    }
                    Object[] objectArray = WebResourceCollectionTablePanel.this.constraint.getWebResourceCollection();
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == webResourceCollection || !string.equals(objectArray[i].getWebResourceName())) continue;
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_WebResourceNameExists", (Object)string);
                    }
                    objectArray = webResourceCollectionPanel.getUrlPatterns();
                    if (objectArray.length == 0) {
                        return NbBundle.getMessage(WebResourceCollectionTablePanel.class, (String)"TXT_EmptyUrlPatterns", (Object)string);
                    }
                    return null;
                }
            };
            if (this.add) {
                object.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener((EditDialog)object);
            webResourceCollectionPanel.getResourceNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            webResourceCollectionPanel.getDescriptionTF().getDocument().addDocumentListener((DocumentListener)docListener);
            webResourceCollectionPanel.getUrlPatternsTF().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)object);
            dialog.setVisible(true);
            webResourceCollectionPanel.getResourceNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            webResourceCollectionPanel.getDescriptionTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            webResourceCollectionPanel.getUrlPatternsTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (object.getValue().equals(EditDialog.OK_OPTION)) {
                WebResourceCollectionTablePanel.this.dObj.modelUpdatedFromUI();
                WebResourceCollectionTablePanel.this.dObj.setChangedFromUI(true);
                String string = webResourceCollectionPanel.getResourceName();
                String[] stringArray = webResourceCollectionPanel.getUrlPatterns();
                String[] stringArray2 = webResourceCollectionPanel.getSelectedHttpMethods();
                String string2 = webResourceCollectionPanel.getDescription();
                if (this.add) {
                    WebResourceCollectionTablePanel.this.model.addRow(new Object[]{string, stringArray, stringArray2, string2});
                } else {
                    WebResourceCollectionTablePanel.this.model.editRow(n, new Object[]{string, stringArray, stringArray2, string2});
                }
                WebResourceCollectionTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

