/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRoleRef;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleRefTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class SecurityRoleRefTablePanel
extends DefaultTablePanel {
    private SecurityRoleRefTableModel model;
    private WebApp webApp;
    private DDDataObject dObj;
    private Servlet servlet;

    public SecurityRoleRefTablePanel(final DDDataObject dDDataObject, final SecurityRoleRefTableModel securityRoleRefTableModel) {
        super((AbstractTableModel)securityRoleRefTableModel);
        this.model = securityRoleRefTableModel;
        this.dObj = dDDataObject;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                dDDataObject.modelUpdatedFromUI();
                dDDataObject.setChangedFromUI(true);
                int n = SecurityRoleRefTablePanel.this.getTable().getSelectedRow();
                securityRoleRefTableModel.removeRow(n);
                dDDataObject.setChangedFromUI(false);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    void setModel(WebApp webApp, Servlet servlet, SecurityRoleRef[] securityRoleRefArray) {
        this.model.setData((CommonDDBean)servlet, (CommonDDBean[])securityRoleRefArray);
        this.model.setWebApp(webApp);
        this.webApp = webApp;
        this.servlet = servlet;
    }

    private boolean isEmpty(String string) {
        return null == string || "".equals(string.trim());
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean bl) {
            this.add = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            final int n = this.add ? -1 : SecurityRoleRefTablePanel.this.getTable().getSelectedRow();
            final SecurityRoleRefPanel securityRoleRefPanel = new SecurityRoleRefPanel(SecurityRoleRefTablePanel.this.webApp.getSecurityRole());
            if (!this.add) {
                object = SecurityRoleRefTablePanel.this.model.getSecurityRoleRef(n);
                securityRoleRefPanel.setRoleRefName(object.getRoleName());
                securityRoleRefPanel.setRoleRefLink(object.getRoleLink());
                securityRoleRefPanel.setDescription(object.getDefaultDescription());
            }
            object = new EditDialog(securityRoleRefPanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_SecurityRoleRef"), this.add){

                protected String validate() {
                    String string = securityRoleRefPanel.getRoleRefName().trim();
                    SecurityRoleRef securityRoleRef = null;
                    if (n != -1) {
                        securityRoleRef = SecurityRoleRefTablePanel.this.model.getSecurityRoleRef(n);
                    }
                    if (string.length() == 0) {
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_EmptySecurityRoleRefName");
                    }
                    SecurityRoleRef[] securityRoleRefArray = SecurityRoleRefTablePanel.this.servlet.getSecurityRoleRef();
                    for (int i = 0; i < securityRoleRefArray.length; ++i) {
                        if (securityRoleRefArray[i] == securityRoleRef || !string.equals(securityRoleRefArray[i].getRoleName())) continue;
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_SecurityRoleRefNameExists", (Object)string);
                    }
                    if (SecurityRoleRefTablePanel.this.isEmpty(securityRoleRefPanel.getRoleRefLink())) {
                        return NbBundle.getMessage(SecurityRoleRefTablePanel.class, (String)"TXT_EmptySecurityRoleRefLink");
                    }
                    return null;
                }
            };
            if (this.add) {
                object.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener((EditDialog)object);
            securityRoleRefPanel.getRoleRefNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
            securityRoleRefPanel.getDescriptionTA().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)object);
            dialog.setVisible(true);
            securityRoleRefPanel.getRoleRefNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
            securityRoleRefPanel.getDescriptionTA().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (object.getValue().equals(EditDialog.OK_OPTION)) {
                SecurityRoleRefTablePanel.this.dObj.modelUpdatedFromUI();
                SecurityRoleRefTablePanel.this.dObj.setChangedFromUI(true);
                String string = securityRoleRefPanel.getRoleRefName();
                String string2 = securityRoleRefPanel.getRoleRefLink();
                String string3 = securityRoleRefPanel.getDescription();
                if (this.add) {
                    SecurityRoleRefTablePanel.this.model.addRow(new String[]{string, string2, string3});
                } else {
                    SecurityRoleRefTablePanel.this.model.editRow(n, new String[]{string, string2, string3});
                }
                SecurityRoleRefTablePanel.this.dObj.setChangedFromUI(false);
            }
        }
    }
}

