/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.web.AbsoluteOrdering;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.OrderingItemPanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.RelativeOrderingPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class AbsoluteOrderingPanel
extends SectionInnerPanel
implements ItemListener {
    private DDDataObject dObj;
    private WebApp webApp;
    private DefaultListModel listModel;
    private JButton bAdd;
    private JButton bDown;
    private JButton bEdit;
    private JButton bRemove;
    private JButton bUp;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JList listOrdering;

    public AbsoluteOrderingPanel(SectionView sectionView, DDDataObject dDDataObject) {
        super(sectionView);
        this.dObj = dDDataObject;
        this.webApp = dDDataObject.getWebApp();
        this.initComponents();
        this.listModel = new DefaultListModel();
        this.listOrdering.setModel(this.listModel);
        try {
            for (AbsoluteOrdering absoluteOrdering : this.webApp.getAbsoluteOrdering()) {
                for (String string : absoluteOrdering.getName()) {
                    this.listModel.addElement(string);
                }
            }
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            // empty catch block
        }
    }

    public JComponent getErrorComponent(String string) {
        return null;
    }

    public void setValue(JComponent jComponent, Object object) {
    }

    public void linkButtonPressed(Object object, String string) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.listOrdering = new JList();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.bUp = new JButton();
        this.bDown = new JButton();
        this.setMinimumSize(new Dimension(250, 150));
        this.jLabel1.setHorizontalAlignment(2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"LBL_AbsoluteOrder"));
        this.listOrdering.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.listOrdering);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbsoluteOrderingPanel.this.bAddActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbsoluteOrderingPanel.this.bEditActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbsoluteOrderingPanel.this.bRemoveActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bUp, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Up"));
        this.bUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbsoluteOrderingPanel.this.bUpActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDown, (String)NbBundle.getMessage(AbsoluteOrderingPanel.class, (String)"BTN_Down"));
        this.bDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbsoluteOrderingPanel.this.bDownActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.jScrollPane2, 0, 0, Short.MAX_VALUE).add(2, (Component)this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.bRemove, -1, -1, Short.MAX_VALUE).add((Component)this.bEdit, -1, -1, Short.MAX_VALUE).add((Component)this.bAdd, -1, -1, Short.MAX_VALUE).add((Component)this.bDown, -1, -1, Short.MAX_VALUE).add((Component)this.bUp, -1, -1, Short.MAX_VALUE)).add(92, 92, 92)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.bAdd).addPreferredGap(0).add((Component)this.bEdit).addPreferredGap(0).add((Component)this.bRemove).addPreferredGap(0).add((Component)this.bUp).addPreferredGap(0).add((Component)this.bDown)).add((Component)this.jScrollPane2)).addContainerGap(31, Short.MAX_VALUE)));
    }

    private void bAddActionPerformed(ActionEvent actionEvent) {
        String string = this.getNameFromUser("");
        if (string != null) {
            this.listModel.addElement(string);
            this.refreshDdModel();
        }
    }

    private void bEditActionPerformed(ActionEvent actionEvent) {
        String string;
        int n = this.listOrdering.getSelectedIndex();
        if (n >= 0 && (string = this.getNameFromUser((String)this.listModel.get(n))) != null) {
            this.listModel.set(n, string);
            this.refreshDdModel();
        }
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.listOrdering.getSelectedIndex();
        if (n >= 0) {
            this.listModel.remove(n);
            this.refreshDdModel();
        }
    }

    private void bUpActionPerformed(ActionEvent actionEvent) {
        int n = this.listOrdering.getSelectedIndex();
        if (n > 0) {
            this.exchange(n - 1);
        }
        this.listOrdering.setSelectedIndex(n - 1);
        this.refreshDdModel();
    }

    private void bDownActionPerformed(ActionEvent actionEvent) {
        int n = this.listOrdering.getSelectedIndex();
        if (n >= 0 && n < this.listModel.size() - 1) {
            this.exchange(n);
        }
        this.listOrdering.setSelectedIndex(n + 1);
        this.refreshDdModel();
    }

    private String getNameFromUser(String string) {
        OrderingItemPanel orderingItemPanel = new OrderingItemPanel(string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)orderingItemPanel, NbBundle.getMessage(RelativeOrderingPanel.class, (String)"TTL_Ordering"));
        dialogDescriptor.createNotificationLineSupport();
        orderingItemPanel.setDlgSupport(dialogDescriptor);
        dialogDescriptor.setOptionType(2);
        if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor))) {
            return orderingItemPanel.getResult();
        }
        return null;
    }

    private void exchange(int n) {
        Object e = this.listModel.get(n);
        Object e2 = this.listModel.get(n + 1);
        this.listModel.set(n, e2);
        this.listModel.set(n + 1, e);
    }

    private void refreshDdModel() {
        try {
            AbsoluteOrdering absoluteOrdering = this.webApp.newAbsoluteOrdering();
            AbsoluteOrdering[] absoluteOrderingArray = new AbsoluteOrdering[1];
            String[] stringArray = new String[this.listModel.size()];
            int n = this.listModel.size();
            for (int i = 0; i < n; ++i) {
                stringArray[i] = (String)this.listModel.get(i);
            }
            absoluteOrdering.setName(stringArray);
            absoluteOrderingArray[0] = absoluteOrdering;
            this.webApp.setAbsoluteOrdering(absoluteOrderingArray);
            this.dObj.modelUpdatedFromUI();
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            Logger.global.log(Level.SEVERE, "refresh of DD model failed", versionNotSupportedException);
        }
    }
}

