/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import javax.swing.table.TableCellEditor;
import org.netbeans.modules.j2ee.dd.api.common.ResourceRef;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ResourceReferencesTableModel
extends InnerTableModel {
    private Ejb ejb;
    private static final int COLUMN_AUTHENTICATION = 2;
    private static final int COLUMN_SHAREABLE = 3;
    private static final String[] COLUMN_NAMES = new String[]{Utils.getBundleMessage("LBL_Name"), Utils.getBundleMessage("LBL_ResourceType"), Utils.getBundleMessage("LBL_Authentication"), Utils.getBundleMessage("LBL_Shareable"), Utils.getBundleMessage("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{100, 200, 120, 80, 150};

    public ResourceReferencesTableModel(XmlMultiViewDataSynchronizer xmlMultiViewDataSynchronizer, Ejb ejb) {
        super(xmlMultiViewDataSynchronizer, COLUMN_NAMES, COLUMN_WIDTHS);
        this.ejb = ejb;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ResourceRef resourceRef = this.ejb.getResourceRef(n);
        switch (n2) {
            case 0: {
                resourceRef.setResRefName((String)object);
                break;
            }
            case 1: {
                resourceRef.setResType((String)object);
                break;
            }
            case 2: {
                resourceRef.setResAuth((String)object);
                break;
            }
            case 3: {
                resourceRef.setResSharingScope((String)object);
                break;
            }
            case 4: {
                resourceRef.setDescription((String)object);
            }
        }
        this.modelUpdatedFromUI();
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        return this.ejb.getResourceRef().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ResourceRef resourceRef = this.ejb.getResourceRef(n);
        switch (n2) {
            case 0: {
                return resourceRef.getResRefName();
            }
            case 1: {
                return resourceRef.getResType();
            }
            case 2: {
                return resourceRef.getResAuth();
            }
            case 3: {
                return resourceRef.getResSharingScope();
            }
            case 4: {
                return resourceRef.getDefaultDescription();
            }
        }
        return null;
    }

    @Override
    public int addRow() {
        String string = Utils.getBundleMessage("LBL_ReferenceName_");
        String string2 = Utils.getBundleMessage("LBL_AddResourceReference");
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(string, string2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
        String string3 = inputLine.getInputText();
        return this.addRow(string3);
    }

    public int addRow(String string) {
        if (string != null && string.trim().length() > 0) {
            ResourceRef resourceRef = this.ejb.newResourceRef();
            resourceRef.setResRefName(string);
            this.ejb.addResourceRef(resourceRef);
            this.modelUpdatedFromUI();
        }
        int n = this.getRowCount() - 1;
        return n;
    }

    @Override
    public void removeRow(int n) {
        this.ejb.removeResourceRef(this.ejb.getResourceRef(n));
        this.modelUpdatedFromUI();
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 != 0;
    }

    @Override
    public TableCellEditor getTableCellEditor(int n) {
        if (n == 2) {
            return this.createComboBoxCellEditor(new Object[]{"Application", "Container"});
        }
        if (n == 3) {
            return this.createComboBoxCellEditor(new Object[]{"Shareable", "Unshareable"});
        }
        return null;
    }
}

