/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.dd.api.common.SecurityRole;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.ddloaders.multiview.InnerTableModel;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.EjbRefsTablePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRolePanel;
import org.netbeans.modules.j2ee.ddloaders.web.multiview.SecurityRoleTablePanel;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class EjbJarSecurityRolesTableModel
extends InnerTableModel {
    private static final String[] COLUMN_NAMES = new String[]{Utils.getBundleMessage("LBL_RoleName"), Utils.getBundleMessage("LBL_Description")};
    private static final int[] COLUMN_WIDTHS = new int[]{170, 250};
    private AssemblyDescriptor assemblyDesc;
    private EjbJar ejbJar;

    public EjbJarSecurityRolesTableModel(XmlMultiViewDataSynchronizer xmlMultiViewDataSynchronizer, EjbJar ejbJar) {
        super(xmlMultiViewDataSynchronizer, COLUMN_NAMES, COLUMN_WIDTHS);
        this.ejbJar = ejbJar;
        this.assemblyDesc = ejbJar.getSingleAssemblyDescriptor();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        SecurityRole securityRole = this.assemblyDesc.getSecurityRole(n);
        switch (n2) {
            case 0: {
                securityRole.setRoleName((String)object);
                break;
            }
            case 1: {
                securityRole.setDescription((String)object);
            }
        }
        this.modelUpdatedFromUI();
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public int getRowCount() {
        if (this.assemblyDesc == null) {
            return 0;
        }
        return this.assemblyDesc.getSecurityRole().length;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SecurityRole securityRole = this.assemblyDesc.getSecurityRole(n);
        switch (n2) {
            case 0: {
                return securityRole.getRoleName();
            }
            case 1: {
                return securityRole.getDefaultDescription();
            }
        }
        return null;
    }

    @Override
    public int addRow() {
        if (this.assemblyDesc == null) {
            this.assemblyDesc = this.getAssemblyDesc();
        }
        final SecurityRolePanel securityRolePanel = new SecurityRolePanel();
        Object var2_2 = null;
        EditDialog editDialog = new EditDialog(securityRolePanel, NbBundle.getMessage(EjbRefsTablePanel.class, (String)"TTL_SecurityRole"), true){

            protected String validate() {
                String string = securityRolePanel.getRoleName().trim();
                if (string.length() == 0) {
                    return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_EmptySecurityRoleName");
                }
                SecurityRole[] securityRoleArray = EjbJarSecurityRolesTableModel.this.assemblyDesc.getSecurityRole();
                boolean bl = false;
                for (int i = 0; i < securityRoleArray.length; ++i) {
                    if (!string.equals(securityRoleArray[i].getRoleName())) continue;
                    return NbBundle.getMessage(SecurityRoleTablePanel.class, (String)"TXT_SecurityRoleNameExists", (Object)string);
                }
                return null;
            }
        };
        editDialog.setValid(false);
        EditDialog.DocListener docListener = new EditDialog.DocListener(editDialog);
        securityRolePanel.getRoleNameTF().getDocument().addDocumentListener((DocumentListener)docListener);
        securityRolePanel.getDescriptionTA().getDocument().addDocumentListener((DocumentListener)docListener);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)editDialog);
        dialog.setVisible(true);
        securityRolePanel.getRoleNameTF().getDocument().removeDocumentListener((DocumentListener)docListener);
        securityRolePanel.getDescriptionTA().getDocument().removeDocumentListener((DocumentListener)docListener);
        if (editDialog.getValue().equals(EditDialog.OK_OPTION)) {
            SecurityRole securityRole = this.assemblyDesc.newSecurityRole();
            securityRole.setRoleName(securityRolePanel.getRoleName());
            securityRole.setDescription(securityRolePanel.getDescription());
            this.assemblyDesc.addSecurityRole(securityRole);
            this.modelUpdatedFromUI();
        }
        return this.getRowCount() - 1;
    }

    @Override
    public void removeRow(int n) {
        SecurityRole securityRole = this.assemblyDesc.getSecurityRole(n);
        this.assemblyDesc.removeSecurityRole(securityRole);
        this.modelUpdatedFromUI();
    }

    private AssemblyDescriptor getAssemblyDesc() {
        AssemblyDescriptor assemblyDescriptor = this.ejbJar.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = this.ejbJar.newAssemblyDescriptor();
            this.ejbJar.setAssemblyDescriptor(assemblyDescriptor);
        }
        return assemblyDescriptor;
    }
}

