/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedElement;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.php.findusages.WhereUsedSupport;
import org.netbeans.modules.refactoring.spi.ProgressProviderAdapter;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.openide.filesystems.FileObject;

public class PhpWhereUsedQueryPlugin
extends ProgressProviderAdapter
implements RefactoringPlugin {
    private WhereUsedQuery refactoring;
    private WhereUsedSupport usages;

    public PhpWhereUsedQueryPlugin(WhereUsedQuery refactoring) {
        this.refactoring = refactoring;
        this.usages = (WhereUsedSupport)refactoring.getRefactoringSource().lookup(WhereUsedSupport.class);
    }

    public Problem prepare(RefactoringElementsBag elementsBag) {
        if (this.isFindOverridingMethods()) {
            this.usages.overridingMethods();
        }
        if (this.isFindSubclasses()) {
            this.usages.collectSubclasses();
        } else if (this.isFindDirectSubclassesOnly()) {
            this.usages.collectDirectSubclasses();
        } else if (this.isFindUsages()) {
            Set<FileObject> relevantFiles = this.usages.getRelevantFiles();
            this.fireProgressListenerStart(1, relevantFiles.size());
            for (FileObject fileObject : relevantFiles) {
                if (fileObject == null) continue;
                this.usages.collectUsages(fileObject);
                this.fireProgressListenerStep();
            }
        }
        WhereUsedSupport.Results results = this.usages.getResults();
        Collection<WhereUsedElement> resultElements = results.getResultElements();
        for (WhereUsedElement whereUsedElement : resultElements) {
            elementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)whereUsedElement);
        }
        this.fireProgressListenerStop();
        return null;
    }

    private boolean isFindSubclasses() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_SUBCLASSES);
    }

    private boolean isFindUsages() {
        return this.refactoring.getBooleanValue((Object)"FIND_REFERENCES");
    }

    private boolean isFindDirectSubclassesOnly() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_DIRECT_SUBCLASSES);
    }

    private boolean isFindOverridingMethods() {
        return this.refactoring.getBooleanValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS);
    }

    private boolean isSearchInComments() {
        return this.refactoring.getBooleanValue((Object)"SEARCH_IN_COMMENTS");
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }
}

