/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.openide.util.Lookup;

public abstract class PresentersProcessor {
    private static final Lookup.Result<PresentersProcessor> result = Lookup.getDefault().lookupResult(PresentersProcessor.class);
    private String projectType;

    protected PresentersProcessor(String projectType) {
        this.projectType = projectType;
    }

    final String getProjectType() {
        return this.projectType;
    }

    protected abstract void postProcessPresenters(DesignDocument var1, ComponentDescriptor var2, ArrayList<Presenter> var3);

    static void postProcessDescriptor(String projectType, DesignDocument document, ComponentDescriptor descriptor, ArrayList<Presenter> presenters) {
        assert (Debug.isFriend(DesignComponent.class, "setComponentDescriptor"));
        for (PresentersProcessor processor : result.allInstances()) {
            if (!projectType.equals(processor.getProjectType())) continue;
            processor.postProcessPresenters(document, descriptor, presenters);
        }
    }
}

