/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.GlobalDescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.VersionDescriptor;

public abstract class ComponentDescriptor {
    private Collection<PropertyDescriptor> propertyDescriptors;
    private ComponentDescriptor superDescriptor;

    public final ComponentDescriptor getSuperDescriptor() {
        return this.superDescriptor;
    }

    public final Collection<PropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public final PropertyDescriptor getPropertyDescriptor(String propertyName) {
        for (PropertyDescriptor propertyDescriptor : this.getPropertyDescriptors()) {
            if (!propertyName.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        return null;
    }

    final void setSuperComponentDescriptor(ComponentDescriptor superDescriptor) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "resolveDescriptor") || Debug.isFriend(GlobalDescriptorRegistry.class, "reloadCore") || Debug.isFriend(DescriptorRegistry.class, "reloadCore"));
        this.superDescriptor = superDescriptor;
    }

    final void setPropertyDescriptors(Collection<PropertyDescriptor> propertyDescriptors) {
        assert (Debug.isFriend(GlobalDescriptorRegistry.class, "resolveDescriptor") || Debug.isFriend(GlobalDescriptorRegistry.class, "reloadCore") || Debug.isFriend(DescriptorRegistry.class, "reloadCore"));
        this.propertyDescriptors = propertyDescriptors == null ? null : Collections.unmodifiableCollection(new ArrayList<PropertyDescriptor>(propertyDescriptors));
    }

    public final String toString() {
        TypeDescriptor typeDescriptor = this.getTypeDescriptor();
        if (typeDescriptor == null) {
            return super.toString();
        }
        return typeDescriptor.getThisType().toString();
    }

    public void postInitialize(DesignComponent component) {
    }

    public abstract TypeDescriptor getTypeDescriptor();

    public abstract VersionDescriptor getVersionDescriptor();

    public Collection<String> getExcludedPropertyDescriptorNames() {
        return null;
    }

    public abstract List<PropertyDescriptor> getDeclaredPropertyDescriptors();

    public PaletteDescriptor getPaletteDescriptor() {
        return null;
    }

    protected void gatherPresenters(ArrayList<Presenter> presenters) {
        List<? extends Presenter> array = this.createPresenters();
        if (array != null) {
            for (Presenter presenter : array) {
                if (presenter != null) {
                    presenters.add(presenter);
                    continue;
                }
                Debug.warning("Null presenter", this);
            }
        }
    }

    protected abstract List<? extends Presenter> createPresenters();
}

