/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints.customizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ActionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.common.breakpoints.customizers.ControllerProvider;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LineBreakpointPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private final LBController controller = new LBController();
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();
    private JLabel lFileName;
    private JLabel lLineNumber;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint b) {
        String mime = null;
        String url = b.getURL();
        this.breakpoint = b;
        this.initComponents();
        try {
            FileObject fo = URLMapper.findFileObject((URL)new URL(url));
            if (fo != null) {
                mime = fo.getMIMEType();
            }
        }
        catch (MalformedURLException mue) {
            // empty catch block
        }
        if (url.length() > 0 && MIMENames.isFortranOrHeaderOrCppOrC(mime)) {
            try {
                URI uri = new URI(url);
                String path = uri.getPath();
                if (Utilities.isWindows() && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                this.tfFileName.setText(path);
            }
            catch (Exception e) {
                this.tfFileName.setText(url);
            }
        } else {
            this.tfFileName.setEditable(true);
        }
        if (b.getLineNumber() > 0) {
            this.tfLineNumber.setText(Integer.toString(b.getLineNumber()));
        }
        this.conditionsPanel = new ConditionsPanel(b);
        this.pConditions.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel(b);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.tfFileName.getDocument().addDocumentListener(this.validityDocumentListener);
        this.tfLineNumber.getDocument().addDocumentListener(this.validityDocumentListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineBreakpointPanel.this.controller.checkValid();
            }
        });
    }

    private static LineBreakpoint createBreakpoint() {
        String url = EditorContextBridge.getMostRecentURL();
        int lnum = EditorContextBridge.getMostRecentLineNumber();
        LineBreakpoint lb = url.length() != 0 ? LineBreakpoint.create(url, lnum) : LineBreakpoint.create();
        return lb;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineGDB");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lFileName = new JLabel();
        this.tfFileName = new JTextField();
        this.lLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 105));
        this.pSettings.setPreferredSize(new Dimension(144, 105));
        this.pSettings.setLayout(new GridBagLayout());
        this.lFileName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.lFileName.setLabelFor(this.tfFileName);
        this.lFileName.setText(bundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lFileName, gridBagConstraints);
        this.lFileName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(bundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.tfFileName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.lLineNumber.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/common/breakpoints/customizers/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.lLineNumber.setLabelFor(this.tfLineNumber);
        this.lLineNumber.setText(bundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lLineNumber, gridBagConstraints);
        this.lLineNumber.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(bundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }
    }

    private class LBController
    implements Controller {
        private boolean valid;
        private String errMsg = null;

        private LBController() {
        }

        public boolean ok() {
            if (!this.valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.errMsg));
                return false;
            }
            String path = LineBreakpointPanel.this.tfFileName.getText().trim();
            path = this.correctURL(path);
            LineBreakpointPanel.this.breakpoint.setURL(path);
            LineBreakpointPanel.this.breakpoint.setLineNumber(Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim()));
            LineBreakpointPanel.this.conditionsPanel.ok();
            LineBreakpointPanel.this.actionsPanel.ok();
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            Breakpoint[] bs = dm.getBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                String condition;
                String url;
                if (!(bs[i] instanceof LineBreakpoint)) continue;
                LineBreakpoint lb = (LineBreakpoint)bs[i];
                if (LineBreakpointPanel.this.breakpoint.getLineNumber() != lb.getLineNumber() || !(url = LineBreakpointPanel.this.breakpoint.getURL()).equals(lb.getURL()) || ((condition = LineBreakpointPanel.this.breakpoint.getCondition()) == null ? lb.getCondition() != null : !condition.equals(lb.getCondition()))) continue;
                if (!lb.isEnabled()) {
                    bs[i].enable();
                }
                return true;
            }
            if (LineBreakpointPanel.this.createBreakpoint) {
                dm.addBreakpoint((Breakpoint)LineBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        private String correctURL(String path) {
            String slash;
            String string = slash = Utilities.isWindows() ? "/" : "";
            if (new File(path).exists()) {
                path = "file:" + slash + path;
            }
            return path;
        }

        public boolean cancel() {
            return true;
        }

        private void checkValid() {
            int line;
            String path = LineBreakpointPanel.this.tfFileName.getText().trim();
            if (path.length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                path = this.correctURL(path);
                URL url = new URL(path);
                try {
                    File f = new File(url.toURI());
                    if (!f.isFile()) {
                        this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                        this.setValid(false);
                        return;
                    }
                }
                catch (IllegalArgumentException iaex) {}
            }
            catch (MalformedURLException ex) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                this.setValid(false);
                return;
            }
            catch (URISyntaxException ex) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_Malformed_File_Spec"));
                this.setValid(false);
                return;
            }
            catch (IOException ioex) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_Invalid_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                line = Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim());
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            if (line <= 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }

        private void setErrorMessage(String msg) {
            this.errMsg = msg;
            LineBreakpointPanel.this.firePropertyChange("errorNotification", null, msg);
        }

        private void setValid(boolean valid) {
            this.valid = valid;
            LineBreakpointPanel.this.firePropertyChange("valid", !valid, valid);
        }

        public boolean isValid() {
            return this.valid;
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            LineBreakpointPanel.this.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            LineBreakpointPanel.this.removePropertyChangeListener(l);
        }
    }
}

