/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineTranslations;
import org.netbeans.modules.cnd.debugger.common.breakpoints.SessionBreakpointAnnotationProvider;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private final Map<CndBreakpoint, Set<Annotation>> breakpointToAnnotations = new HashMap<CndBreakpoint, Set<Annotation>>();
    private final Set<FileObject> annotatedFiles = new WeakSet();
    private Set<PropertyChangeListener> dataObjectListeners;
    private boolean attachManagerListener = true;
    private final Logger log = Logger.getLogger("cnd.breakpoint.annotations");
    private final RequestProcessor annotationProcessor = new RequestProcessor("Annotation Refresh", 1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fo = (FileObject)lookup.lookup(FileObject.class);
        if (fo != null) {
            DataObject dobj = (DataObject)lookup.lookup(DataObject.class);
            if (dobj != null) {
                PropertyChangeListener pchl = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("primaryFile".equals(evt.getPropertyName())) {
                            DataObject dobj = (DataObject)evt.getSource();
                            final FileObject newFO = dobj.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotationProcessor.post(new Runnable(){

                                @Override
                                public void run() {
                                    BreakpointAnnotationProvider.this.annotate(newFO);
                                }
                            });
                        }
                    }
                };
                dobj.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)pchl, (Object)dobj));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(pchl);
                }
            }
            this.annotate(fo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(FileObject fo) {
        Map<CndBreakpoint, Set<Annotation>> map = this.breakpointToAnnotations;
        synchronized (map) {
            if (this.annotatedFiles.contains(fo)) {
                this.log.fine("BreakpointAnnotationProvider.annotate: " + fo.getNameExt() + " is already annotated");
                return;
            }
            Set<CndBreakpoint> annotatedBreakpoints = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                CndBreakpoint b = (CndBreakpoint)breakpoint;
                if (!annotatedBreakpoints.contains((Object)b)) {
                    b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet());
                    if (b instanceof LineBreakpoint) {
                        LineBreakpoint lb = (LineBreakpoint)b;
                        LineTranslations.getTranslations().registerForLineUpdates(lb);
                    }
                }
                this.addAnnotationTo(b, fo);
            }
            this.annotatedFiles.add(fo);
        }
        if (this.attachManagerListener) {
            this.attachManagerListener = false;
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            CndBreakpoint b = (CndBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointAdded: " + b.getPath() + ":" + b.getLineNumber());
            b.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, false, true));
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().registerForLineUpdates(lb);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            CndBreakpoint b = (CndBreakpoint)breakpoint;
            this.log.fine("BreakpointAnnotationProvider.breakpointRemoved: " + b.getPath() + ":" + b.getLineNumber());
            b.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, true, false));
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lb);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if ("currentSession".equals(propertyName)) {
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!(breakpoint instanceof CndBreakpoint)) continue;
                this.annotationProcessor.post((Runnable)new AnnotationRefresh((CndBreakpoint)breakpoint, true, true));
            }
            return;
        }
        if (!("enabled".equals(propertyName) || "validity".equals(propertyName) || "condition".equals(propertyName) || "skipCount".equals(propertyName) || "url".equals(propertyName) || "functionName".equals(propertyName) || "lineNumber".equals(propertyName) || "address".equals(propertyName) || "refresh".equals(propertyName))) {
            return;
        }
        CndBreakpoint b = (CndBreakpoint)((Object)evt.getSource());
        boolean found = false;
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (b != breakpoint) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.annotationProcessor.post((Runnable)new AnnotationRefresh(b, true, true));
    }

    private static boolean isAnnotatable(Breakpoint b) {
        return (b instanceof LineBreakpoint || b instanceof FunctionBreakpoint || b instanceof AddressBreakpoint) && !((CndBreakpoint)b).isHidden();
    }

    public static String getAnnotationType(CndBreakpoint b) {
        String annotationType;
        boolean isConditional;
        String condition = b.getCondition();
        boolean bl = isConditional = condition != null && condition.trim().length() > 0;
        if (b instanceof LineBreakpoint) {
            annotationType = b.isEnabled() ? (isConditional ? "CondBreakpoint" : "Breakpoint") : (isConditional ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (b instanceof FunctionBreakpoint) {
            annotationType = b.isEnabled() ? "FunctionBreakpoint" : "DisabledFunctionBreakpoint";
        } else if (b instanceof AddressBreakpoint) {
            annotationType = b.isEnabled() ? "AddressBreakpoint" : "DisabledAddressBreakpoint";
        } else {
            throw new IllegalStateException(((Object)((Object)b)).toString());
        }
        return annotationType;
    }

    private static int[] getAnnotationLines(CndBreakpoint b, FileObject fo) {
        SessionBreakpointAnnotationProvider bptLinesProvider;
        if (b instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)b;
            try {
                if (fo.getURL().equals(new URL(lb.getURL()))) {
                    return new int[]{lb.getLineNumber()};
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine != null && (bptLinesProvider = (SessionBreakpointAnnotationProvider)currentEngine.lookupFirst(null, SessionBreakpointAnnotationProvider.class)) != null) {
            return bptLinesProvider.getBreakpointAnnotationLines(b, fo);
        }
        return null;
    }

    private void addAnnotationTo(CndBreakpoint b, FileObject fo) {
        DataObject dataObject;
        SessionBreakpointAnnotationProvider bptLinesProvider;
        int[] lines = BreakpointAnnotationProvider.getAnnotationLines(b, fo);
        if (lines == null || lines.length == 0) {
            return;
        }
        this.log.fine("BreakpointAnnotationProvider.addAnnotationTo: " + b.getPath() + ":" + b.getLineNumber());
        String annotationType = BreakpointAnnotationProvider.getAnnotationType(b);
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine != null && (bptLinesProvider = (SessionBreakpointAnnotationProvider)currentEngine.lookupFirst(null, SessionBreakpointAnnotationProvider.class)) != null) {
            annotationType = bptLinesProvider.getAnnotationType(b);
        }
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException donfex) {
            donfex.printStackTrace();
            return;
        }
        LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lc == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> annotations = new ArrayList<DebuggerBreakpointAnnotation>();
        for (int l : lines) {
            try {
                Line line = lc.getLineSet().getCurrent(l - 1);
                DebuggerBreakpointAnnotation annotation = new DebuggerBreakpointAnnotation(annotationType, line, b);
                annotations.add(annotation);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if (annotations.isEmpty()) {
            return;
        }
        Set<Annotation> bpAnnotations = this.breakpointToAnnotations.get((Object)b);
        if (bpAnnotations == null) {
            this.breakpointToAnnotations.put(b, (Set<Annotation>)new WeakSet(annotations));
        } else {
            bpAnnotations.addAll(annotations);
            this.breakpointToAnnotations.put(b, bpAnnotations);
        }
    }

    private void removeAnnotations(CndBreakpoint b) {
        Set<Annotation> annotations = this.breakpointToAnnotations.remove((Object)b);
        if (annotations == null) {
            return;
        }
        for (Annotation a : annotations) {
            a.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine engine) {
    }

    public void engineRemoved(DebuggerEngine engine) {
    }

    private final class AnnotationRefresh
    implements Runnable {
        private CndBreakpoint b;
        private boolean remove;
        private boolean add;

        public AnnotationRefresh(CndBreakpoint b, boolean remove, boolean add) {
            this.b = b;
            this.remove = remove;
            this.add = add;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.remove) {
                    BreakpointAnnotationProvider.this.removeAnnotations(this.b);
                    if (!this.add) {
                        BreakpointAnnotationProvider.this.breakpointToAnnotations.remove((Object)this.b);
                    }
                }
                if (this.add) {
                    BreakpointAnnotationProvider.this.breakpointToAnnotations.put(this.b, new WeakSet());
                    for (FileObject fo : BreakpointAnnotationProvider.this.annotatedFiles) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(this.b, fo);
                    }
                }
            }
        }
    }
}

