/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class Util {
    private Util() {
    }

    static ClassPath createClassPath(String classpath) {
        Parameters.notNull((CharSequence)"classpath", (Object)classpath);
        StringTokenizer tokenizer = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<PathResourceImplementation> list = new ArrayList<PathResourceImplementation>();
        while (tokenizer.hasMoreTokens()) {
            String item = tokenizer.nextToken();
            File f = FileUtil.normalizeFile((File)new File(item));
            URL url = Util.getRootURL(f);
            if (url == null) continue;
            list.add(ClassPathSupport.createResource((URL)url));
        }
        return ClassPathSupport.createClassPath(list);
    }

    static URL getRootURL(File f) {
        try {
            URL url = f.toURI().toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!f.exists()) {
                String surl = url.toExternalForm();
                if (!surl.endsWith("/")) {
                    url = new URL(surl + "/");
                }
            } else if (f.isFile()) {
                try {
                    ZipFile z = new ZipFile(f);
                    z.close();
                    url = FileUtil.getArchiveRoot((URL)url);
                }
                catch (IOException e) {
                    url = null;
                }
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String normalizeName(String displayName) {
        StringBuffer normalizedName = new StringBuffer();
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                normalizedName.append(c);
                continue;
            }
            normalizedName.append('_');
        }
        return normalizedName.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform plat) {
        String version = (String)plat.getSystemProperties().get("java.specification.version");
        if (version == null) {
            version = "1.1";
        }
        return Util.makeSpec(version);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders) {
        return Util.findTool(toolName, installFolders, null);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders, String archFolderName) {
        assert (toolName != null);
        for (FileObject root : installFolders) {
            FileObject tool;
            FileObject bin = root.getFileObject("bin");
            if (bin == null || archFolderName != null && (bin = bin.getFileObject(archFolderName)) == null || (tool = bin.getFileObject(toolName, Utilities.isWindows() ? "exe" : null)) == null) continue;
            return tool;
        }
        return null;
    }

    public static String getExtensions(String extPath) {
        if (extPath == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tk = new StringTokenizer(extPath, File.pathSeparator);
        while (tk.hasMoreTokens()) {
            File extFolder = FileUtil.normalizeFile((File)new File(tk.nextToken()));
            File[] files = extFolder.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.exists()) {
                    ErrorManager.getDefault().log(16, MessageFormat.format(NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), f, extFolder));
                    continue;
                }
                if (Utilities.isMac() && "._.DS_Store".equals(f.getName())) continue;
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo == null) {
                    Logger.getLogger(Util.class.getName()).warning("Cannot create FileObject for file: " + f.getAbsolutePath() + " exists: " + f.exists());
                    continue;
                }
                if (!FileUtil.isArchiveFile((FileObject)fo)) continue;
                sb.append(File.pathSeparator);
                sb.append(files[i].getAbsolutePath());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(File.pathSeparator.length());
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion(vers);
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }
}

