/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class JavadocForBinaryQueryPlatformImpl
implements JavadocForBinaryQueryImplementation {
    private static final int STATE_ERROR = -1;
    private static final int STATE_START = 0;
    private static final int STATE_DOCS = 1;
    private static final int STATE_LAN = 2;
    private static final int STATE_API = 3;
    private static final int STATE_INDEX = 4;
    private static final String NAME_DOCS = "docs";
    private static final String NAME_API = "api";
    private static final String NAME_IDNEX = "index-files";
    private static Set<String> locales;

    public JavadocForBinaryQuery.Result findJavadoc(URL b) {
        JavaPlatformManager jpm = JavaPlatformManager.getDefault();
        JavaPlatform[] platforms = jpm.getInstalledPlatforms();
        for (int i = 0; i < platforms.length; ++i) {
            JavaPlatform jp = platforms[i];
            for (ClassPath.Entry entry : jp.getBootstrapLibraries().entries()) {
                if (!b.equals(entry.getURL())) continue;
                class R
                implements JavadocForBinaryQuery.Result,
                PropertyChangeListener {
                    private JavaPlatform platform;
                    private final ChangeSupport cs = new ChangeSupport((Object)this);
                    private URL[] cachedRoots;

                    public R(JavaPlatform plat) {
                        this.platform = plat;
                        this.platform.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.platform));
                    }

                    public synchronized URL[] getRoots() {
                        if (this.cachedRoots == null) {
                            ArrayList<URL> l = new ArrayList<URL>();
                            for (URL u : this.platform.getJavadocFolders()) {
                                if (u == null) continue;
                                FileObject root = URLMapper.findFileObject((URL)u);
                                if (root == null) {
                                    l.add(u);
                                    continue;
                                }
                                if (root.isFolder()) {
                                    try {
                                        l.add(JavadocForBinaryQueryPlatformImpl.getIndexFolder(root));
                                    }
                                    catch (FileStateInvalidException e) {
                                        Exceptions.printStackTrace((Throwable)e);
                                    }
                                    continue;
                                }
                                Logger.getLogger(JavadocForBinaryQueryPlatformImpl.class.getName()).warning("Ignoring non folder root: " + FileUtil.getFileDisplayName((FileObject)root));
                            }
                            this.cachedRoots = l.toArray(new URL[l.size()]);
                        }
                        return this.cachedRoots;
                    }

                    public synchronized void addChangeListener(ChangeListener l) {
                        assert (l != null) : "Listener can not be null";
                        this.cs.addChangeListener(l);
                    }

                    public synchronized void removeChangeListener(ChangeListener l) {
                        assert (l != null) : "Listener can not be null";
                        this.cs.removeChangeListener(l);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void propertyChange(PropertyChangeEvent event) {
                        if ("javadocFolders".equals(event.getPropertyName())) {
                            R r = this;
                            synchronized (r) {
                                this.cachedRoots = null;
                            }
                            this.cs.fireChange();
                        }
                    }
                }
                return new R(jp);
            }
        }
        return null;
    }

    private static URL getIndexFolder(FileObject root) throws FileStateInvalidException {
        FileObject result = JavadocForBinaryQueryPlatformImpl.findIndexFolder(root);
        return result == null ? root.getURL() : result.getURL();
    }

    static FileObject findIndexFolder(FileObject fo) {
        int state = 0;
        while (state != -1 && state != 4) {
            switch (state) {
                case 0: {
                    FileObject tmpFo = fo.getFileObject(NAME_DOCS);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 1;
                        break;
                    }
                    tmpFo = fo.getFileObject(NAME_API);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 3;
                        break;
                    }
                    tmpFo = JavadocForBinaryQueryPlatformImpl.getLocalization(fo);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 2;
                        break;
                    }
                    fo = null;
                    state = -1;
                    break;
                }
                case 1: {
                    FileObject tmpFo = fo.getFileObject(NAME_API);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 3;
                        break;
                    }
                    tmpFo = JavadocForBinaryQueryPlatformImpl.getLocalization(fo);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 2;
                        break;
                    }
                    fo = null;
                    state = -1;
                    break;
                }
                case 2: {
                    FileObject tmpFo = fo.getFileObject(NAME_API);
                    if (tmpFo != null) {
                        fo = tmpFo;
                        state = 3;
                        break;
                    }
                    fo = null;
                    state = -1;
                    break;
                }
                case 3: {
                    FileObject tmpFo = fo.getFileObject(NAME_IDNEX);
                    if (tmpFo != null) {
                        state = 4;
                        break;
                    }
                    fo = null;
                    state = -1;
                    break;
                }
            }
        }
        return fo;
    }

    private static FileObject getLocalization(FileObject root) {
        FileObject[] children = root.getChildren();
        if (children.length == 0) {
            return null;
        }
        if (children.length == 1) {
            return children[0];
        }
        HashSet<FileObject> candidates = new HashSet<FileObject>();
        for (FileObject fo : children) {
            if (!fo.isFolder() || fo.getName().charAt(0) == '.') continue;
            candidates.add(fo);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return (FileObject)candidates.iterator().next();
        }
        Set<String> locales = JavadocForBinaryQueryPlatformImpl.getLocales();
        for (FileObject fo : candidates) {
            if (!locales.contains(fo.getName())) continue;
            return fo;
        }
        return null;
    }

    private static synchronized Set<String> getLocales() {
        if (locales == null) {
            Locale[] locs = Locale.getAvailableLocales();
            locales = new HashSet<String>();
            for (Locale l : locs) {
                locales.add(l.toString());
            }
        }
        return locales;
    }
}

