/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.modules.junit.GuiUtils;
import org.netbeans.modules.junit.NamedObject;
import org.netbeans.modules.junit.SizeRestrictedPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SettingsPanel
extends JPanel {
    private JLabel lblProjectName;
    private JLabel lblTestFileName;
    private JComboBox cboTemplate;

    public SettingsPanel(String projectName, String testFileName, String defaultTemplate, JComponent optionsPanel) {
        ResourceBundle bundle = NbBundle.getBundle(SettingsPanel.class);
        JLabel lblProject = new JLabel();
        JLabel lblFileName = new JLabel();
        JLabel lblTemplate = new JLabel();
        Mnemonics.setLocalizedText((JLabel)lblProject, (String)bundle.getString("LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)lblFileName, (String)bundle.getString("LBL_Filename"));
        Mnemonics.setLocalizedText((JLabel)lblTemplate, (String)bundle.getString("LBL_Template"));
        this.lblProjectName = new JLabel(projectName);
        this.lblTestFileName = new JLabel(testFileName);
        this.cboTemplate = GuiUtils.createTemplateChooser(defaultTemplate);
        lblProject.setLabelFor(this.lblProjectName);
        lblFileName.setLabelFor(this.lblTestFileName);
        lblTemplate.setLabelFor(this.cboTemplate);
        AccessibleContext accessCtx = this.lblProjectName.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("AD_Name_Project_name"));
        accessCtx.setAccessibleDescription(bundle.getString("AD_Descr_Project_name"));
        accessCtx = this.lblTestFileName.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("AD_Name_Test_class_file_name"));
        accessCtx.setAccessibleDescription(bundle.getString("AD_Descr_Test_class_file_name"));
        accessCtx = this.cboTemplate.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("AD_Name_Test_class_template"));
        accessCtx.setAccessibleDescription(bundle.getString("AD_Descr_Test_class_template"));
        bundle = null;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 6, 12);
        this.add((Component)lblProject, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.lblProjectName, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 12);
        this.add((Component)lblFileName, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.lblTestFileName, gbc);
        ++gbc.gridy;
        gbc.fill = 2;
        gbc.insets = new Insets(12, 0, 18, 0);
        this.add((Component)this.createSeparator(), gbc);
        gbc.fill = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 11, 12);
        this.add((Component)lblTemplate, gbc);
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 0, 11, 0);
        this.add((Component)this.cboTemplate, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)optionsPanel, gbc);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        this.add((Component)new JPanel(), gbc);
    }

    void setProjectName(String projectName) {
        this.lblProjectName.setText(projectName);
    }

    void setTestFileName(String testFileName) {
        this.lblTestFileName.setText(testFileName);
    }

    FileObject getTemplate() {
        Object selectedObject = this.cboTemplate.getSelectedItem();
        if (selectedObject == null) {
            return null;
        }
        return (FileObject)((NamedObject)selectedObject).object;
    }

    void selectTemplate(String templatePath) {
        if (templatePath == null) {
            return;
        }
        ComboBoxModel model = this.cboTemplate.getModel();
        int itemsCount = model.getSize();
        if (itemsCount == 0) {
            return;
        }
        for (int i = 0; i < itemsCount; ++i) {
            NamedObject namedObj = (NamedObject)model.getElementAt(i);
            FileObject template = (FileObject)namedObj.object;
            if (!template.getPath().equals(templatePath)) continue;
            this.cboTemplate.setSelectedIndex(i);
            return;
        }
    }

    private JComponent createSeparator() {
        SizeRestrictedPanel panel = new SizeRestrictedPanel(false, true);
        panel.setPreferredSize(new Dimension(1, 1));
        panel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getDefaults().getColor("Label.foreground")));
        return panel;
    }
}

