/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.FileOwnerQueryImplementation;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class MavenFileOwnerQueryImpl
implements FileOwnerQueryImplementation {
    private Set<NbMavenProjectImpl> set;
    private final Object setLock = new Object();
    private Set<NbMavenProjectImpl> cachedProjects = null;
    private Set<NbMavenProjectImpl> projectsToAddToCache = null;
    private final Object cacheLock = new Object();
    private PropertyChangeListener projectListener;
    private final List<ChangeListener> listeners;
    private static final Logger LOG = Logger.getLogger(MavenFileOwnerQueryImpl.class.getName());

    public MavenFileOwnerQueryImpl() {
        this.set = new HashSet<NbMavenProjectImpl>();
        this.listeners = new ArrayList<ChangeListener>();
        this.projectListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object evtSource;
                if ("MavenProject".equals(evt.getPropertyName()) && (evtSource = evt.getSource()) instanceof NbMavenProjectImpl) {
                    Object object = MavenFileOwnerQueryImpl.this.cacheLock;
                    synchronized (object) {
                        if (null == MavenFileOwnerQueryImpl.this.projectsToAddToCache) {
                            MavenFileOwnerQueryImpl.this.projectsToAddToCache = new HashSet(1);
                        }
                        MavenFileOwnerQueryImpl.this.projectsToAddToCache.add((NbMavenProjectImpl)evtSource);
                    }
                }
            }
        };
    }

    public static MavenFileOwnerQueryImpl getInstance() {
        Lookup.Result implementations = Lookup.getDefault().lookup(new Lookup.Template(FileOwnerQueryImplementation.class));
        for (FileOwnerQueryImplementation obj : implementations.allInstances()) {
            if (!(obj instanceof MavenFileOwnerQueryImpl)) continue;
            return (MavenFileOwnerQueryImpl)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMavenProject(NbMavenProjectImpl project) {
        Object object = this.setLock;
        synchronized (object) {
            if (!this.set.contains(project)) {
                LOG.fine("Adding Maven project:" + project.getArtifactRelativeRepositoryPath());
                this.set.add(project);
                NbMavenProject.addPropertyChangeListener(project, this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            if (null != this.cachedProjects && !this.cachedProjects.contains(project)) {
                if (null == this.projectsToAddToCache) {
                    this.projectsToAddToCache = new HashSet<NbMavenProjectImpl>(1);
                }
                this.projectsToAddToCache.add(project);
            }
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMavenProject(NbMavenProjectImpl project) {
        Object object = this.setLock;
        synchronized (object) {
            if (this.set.contains(project)) {
                LOG.fine("Removing Maven project:" + project.getArtifactRelativeRepositoryPath());
                this.set.remove(project);
                NbMavenProject.removePropertyChangeListener(project, this.projectListener);
            }
        }
        object = this.cacheLock;
        synchronized (object) {
            this.cachedProjects = null;
        }
        this.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.add(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener list) {
        List<ChangeListener> list2 = this.listeners;
        synchronized (list2) {
            this.listeners.remove(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> lst = new ArrayList<ChangeListener>();
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            lst.addAll(this.listeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener change : lst) {
            change.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Project> getOpenedProjects() {
        Object object = this.setLock;
        synchronized (object) {
            return new HashSet<Project>(this.set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<FileObject> getOpenedProjectRoots() {
        HashSet<FileObject> toRet = new HashSet<FileObject>();
        Object object = this.setLock;
        synchronized (object) {
            for (NbMavenProjectImpl prj : this.set) {
                toRet.add(prj.getProjectDirectory());
            }
        }
        return toRet;
    }

    public Project getOwner(URI uri) {
        LOG.finest("getOwner of uri=" + uri);
        if (uri.getScheme() != null && "file".equals(uri.getScheme())) {
            File file = new File(uri);
            return this.getOwner(file);
        }
        return null;
    }

    public Project getOwner(FileObject fileObject) {
        LOG.finest("getOwner of fileobject=" + fileObject);
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.getOwner(file);
        }
        return null;
    }

    private Project getOwner(File file) {
        File parentArt;
        LOG.fine("Looking for owner of " + file.getAbsolutePath());
        boolean passBasicCheck = false;
        String nm = file.getName();
        File parentVer = file.getParentFile();
        if (parentVer != null && (parentArt = parentVer.getParentFile()) != null && nm.startsWith(parentArt.getName() + "-" + parentVer.getName())) {
            passBasicCheck = true;
        }
        if (!passBasicCheck) {
            LOG.fine(" exiting early, not from local repository.");
            return null;
        }
        Set<NbMavenProjectImpl> currentProjects = this.getAllKnownProjects();
        Iterator<NbMavenProjectImpl> it = currentProjects.iterator();
        String filepath = file.getAbsolutePath().replace('\\', '/');
        while (it.hasNext()) {
            NbMavenProjectImpl project = it.next();
            String path = project.getArtifactRelativeRepositoryPath();
            LOG.finest("matching againts known project " + path);
            if (filepath.endsWith(path)) {
                return project;
            }
            path = project.getTestArtifactRelativeRepositoryPath();
            LOG.finest("matching againts known project's test " + path);
            if (!filepath.endsWith(path)) continue;
            return project;
        }
        return null;
    }

    private Set<NbMavenProjectImpl> getAllKnownProjects() {
        return (Set)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Set<NbMavenProjectImpl>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Set<NbMavenProjectImpl> run() {
                Object object = MavenFileOwnerQueryImpl.this.cacheLock;
                synchronized (object) {
                    NbMavenProjectImpl prj;
                    int index;
                    ArrayList iterating;
                    HashSet currentProjects;
                    if (MavenFileOwnerQueryImpl.this.cachedProjects != null && null == MavenFileOwnerQueryImpl.this.projectsToAddToCache) {
                        return new HashSet<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.cachedProjects);
                    }
                    if (null == MavenFileOwnerQueryImpl.this.cachedProjects) {
                        Object object2 = MavenFileOwnerQueryImpl.this.setLock;
                        synchronized (object2) {
                            currentProjects = new HashSet(MavenFileOwnerQueryImpl.this.set);
                            iterating = new ArrayList(MavenFileOwnerQueryImpl.this.set);
                        }
                        for (index = 0; index < iterating.size(); ++index) {
                            prj = (NbMavenProjectImpl)iterating.get(index);
                            MavenFileOwnerQueryImpl.this.addSubProjects(currentProjects, iterating, prj);
                        }
                        MavenFileOwnerQueryImpl.this.cachedProjects = currentProjects;
                        MavenFileOwnerQueryImpl.this.projectsToAddToCache = null;
                    }
                    if (null != MavenFileOwnerQueryImpl.this.projectsToAddToCache) {
                        currentProjects = new HashSet(MavenFileOwnerQueryImpl.this.cachedProjects);
                        currentProjects.addAll(MavenFileOwnerQueryImpl.this.projectsToAddToCache);
                        iterating = new ArrayList(MavenFileOwnerQueryImpl.this.projectsToAddToCache);
                        for (index = 0; index < iterating.size(); ++index) {
                            prj = (NbMavenProjectImpl)iterating.get(index);
                            MavenFileOwnerQueryImpl.this.addSubProjects(currentProjects, iterating, prj);
                        }
                        MavenFileOwnerQueryImpl.this.cachedProjects = currentProjects;
                        MavenFileOwnerQueryImpl.this.projectsToAddToCache = null;
                    }
                    return new HashSet<NbMavenProjectImpl>(MavenFileOwnerQueryImpl.this.cachedProjects);
                }
            }
        });
    }

    private void addSubProjects(Set<NbMavenProjectImpl> finalset, List<NbMavenProjectImpl> iteratinglist, NbMavenProjectImpl prj) {
        SubprojectProvider sub = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
        if (sub != null) {
            Set subs = sub.getSubprojects();
            for (Project p : subs) {
                if (!(p instanceof NbMavenProjectImpl)) continue;
                finalset.add((NbMavenProjectImpl)p);
                if (iteratinglist.contains((NbMavenProjectImpl)p)) continue;
                iteratinglist.add((NbMavenProjectImpl)p);
            }
        }
    }
}

