/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.apache.tools.ant.module.api.support.AntScriptUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.java.project.runner.JavaRunnerImplementation;
import org.openide.execution.ExecutionEngine;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;
import org.openide.windows.InputOutput;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class ProjectRunnerImpl
implements JavaRunnerImplementation {
    private static final Logger LOG = Logger.getLogger(ProjectRunnerImpl.class.getName());
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String SNIPPETS_CACHE_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "executor-snippets";
    private static File cacheFolder;

    public boolean isSupported(String string, Map<String, ?> map) {
        return ProjectRunnerImpl.locateScript(string) != null;
    }

    public ExecutorTask execute(String string, Map<String, ?> map) throws IOException {
        if ("clean".equals(string)) {
            return ProjectRunnerImpl.clean(map);
        }
        String[] stringArray = new String[1];
        Properties properties = ProjectRunnerImpl.computeProperties(string, map, stringArray);
        FileObject fileObject = ProjectRunnerImpl.buildScript(string);
        FakeAntProjectCookie fakeAntProjectCookie = new FakeAntProjectCookie(AntScriptUtils.antProjectCookieFor((FileObject)fileObject), stringArray[0]);
        AntTargetExecutor.Env env = new AntTargetExecutor.Env();
        Properties properties2 = env.getProperties();
        properties2.putAll((Map<?, ?>)properties);
        env.setProperties(properties2);
        return AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env).execute((AntProjectCookie)fakeAntProjectCookie, null);
    }

    static Properties computeProperties(String string, Map<String, ?> map, String[] stringArray) {
        String string2;
        Serializable serializable;
        Object object;
        Project project;
        map = new HashMap(map);
        FileObject fileObject = ProjectRunnerImpl.getValue(map, "execute.file", FileObject.class);
        String string3 = ProjectRunnerImpl.getValue(map, "work.dir", String.class);
        String string4 = ProjectRunnerImpl.getValue(map, "classname", String.class);
        ClassPath classPath = ProjectRunnerImpl.getValue(map, "boot.classpath", ClassPath.class);
        ClassPath classPath2 = ProjectRunnerImpl.getValue(map, "execute.classpath", ClassPath.class);
        String string5 = ProjectRunnerImpl.getValue(map, "platform.java", String.class);
        String string6 = ProjectRunnerImpl.getValue(map, "project.name", String.class);
        Iterable<String> iterable = ProjectRunnerImpl.getMultiValue(map, "run.jvmargs", String.class);
        Iterable<String> iterable2 = ProjectRunnerImpl.getMultiValue(map, "application.args", String.class);
        String string7 = ProjectRunnerImpl.getValue(map, "tmp.dir", String.class);
        if (string3 == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
            project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project != null) {
                object = project.getProjectDirectory();
                assert (object != null);
                serializable = FileUtil.toFile((FileObject)object);
                if (serializable != null) {
                    string3 = ((File)serializable).getAbsolutePath();
                }
            }
        }
        if (string4 == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
            project = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (project == null) {
                throw new IllegalArgumentException("The source classpath for specified toRun parameter has is null. Report against caller module. [toRun = " + fileObject + "]");
            }
            string4 = project.getResourceName(fileObject, '.', false);
        }
        if (classPath2 == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
            classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        }
        if ((project = ProjectRunnerImpl.getValue(map, "platform", JavaPlatform.class)) == null) {
            project = JavaPlatform.getDefault();
        }
        if (string5 == null) {
            object = project.findTool("java");
            if (object == null) {
                serializable = new IllegalArgumentException("Cannot find java");
                Exceptions.attachLocalizedMessage((Throwable)serializable, (String)NbBundle.getMessage(ProjectRunnerImpl.class, (String)"ERR_CannotFindJava"));
                throw serializable;
            }
            string5 = FileUtil.toFile((FileObject)object).getAbsolutePath();
        }
        if (classPath == null) {
            classPath = project.getBootstrapLibraries();
        }
        if (string6 == null) {
            object = ProjectRunnerImpl.getValue(map, "project", Project.class);
            if (object != null) {
                string6 = ProjectUtils.getInformation((Project)object).getDisplayName();
            }
            if (string6 == null && fileObject != null && (object = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
                string6 = ProjectUtils.getInformation((Project)object).getDisplayName();
            }
            if (string6 == null) {
                string6 = "";
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", classPath2);
        object = classPath2.toString(ClassPath.PathConversionMode.FAIL);
        serializable = new Properties();
        ProjectRunnerImpl.setProperty((Properties)serializable, "platform.bootcp", classPath.toString(ClassPath.PathConversionMode.FAIL));
        ProjectRunnerImpl.setProperty((Properties)serializable, "classpath", (String)object);
        ProjectRunnerImpl.setProperty((Properties)serializable, "classname", string4);
        ProjectRunnerImpl.setProperty((Properties)serializable, "platform.java", string5);
        ProjectRunnerImpl.setProperty((Properties)serializable, "work.dir", string3);
        ProjectRunnerImpl.setProperty((Properties)serializable, "run.jvmargs", ProjectRunnerImpl.toOneLine(iterable));
        if (string7 != null) {
            ProjectRunnerImpl.setProperty((Properties)serializable, "tmp.dir", string7);
        }
        if (fileObject == null) {
            ProjectRunnerImpl.setProperty((Properties)serializable, "application.args", ProjectRunnerImpl.toOneLine(iterable2));
        }
        Object object2 = fileObject;
        Charset object32 = ProjectRunnerImpl.getValue(map, "runtime.encoding", Charset.class);
        String string8 = string2 = object32 != null && Charset.isSupported(object32.name()) ? object32.name() : null;
        if (string2 == null) {
            Object object3;
            if (object2 == null) {
                object3 = string4.replace('.', '/') + ".class";
                block2: for (FileObject fileObject2 : classPath2.getRoots()) {
                    if (fileObject2.getFileObject((String)object3) == null) continue;
                    try {
                        String string9 = string4.replace('.', '/') + ".java";
                        for (FileObject fileObject3 : SourceForBinaryQuery.findSourceRoots((URL)fileObject2.getURL()).getRoots()) {
                            FileObject fileObject4 = fileObject3.getFileObject(string9);
                            if (fileObject4 == null) continue;
                            object2 = fileObject4;
                            break block2;
                        }
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                    }
                }
            }
            if (object2 != null && Charset.isSupported(((Charset)(object3 = FileEncodingQuery.getEncoding((FileObject)object2))).name())) {
                string2 = ((Charset)object3).name();
            }
        }
        if (string2 == null) {
            string2 = "UTF-8";
        }
        ProjectRunnerImpl.setProperty((Properties)serializable, "encoding", string2);
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof String)) continue;
            ((Properties)serializable).setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        stringArray[0] = string6;
        return serializable;
    }

    private static ExecutorTask clean(Map<String, ?> map) {
        Project project;
        map = new HashMap(map);
        String string = ProjectRunnerImpl.getValue(map, "project.name", String.class);
        FileObject fileObject = ProjectRunnerImpl.getValue(map, "execute.file", FileObject.class);
        ClassPath classPath = ProjectRunnerImpl.getValue(map, "execute.classpath", ClassPath.class);
        if (classPath == null) {
            Parameters.notNull((CharSequence)"toRun", (Object)fileObject);
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        }
        if (string == null) {
            project = ProjectRunnerImpl.getValue(map, "project", Project.class);
            if (project != null) {
                string = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (string == null && fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null) {
                string = ProjectUtils.getInformation((Project)project).getDisplayName();
            }
            if (string == null) {
                string = "";
            }
        }
        LOG.log(Level.FINE, "execute classpath={0}", classPath);
        project = classPath;
        return ExecutionEngine.getDefault().execute(string, new Runnable((ClassPath)project){
            final /* synthetic */ ClassPath val$execFin;
            {
                this.val$execFin = classPath;
            }

            @Override
            public void run() {
                try {
                    ProjectRunnerImpl.doClean(this.val$execFin);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }, InputOutput.NULL);
    }

    private static void setProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private static <T> T getValue(Map<String, ?> map, String string, Class<T> clazz) {
        Object object = map.remove(string);
        if (object instanceof FileObject && clazz == String.class) {
            FileObject fileObject = (FileObject)object;
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return null;
            }
            object = file.getAbsolutePath();
        }
        if (object instanceof File && clazz == String.class) {
            object = ((File)object).getAbsolutePath();
        }
        return clazz.cast(object);
    }

    private static <T> Iterable<T> getMultiValue(Map<String, ?> map, String string, Class<T> clazz) {
        Iterable iterable = (Iterable)map.remove(string);
        LinkedList<T> linkedList = new LinkedList<T>();
        if (iterable == null) {
            return Collections.emptyList();
        }
        for (Object t : iterable) {
            linkedList.add(clazz.cast(t));
        }
        return linkedList;
    }

    private static String toOneLine(Iterable<String> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (String string : iterable) {
            if (!bl) {
                stringBuilder.append(' ');
            }
            bl = false;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static URL locateScript(String string) {
        return ProjectRunnerImpl.class.getResource("/org/netbeans/modules/java/source/ant/resources/" + string + "-snippet.xml");
    }

    private static FileObject buildScript(String string) throws IOException {
        URL uRL = ProjectRunnerImpl.locateScript(string);
        if (uRL == null) {
            return null;
        }
        URL uRL2 = ProjectRunnerImpl.class.getProtectionDomain().getCodeSource().getLocation();
        File file = FileUtil.archiveOrDirForURL((URL)uRL2);
        File file2 = new File(ProjectRunnerImpl.getCacheFolder(), string + ".xml");
        if (!file2.canRead() || file != null && file.lastModified() > file2.lastModified()) {
            try {
                file2.delete();
                URLConnection uRLConnection = uRL.openConnection();
                FileObject fileObject = FileUtil.createData((File)file2);
                ProjectRunnerImpl.copyFile(uRLConnection, fileObject);
                return fileObject;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                return null;
            }
        }
        return FileUtil.toFileObject((File)file2);
    }

    private static String getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        return string;
    }

    private static synchronized File getCacheFolder() {
        if (cacheFolder == null) {
            String string = ProjectRunnerImpl.getNbUserDir();
            assert (string != null);
            File file = new File(string);
            cacheFolder = FileUtil.normalizeFile((File)new File(file, SNIPPETS_CACHE_DIR));
            if (!cacheFolder.exists()) {
                boolean bl = cacheFolder.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (cacheFolder.isDirectory() && cacheFolder.canRead() && cacheFolder.canWrite());
        }
        return cacheFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(URLConnection uRLConnection, FileObject fileObject) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = uRLConnection.getInputStream();
            outputStream = fileObject.getOutputStream();
            FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    private static void doClean(ClassPath classPath) throws IOException {
        for (ClassPath.Entry entry : classPath.entries()) {
            SourceForBinaryQuery.Result2 result2 = SourceForBinaryQuery.findSourceRoots2((URL)entry.getURL());
            if (!result2.preferSources() || result2.getRoots().length <= 0) continue;
            for (FileObject fileObject : result2.getRoots()) {
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null) {
                    LOG.log(Level.WARNING, "Source URL: {0} cannot be translated to file, skipped", fileObject.getURL().toExternalForm());
                    continue;
                }
                BuildArtifactMapperImpl.clean((URL)file.toURI().toURL());
            }
        }
    }

    private static final class FakeElement
    implements Element {
        private final Element delegate;
        private final String projectName;

        public FakeElement(Element element, String string) {
            this.delegate = element;
            this.projectName = string;
        }

        @Override
        public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
            return this.delegate.setUserData(string, object, userDataHandler);
        }

        @Override
        public void setTextContent(String string) throws DOMException {
            this.delegate.setTextContent(string);
        }

        @Override
        public void setPrefix(String string) throws DOMException {
            this.delegate.setPrefix(string);
        }

        @Override
        public void setNodeValue(String string) throws DOMException {
            this.delegate.setNodeValue(string);
        }

        @Override
        public Node replaceChild(Node node, Node node2) throws DOMException {
            return this.delegate.replaceChild(node, node2);
        }

        @Override
        public Node removeChild(Node node) throws DOMException {
            return this.delegate.removeChild(node);
        }

        @Override
        public void normalize() {
            this.delegate.normalize();
        }

        @Override
        public String lookupPrefix(String string) {
            return this.delegate.lookupPrefix(string);
        }

        @Override
        public String lookupNamespaceURI(String string) {
            return this.delegate.lookupNamespaceURI(string);
        }

        @Override
        public boolean isSupported(String string, String string2) {
            return this.delegate.isSupported(string, string2);
        }

        @Override
        public boolean isSameNode(Node node) {
            return this.delegate.isSameNode(node);
        }

        @Override
        public boolean isEqualNode(Node node) {
            return this.delegate.isEqualNode(node);
        }

        @Override
        public boolean isDefaultNamespace(String string) {
            return this.delegate.isDefaultNamespace(string);
        }

        @Override
        public Node insertBefore(Node node, Node node2) throws DOMException {
            return this.delegate.insertBefore(node, node2);
        }

        @Override
        public boolean hasChildNodes() {
            return this.delegate.hasChildNodes();
        }

        @Override
        public boolean hasAttributes() {
            return this.delegate.hasAttributes();
        }

        @Override
        public Object getUserData(String string) {
            return this.delegate.getUserData(string);
        }

        @Override
        public String getTextContent() throws DOMException {
            return this.delegate.getTextContent();
        }

        @Override
        public Node getPreviousSibling() {
            return this.delegate.getPreviousSibling();
        }

        @Override
        public String getPrefix() {
            return this.delegate.getPrefix();
        }

        @Override
        public Node getParentNode() {
            return this.delegate.getParentNode();
        }

        @Override
        public Document getOwnerDocument() {
            return this.delegate.getOwnerDocument();
        }

        @Override
        public String getNodeValue() throws DOMException {
            return this.delegate.getNodeValue();
        }

        @Override
        public short getNodeType() {
            return this.delegate.getNodeType();
        }

        @Override
        public String getNodeName() {
            return this.delegate.getNodeName();
        }

        @Override
        public Node getNextSibling() {
            return this.delegate.getNextSibling();
        }

        @Override
        public String getNamespaceURI() {
            return this.delegate.getNamespaceURI();
        }

        @Override
        public String getLocalName() {
            return this.delegate.getLocalName();
        }

        @Override
        public Node getLastChild() {
            return this.delegate.getLastChild();
        }

        @Override
        public Node getFirstChild() {
            return this.delegate.getFirstChild();
        }

        @Override
        public Object getFeature(String string, String string2) {
            return this.delegate.getFeature(string, string2);
        }

        @Override
        public NodeList getChildNodes() {
            return this.delegate.getChildNodes();
        }

        @Override
        public String getBaseURI() {
            return this.delegate.getBaseURI();
        }

        @Override
        public NamedNodeMap getAttributes() {
            return this.delegate.getAttributes();
        }

        @Override
        public short compareDocumentPosition(Node node) throws DOMException {
            return this.delegate.compareDocumentPosition(node);
        }

        @Override
        public Node cloneNode(boolean bl) {
            return this.delegate.cloneNode(bl);
        }

        @Override
        public Node appendChild(Node node) throws DOMException {
            return this.delegate.appendChild(node);
        }

        @Override
        public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
            this.delegate.setIdAttributeNode(attr, bl);
        }

        @Override
        public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
            this.delegate.setIdAttributeNS(string, string2, bl);
        }

        @Override
        public void setIdAttribute(String string, boolean bl) throws DOMException {
            this.delegate.setIdAttribute(string, bl);
        }

        @Override
        public Attr setAttributeNodeNS(Attr attr) throws DOMException {
            return this.delegate.setAttributeNodeNS(attr);
        }

        @Override
        public Attr setAttributeNode(Attr attr) throws DOMException {
            return this.delegate.setAttributeNode(attr);
        }

        @Override
        public void setAttributeNS(String string, String string2, String string3) throws DOMException {
            this.delegate.setAttributeNS(string, string2, string3);
        }

        @Override
        public void setAttribute(String string, String string2) throws DOMException {
            this.delegate.setAttribute(string, string2);
        }

        @Override
        public Attr removeAttributeNode(Attr attr) throws DOMException {
            return this.delegate.removeAttributeNode(attr);
        }

        @Override
        public void removeAttributeNS(String string, String string2) throws DOMException {
            this.delegate.removeAttributeNS(string, string2);
        }

        @Override
        public void removeAttribute(String string) throws DOMException {
            this.delegate.removeAttribute(string);
        }

        @Override
        public boolean hasAttributeNS(String string, String string2) throws DOMException {
            return this.delegate.hasAttributeNS(string, string2);
        }

        @Override
        public boolean hasAttribute(String string) {
            return this.delegate.hasAttribute(string);
        }

        @Override
        public String getTagName() {
            return this.delegate.getTagName();
        }

        @Override
        public TypeInfo getSchemaTypeInfo() {
            return this.delegate.getSchemaTypeInfo();
        }

        @Override
        public NodeList getElementsByTagNameNS(String string, String string2) throws DOMException {
            return this.delegate.getElementsByTagNameNS(string, string2);
        }

        @Override
        public NodeList getElementsByTagName(String string) {
            return this.delegate.getElementsByTagName(string);
        }

        @Override
        public Attr getAttributeNodeNS(String string, String string2) throws DOMException {
            return this.delegate.getAttributeNodeNS(string, string2);
        }

        @Override
        public Attr getAttributeNode(String string) {
            return this.delegate.getAttributeNode(string);
        }

        @Override
        public String getAttributeNS(String string, String string2) throws DOMException {
            return this.delegate.getAttributeNS(string, string2);
        }

        @Override
        public String getAttribute(String string) {
            if ("name".equals(string)) {
                String string2 = this.delegate.getAttribute(string);
                return MessageFormat.format(string2, this.projectName);
            }
            return this.delegate.getAttribute(string);
        }
    }

    private static final class FakeAntProjectCookie
    implements AntProjectCookie,
    ChangeListener {
        private final AntProjectCookie apc;
        private final String projectName;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        public FakeAntProjectCookie(AntProjectCookie antProjectCookie, String string) {
            this.apc = antProjectCookie;
            this.apc.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)this.apc));
            this.projectName = string;
        }

        public File getFile() {
            return this.apc.getFile();
        }

        public FileObject getFileObject() {
            return this.apc.getFileObject();
        }

        public Document getDocument() {
            return this.apc.getDocument();
        }

        public Element getProjectElement() {
            return new FakeElement(this.apc.getProjectElement(), this.projectName);
        }

        public Throwable getParseException() {
            return this.apc.getParseException();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.cs.fireChange();
        }
    }
}

