/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders.multiview.common;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.PortComponentRef;
import org.netbeans.modules.j2ee.dd.api.common.ServiceRef;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.sun.ddloaders.Utils;
import org.netbeans.modules.j2ee.sun.ddloaders.multiview.common.CommonBeanReader;
import org.openide.ErrorManager;

public class PortComponentRefMetadataReader
extends CommonBeanReader {
    private String serviceRefName;
    private String ejbName;

    public PortComponentRefMetadataReader(String string, String string2) {
        super("PortComponentRef");
        this.serviceRefName = string;
        this.ejbName = string2;
    }

    @Override
    protected CommonDDBean normalizeParent(CommonDDBean commonDDBean) {
        if (this.ejbName != null && commonDDBean instanceof EjbJar) {
            commonDDBean = this.findEjbByName((EjbJar)commonDDBean, this.ejbName);
        }
        if (this.serviceRefName != null && commonDDBean != null) {
            commonDDBean = this.findServiceRefByName(commonDDBean, this.serviceRefName);
        }
        return commonDDBean;
    }

    protected CommonDDBean findServiceRefByName(CommonDDBean commonDDBean, String string) {
        CommonDDBean commonDDBean2 = null;
        try {
            ServiceRef[] serviceRefArray = null;
            if (commonDDBean instanceof WebApp) {
                serviceRefArray = ((WebApp)commonDDBean).getServiceRef();
            } else if (commonDDBean instanceof Ejb) {
                serviceRefArray = ((Ejb)commonDDBean).getServiceRef();
            } else if (commonDDBean instanceof AppClient) {
                serviceRefArray = ((AppClient)commonDDBean).getServiceRef();
            } else {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unsupported parent for service-ref field in standard descriptor: " + commonDDBean));
            }
            commonDDBean2 = this.findServiceRefByName(serviceRefArray, string);
        }
        catch (VersionNotSupportedException versionNotSupportedException) {
            ErrorManager.getDefault().notify(1, (Throwable)versionNotSupportedException);
        }
        return commonDDBean2;
    }

    protected CommonDDBean findServiceRefByName(ServiceRef[] serviceRefArray, String string) {
        ServiceRef serviceRef = null;
        if (serviceRefArray != null) {
            for (ServiceRef serviceRef2 : serviceRefArray) {
                if (!string.equals(serviceRef2.getServiceRefName())) continue;
                serviceRef = serviceRef2;
                break;
            }
        }
        return serviceRef;
    }

    @Override
    public Map<String, Object> genProperties(CommonDDBean[] commonDDBeanArray) {
        HashMap<String, HashMap<String, Object>> hashMap = null;
        if (commonDDBeanArray instanceof PortComponentRef[]) {
            PortComponentRef[] portComponentRefArray;
            for (PortComponentRef portComponentRef : portComponentRefArray = (PortComponentRef[])commonDDBeanArray) {
                String string = portComponentRef.getServiceEndpointInterface();
                if (!Utils.notEmpty(string)) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<String, HashMap<String, Object>>();
                }
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                hashMap.put(string, hashMap2);
                hashMap2.put("EndpointInterface", string);
                hashMap2.put("Name", string);
                this.addMapString(hashMap2, "PortComponentLink", portComponentRef.getPortComponentLink());
            }
        }
        return hashMap;
    }
}

