/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session;

import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.AddActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.DeleteEJBDialog;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.action.GoToSourceActionGroup;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.session.SessionChildren;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbTransferable;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.ejb.shared.EjbViewController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public final class SessionNode
extends AbstractNode
implements OpenCookie,
PropertyChangeListener {
    private final EjbViewController ejbViewController;

    public static SessionNode create(final String string, final EjbJar ejbJar, Project project) {
        SessionNode sessionNode = null;
        try {
            sessionNode = (SessionNode)ejbJar.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, SessionNode>(){

                public SessionNode run(EjbJarMetadata ejbJarMetadata) throws Exception {
                    Ejb ejb = ejbJarMetadata.findByEjbClass(string);
                    if (ejb != null && ejb.getEjbName() != null) {
                        SessionNode sessionNode = new SessionNode(new InstanceContent(), new EjbViewController(string, ejbJar), ejb.getEjbName());
                        ejb.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)sessionNode, (Object)ejb));
                        return sessionNode;
                    }
                    return null;
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return sessionNode;
    }

    private SessionNode(InstanceContent instanceContent, EjbViewController ejbViewController, String string) {
        super((Children)new SessionChildren(ejbViewController), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.ejbViewController = ejbViewController;
        this.setIconBaseWithExtension("org/netbeans/modules/j2ee/ejbcore/ui/logicalview/ejb/session/SessionNodeIcon.gif");
        this.setName(string + "");
        this.setDisplayName();
        instanceContent.add((Object)this);
        ElementHandle<TypeElement> elementHandle = this.ejbViewController.getBeanClass();
        if (elementHandle != null) {
            instanceContent.add(elementHandle);
        }
        if (this.ejbViewController.getBeanDo() != null) {
            instanceContent.add((Object)this.ejbViewController.getBeanDo().getPrimaryFile());
        }
        try {
            instanceContent.add((Object)this.ejbViewController.createEjbReference());
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void setDisplayName() {
        this.setDisplayName(this.ejbViewController.getDisplayName());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("EjbName".equals(propertyChangeEvent.getPropertyName())) {
            this.setDisplayName();
        }
    }

    public Action[] getActions(boolean bl) {
        int n = Utilities.actionsGlobalContext().lookup(new Lookup.Template(Node.class)).allInstances().size();
        ArrayList<SystemAction> arrayList = new ArrayList<SystemAction>();
        arrayList.add(SystemAction.get(OpenAction.class));
        if (n == 1) {
            arrayList.add(null);
            arrayList.add(SystemAction.get(AddActionGroup.class));
            arrayList.add(null);
            arrayList.add(SystemAction.get(GoToSourceActionGroup.class));
        }
        return (Action[])arrayList.toArray(new SystemAction[arrayList.size()]);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return false;
    }

    public void destroy() throws IOException {
        super.destroy();
        String string = DeleteEJBDialog.open(this.ejbViewController.getDisplayName());
        if (!string.equals("deleteNothing")) {
            if (string.equals("deleteOnlyDD")) {
                this.ejbViewController.delete(false);
            } else {
                this.ejbViewController.delete(true);
            }
        }
    }

    public boolean canCopy() {
        return true;
    }

    public boolean canCut() {
        return true;
    }

    public Transferable clipboardCopy() throws IOException {
        EjbReference ejbReference = this.ejbViewController.createEjbReference();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.ejbViewController.getLocalStringRepresentation("Session"));
        return new EjbTransferable(stringBuffer.toString(), ejbReference);
    }

    public Transferable clipboardCut() throws IOException {
        return this.clipboardCopy();
    }

    public void open() {
        FileObject fileObject = this.ejbViewController.getBeanFo();
        ElementHandle<TypeElement> elementHandle = this.ejbViewController.getBeanClass();
        ElementOpen.open((FileObject)fileObject, elementHandle);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Object getValue(String string) {
        Object object = "customDelete".equals(string) ? Boolean.TRUE : super.getValue(string);
        return object;
    }
}

