/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.SQLException;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;

public class ScrollableCursor
extends Cursor
implements ListIterator {
    protected transient Object nextObject;
    protected transient Object previousObject;

    public ScrollableCursor() {
    }

    public ScrollableCursor(DatabaseCall call, ScrollableCursorPolicy policy) {
        super(call, policy);
        this.setPosition(-1);
    }

    public boolean absolute(int rows) throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean suceeded = false;
            int initiallyConforming = this.getObjectCollection().size();
            if (rows >= 0 && rows <= initiallyConforming) {
                this.getResultSet().beforeFirst();
                this.setPosition(rows);
                return true;
            }
            if (rows > initiallyConforming) {
                suceeded = this.getResultSet().absolute(rows - initiallyConforming);
                if (suceeded) {
                    this.setPosition(initiallyConforming + rows);
                } else {
                    this.setPosition(this.size() + 1);
                }
                return suceeded;
            }
            return this.absolute(this.size() + rows);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public void add(Object object) throws QueryException {
        QueryException.invalidOperation("add");
    }

    public void afterLast() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.getResultSet().afterLast();
            this.setPosition(this.size() + 1);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public void beforeFirst() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            this.getResultSet().beforeFirst();
            this.setPosition(0);
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    protected void clearNextAndPrevious() {
        this.setNextObject(null);
        this.setPreviousObject(null);
    }

    public int currentIndex() throws DatabaseException {
        return this.getPosition();
    }

    public boolean first() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            if (this.getObjectCollection().size() > 0) {
                this.setPosition(1);
                this.getResultSet().beforeFirst();
                return true;
            }
            return this.getResultSet().first();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    protected int getCursorSize() throws DatabaseException {
        if (this.getKnownCursorSize() != -1) {
            return this.getKnownCursorSize();
        }
        int currentPos = 0;
        boolean wasAfterLast = false;
        try {
            wasAfterLast = this.getResultSet().isAfterLast();
            currentPos = this.getResultSet().getRow();
            this.getResultSet().last();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
        int size = 0;
        try {
            size = this.getResultSet().getRow();
            if (wasAfterLast) {
                this.getResultSet().afterLast();
            } else if (currentPos == 0) {
                this.getResultSet().beforeFirst();
            } else {
                this.getResultSet().absolute(currentPos);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
        return size;
    }

    protected int getKnownCursorSize() {
        if (this.size == -1) {
            return this.size;
        }
        return this.size - this.getObjectCollection().size();
    }

    protected Object getNextObject() {
        return this.nextObject;
    }

    public int getPosition() throws DatabaseException {
        try {
            if (this.position == -1) {
                this.position = this.getResultSet().getRow();
                if (this.position == 0) {
                    if (this.isAfterLast()) {
                        this.position = this.size() + 1;
                    }
                } else {
                    this.position += this.getObjectCollection().size();
                }
            }
            return this.position;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    protected Object getPreviousObject() {
        return this.previousObject;
    }

    public boolean hasMoreElements() throws DatabaseException {
        return this.hasNext();
    }

    public boolean hasNext() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadNext();
        return this.getNextObject() != null;
    }

    public boolean hasNextElement() throws DatabaseException {
        return this.hasNext();
    }

    public boolean hasPrevious() throws DatabaseException {
        if (this.isClosed()) {
            return false;
        }
        this.loadPrevious();
        return this.getPreviousObject() != null;
    }

    public boolean isAfterLast() throws DatabaseException {
        try {
            if (this.getNextObject() != null) {
                return false;
            }
            if (this.getObjectCollection().size() > 0 && this.getPosition() <= this.getObjectCollection().size()) {
                return false;
            }
            return this.getResultSet().isAfterLast();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public boolean isBeforeFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        return this.getPosition() == 0;
    }

    public boolean isFirst() throws DatabaseException {
        if (this.getPreviousObject() != null) {
            return false;
        }
        try {
            if (this.getObjectCollection().size() > 0) {
                return this.getPosition() == 1;
            }
            return this.getResultSet().isFirst();
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public boolean isLast() throws DatabaseException {
        if (this.getNextObject() != null) {
            return false;
        }
        try {
            return this.getResultSet().isLast();
        }
        catch (UnsupportedOperationException ex) {
            try {
                return this.getResultSet().getRow() == this.getCursorSize();
            }
            catch (SQLException ex2) {
                DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), ex2, null);
                if (commException != null) {
                    throw commException;
                }
                throw DatabaseException.sqlException(ex2, this.getAccessor(), this.getSession(), false);
            }
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public boolean last() throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean isLast = this.getResultSet().last();
            if (!isLast) {
                if (this.getObjectCollection().size() > 0) {
                    this.setPosition(this.getObjectCollection().size());
                    isLast = true;
                }
            } else {
                this.setSize(this.getObjectCollection().size() + this.getResultSet().getRow());
                this.setPosition(this.size);
            }
            return isLast;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    protected void loadNext() {
        if (this.getNextObject() == null) {
            Object next = this.retrieveNextObject();
            this.setNextObject(next);
        }
    }

    protected void loadPrevious() {
        if (this.getPreviousObject() == null) {
            this.setPreviousObject(this.retrievePreviousObject());
        }
    }

    public Object next() throws DatabaseException, QueryException {
        this.loadNext();
        if (this.getNextObject() == null) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object next = this.getNextObject();
        this.clearNextAndPrevious();
        return next;
    }

    public Vector next(int number) throws DatabaseException {
        Vector<Object> result = new Vector<Object>(number);
        for (int index = 0; index < number; ++index) {
            result.addElement(this.next());
        }
        return result;
    }

    public Object nextElement() throws DatabaseException, QueryException {
        return this.next();
    }

    public int nextIndex() throws DatabaseException {
        return this.currentIndex() + 1;
    }

    public Object previous() throws DatabaseException, QueryException {
        this.loadPrevious();
        if (this.getPreviousObject() == null) {
            throw QueryException.readBeyondStream(this.getQuery());
        }
        Object previous = this.getPreviousObject();
        this.clearNextAndPrevious();
        return previous;
    }

    public int previousIndex() throws DatabaseException {
        return this.currentIndex() - 1;
    }

    public boolean relative(int rows) throws DatabaseException {
        this.clearNextAndPrevious();
        try {
            boolean suceeded = false;
            int oldPosition = this.getPosition();
            int newPosition = this.getPosition() + rows;
            int initiallyConforming = this.getObjectCollection().size();
            if (newPosition <= initiallyConforming) {
                this.setPosition(newPosition);
                if (oldPosition > initiallyConforming) {
                    this.getResultSet().beforeFirst();
                }
                if (newPosition < 0) {
                    this.setPosition(0);
                }
                suceeded = newPosition > 0;
            } else {
                suceeded = this.getResultSet().relative(rows);
                if (!suceeded) {
                    this.setPosition(this.size() + 1);
                } else {
                    this.setPosition(newPosition);
                }
            }
            return suceeded;
        }
        catch (SQLException exception) {
            DatabaseException commException = this.getAccessor().processExceptionForCommError(this.getSession(), exception, null);
            if (commException != null) {
                throw commException;
            }
            throw DatabaseException.sqlException(exception, this.getAccessor(), this.getSession(), false);
        }
    }

    public void remove() throws QueryException {
        QueryException.invalidOperation("remove");
    }

    protected Object retrieveNextObject() throws DatabaseException {
        Object object;
        do {
            if (this.getPosition() < this.getObjectCollection().size()) {
                this.setPosition(this.getPosition() + 1);
                return this.getObjectCollection().elementAt(this.getPosition() - 1);
            }
            if (this.isClosed()) {
                return null;
            }
            AbstractRecord row = this.getAccessor().cursorRetrieveNextRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (row == null) {
                this.setPosition(this.size() + 1);
                return null;
            }
            this.setPosition(this.getPosition() + 1);
            object = this.buildAndRegisterObject(row);
        } while (object == InvalidObject.instance);
        return object;
    }

    protected Object retrievePreviousObject() throws DatabaseException {
        Object object;
        do {
            if (this.getPosition() <= this.getObjectCollection().size() + 1) {
                if (this.getPosition() == this.getObjectCollection().size() + 1 && !this.isClosed()) {
                    this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
                }
                if (this.getPosition() <= 1) {
                    this.setPosition(0);
                    return null;
                }
                this.setPosition(this.getPosition() - 1);
                return this.getObjectCollection().elementAt(this.getPosition() - 1);
            }
            if (this.isClosed()) {
                return null;
            }
            AbstractRecord row = this.getAccessor().cursorRetrievePreviousRow(this.getFields(), this.getResultSet(), this.getExecutionSession());
            if (row == null) {
                return null;
            }
            this.setPosition(this.getPosition() - 1);
            object = this.buildAndRegisterObject(row);
        } while (object == InvalidObject.instance);
        return object;
    }

    public void set(Object object) throws QueryException {
        QueryException.invalidOperation("set");
    }

    protected void setNextObject(Object nextObject) {
        this.nextObject = nextObject;
    }

    protected void setPreviousObject(Object previousObject) {
        this.previousObject = previousObject;
    }
}

