/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.copypolicy;

import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;

public class CloneCopyPolicyMetadata
extends CopyPolicyMetadata {
    private String methodName;
    private String workingCopyMethodName;

    public CloneCopyPolicyMetadata() {
        super("<clone-copy-policy>");
    }

    public CloneCopyPolicyMetadata(MetadataAnnotation copyPolicy, MetadataAccessibleObject accessibleObject) {
        super(copyPolicy, accessibleObject);
        this.methodName = (String)copyPolicy.getAttribute("method");
        this.workingCopyMethodName = (String)copyPolicy.getAttribute("workingCopyMethod");
    }

    public CopyPolicy getCopyPolicy() {
        if (this.methodName == null && this.workingCopyMethodName == null) {
            throw ValidationException.copyPolicyMustSpecifyEitherMethodOrWorkingCopyMethod(this.getLocation());
        }
        CloneCopyPolicy copyPolicy = new CloneCopyPolicy();
        copyPolicy.setMethodName(this.methodName);
        copyPolicy.setWorkingCopyMethodName(this.workingCopyMethodName);
        return copyPolicy;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getWorkingCopyMethodName() {
        return this.workingCopyMethodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setWorkingCopyMethodName(String workingCopyMethodName) {
        this.workingCopyMethodName = workingCopyMethodName;
    }
}

