/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.Collator;
import java.util.Comparator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.api.ruby.platform.RubyPlatformManager;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.SourceRoots;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.CustomizerSupport;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.MainClassChooser;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CustomizerRun
extends JPanel
implements HelpCtx.Provider {
    private final RubyProject project;
    private final JTextField[] configFields;
    private final String[] configPropsKeys;
    private final Map<String, Map<String, String>> configs;
    private final RubyProjectProperties uiProperties;
    private PlatformComponentFactory.PlatformChangeListener platformListener;
    private JComboBox configCombo;
    private JButton configDel;
    private JLabel configLabel;
    private JButton configNew;
    private JPanel configPanel;
    private JSeparator configSep;
    private JButton jButtonMainClass;
    private JButton jButtonWorkingDirectoryBrowse;
    private JLabel jLabelArgs;
    private JLabel jLabelMainClass;
    private JLabel jLabelVMOptionsExample;
    private JLabel jLabelWorkingDirectory;
    private JTextField jTextFieldArgs;
    private JTextField jTextFieldMainClass;
    private JTextField jTextWorkingDirectory;
    private JLabel jrubyPropsExample;
    private JLabel jrubyPropsLabel;
    private JTextField jrubyPropsText;
    private JPanel mainPanel;
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rakeExampleLabel;
    private JLabel rakeLabel;
    private JTextField rakeTextField;
    private JTextField rubyOptions;
    private JLabel rubyOptionsLabel;
    private JLabel rubyPlatformLabel;

    public CustomizerRun(RubyProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.project = uiProperties.getRubyProject();
        this.configs = uiProperties.getRunConfigs();
        this.configFields = new JTextField[]{this.jTextFieldMainClass, this.jTextFieldArgs, this.rubyOptions, this.jTextWorkingDirectory, this.rakeTextField, this.jrubyPropsText};
        JLabel[] configLabels = new JLabel[]{this.jLabelMainClass, this.jLabelArgs, this.rubyOptionsLabel, this.jLabelWorkingDirectory, this.rakeLabel, this.jrubyPropsLabel};
        this.configPropsKeys = new String[]{"main.file", "application.args", "ruby.options", "work.dir", "rake.args", "jvm.args"};
        assert (this.configFields.length == this.configPropsKeys.length);
        this.configChanged(uiProperties.getActiveConfig());
        this.configCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String label;
                String config = (String)value;
                if (config == null) {
                    label = null;
                } else if (config.length() > 0) {
                    Map m = (Map)CustomizerRun.this.configs.get(config);
                    String string = label = m != null ? (String)m.get("$label") : null;
                    if (label == null) {
                        label = config;
                    }
                } else {
                    label = NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.default");
                }
                return super.getListCellRendererComponent((JList<?>)list, label, index, isSelected, cellHasFocus);
            }
        });
        for (int i = 0; i < this.configFields.length; ++i) {
            this.configFields[i].getDocument().addDocumentListener(new ConfigChangeListener(this.configPropsKeys[i], configLabels[i], this.configFields[i]));
        }
        this.jButtonMainClass.addActionListener(new MainClassListener(this.project.getSourceRoots(), this.jTextFieldMainClass));
        this.platforms.setSelectedItem(uiProperties.getPlatform());
        this.updateEnabled();
    }

    private String getSelectedConfig() {
        String config = (String)this.configCombo.getSelectedItem();
        if (config.length() == 0) {
            config = null;
        }
        return config;
    }

    private void updateEnabled() {
        RubyPlatform platform = (RubyPlatform)this.platforms.getSelectedItem();
        boolean isJRuby = platform != null && platform.isJRuby();
        this.jrubyPropsExample.setEnabled(isJRuby);
        this.jrubyPropsLabel.setEnabled(isJRuby);
        this.jrubyPropsText.setEnabled(isJRuby);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.platformListener = new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                RubyPlatform platform = (RubyPlatform)CustomizerRun.this.platforms.getSelectedItem();
                if (platform != null) {
                    CustomizerRun.this.uiProperties.setPlatform(platform);
                    ((Map)CustomizerRun.this.configs.get(CustomizerRun.this.getSelectedConfig())).put("platform.active", platform.getID());
                    CustomizerRun.this.updateEnabled();
                }
            }
        };
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
    }

    @Override
    public void removeNotify() {
        PlatformComponentFactory.removePlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)this.platformListener);
        super.removeNotify();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerRun.class);
    }

    private void initComponents() {
        this.configSep = new JSeparator();
        this.configPanel = new JPanel();
        this.mainPanel = new JPanel();
        this.jLabelMainClass = new JLabel();
        this.jTextFieldMainClass = new JTextField();
        this.jButtonMainClass = new JButton();
        this.jLabelArgs = new JLabel();
        this.jTextFieldArgs = new JTextField();
        this.jLabelWorkingDirectory = new JLabel();
        this.jTextWorkingDirectory = new JTextField();
        this.jButtonWorkingDirectoryBrowse = new JButton();
        this.rubyOptionsLabel = new JLabel();
        this.rubyOptions = new JTextField();
        this.jLabelVMOptionsExample = new JLabel();
        this.rakeLabel = new JLabel();
        this.rakeTextField = new JTextField();
        this.rakeExampleLabel = new JLabel();
        this.jrubyPropsLabel = new JLabel();
        this.jrubyPropsText = new JTextField();
        this.jrubyPropsExample = new JLabel();
        this.rubyPlatformLabel = new JLabel();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.manageButton = new JButton();
        this.configLabel = new JLabel();
        this.configCombo = new JComboBox();
        this.configDel = new JButton();
        this.configNew = new JButton();
        this.configPanel.setLayout(new GridBagLayout());
        this.jLabelMainClass.setLabelFor(this.jTextFieldMainClass);
        Mnemonics.setLocalizedText((JLabel)this.jLabelMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonMainClass, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_MainClass_JButton"));
        this.jLabelArgs.setLabelFor(this.jTextFieldArgs);
        Mnemonics.setLocalizedText((JLabel)this.jLabelArgs, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Args_JLabel"));
        this.jLabelWorkingDirectory.setLabelFor(this.jTextWorkingDirectory);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWorkingDirectory, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWorkingDirectoryBrowse, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse"));
        this.jButtonWorkingDirectoryBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.jButtonWorkingDirectoryBrowseActionPerformed(evt);
            }
        });
        this.rubyOptionsLabel.setLabelFor(this.rubyOptions);
        Mnemonics.setLocalizedText((JLabel)this.rubyOptionsLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options"));
        Mnemonics.setLocalizedText((JLabel)this.jLabelVMOptionsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_VM_Options_Example"));
        this.rakeLabel.setLabelFor(this.rakeTextField);
        Mnemonics.setLocalizedText((JLabel)this.rakeLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgs"));
        Mnemonics.setLocalizedText((JLabel)this.rakeExampleLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RakeArgsEx"));
        this.jrubyPropsLabel.setLabelFor(this.jrubyPropsText);
        Mnemonics.setLocalizedText((JLabel)this.jrubyPropsLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jrubyPropsLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jrubyPropsExample, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jrubyPropsExample.text"));
        GroupLayout mainPanelLayout = new GroupLayout((Container)this.mainPanel);
        this.mainPanel.setLayout((LayoutManager)mainPanelLayout);
        mainPanelLayout.setHorizontalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1, false).add((Component)this.jrubyPropsLabel, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelWorkingDirectory, -2, 116, Short.MAX_VALUE).add((Component)this.rakeLabel, -2, 116, Short.MAX_VALUE).add((Component)this.rubyOptionsLabel, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelArgs, -1, -1, Short.MAX_VALUE).add((Component)this.jLabelMainClass, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((Component)this.jLabelVMOptionsExample).add((Component)this.rakeExampleLabel).add((Component)this.jrubyPropsExample).add((Component)this.rakeTextField, -1, 493, Short.MAX_VALUE).add((Component)this.jrubyPropsText, -1, 493, Short.MAX_VALUE).add((Component)this.jTextFieldArgs, -1, 493, Short.MAX_VALUE).add((Component)this.rubyOptions, -1, 493, Short.MAX_VALUE).add((Component)this.jTextFieldMainClass, -1, 493, Short.MAX_VALUE).add((Component)this.jTextWorkingDirectory, -1, 493, Short.MAX_VALUE)).add(6, 6, 6).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(2).add((Component)this.jButtonMainClass).add((Component)this.jButtonWorkingDirectoryBrowse))));
        mainPanelLayout.setVerticalGroup((GroupLayout.Group)mainPanelLayout.createParallelGroup(1).add((GroupLayout.Group)mainPanelLayout.createSequentialGroup().add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabelMainClass).add((Component)this.jButtonMainClass).add((Component)this.jTextFieldMainClass, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabelArgs).add((Component)this.jTextFieldArgs, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jLabelWorkingDirectory).add((Component)this.jButtonWorkingDirectoryBrowse).add((Component)this.jTextWorkingDirectory, -2, -1, -2)).add(10, 10, 10).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.rubyOptionsLabel).add((Component)this.rubyOptions, -2, -1, -2)).add(5, 5, 5).add((Component)this.jLabelVMOptionsExample).add(9, 9, 9).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.rakeLabel).add((Component)this.rakeTextField, -2, -1, -2)).addPreferredGap(0).add((Component)this.rakeExampleLabel).addPreferredGap(0).add((GroupLayout.Group)mainPanelLayout.createParallelGroup(3).add((Component)this.jrubyPropsLabel).add((Component)this.jrubyPropsText, -2, -1, -2)).addPreferredGap(0).add((Component)this.jrubyPropsExample)));
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextFieldMainClass.AccessibleContext.accessibleName"));
        this.jTextFieldMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldMainClass"));
        this.jButtonMainClass.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jButtonMainClass"));
        this.jTextFieldArgs.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextFieldArgs.AccessibleContext.accessibleName"));
        this.jTextFieldArgs.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(CustomizerRun.class).getString("AD_jTextFieldArgs"));
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextWorkingDirectory.AccessibleContext.accessibleName"));
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/ui/customizer/Bundle");
        this.jTextWorkingDirectory.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory"));
        this.jButtonWorkingDirectoryBrowse.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_Working_Directory_Browse"));
        this.rubyOptions.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jTextVMOptions.AccessibleContext.accessibleName"));
        this.rubyOptions.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_CustomizeRun_Run_VM_Options"));
        this.jLabelVMOptionsExample.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_CustomizeRun_Run_VM_Options_Example"));
        this.rakeLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rakeLabel.AccessibleContext.accessibleDescription"));
        this.rakeTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rakeTextField.AccessibleContext.accessibleName"));
        this.rakeTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rakeTextField.AccessibleContext.accessibleDescription"));
        this.jrubyPropsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jrubyPropsLabel.AccessibleContext.accessibleDescription"));
        this.jrubyPropsText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jrubyPropsText.AccessibleContext.accessibleName"));
        this.jrubyPropsText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.jrubyPropsText.AccessibleContext.accessibleDescription"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(CustomizerRun.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.manageButtonActionPerformed(evt);
            }
        });
        this.configLabel.setLabelFor(this.configCombo);
        Mnemonics.setLocalizedText((JLabel)this.configLabel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel"));
        this.configCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"<default>"}));
        this.configCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configDel, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configDelete"));
        this.configDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configDelActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.configNew, (String)NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew"));
        this.configNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomizerRun.this.configNewActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.mainPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.configPanel, -2, 410, -2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.rubyPlatformLabel).add((Component)this.configLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.platforms, 0, 440, Short.MAX_VALUE).add(2, (Component)this.configCombo, 0, 440, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.configNew).addPreferredGap(0).add((Component)this.configDel)).add((Component)this.manageButton))).add((Component)this.configSep, -1, 729, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.platforms, -2, -1, -2).add((Component)this.manageButton)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.configLabel).add((Component)this.configCombo, -2, -1, -2)).addPreferredGap(0).add((Component)this.configPanel, -2, -1, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.configDel).add((Component)this.configNew)))).addPreferredGap(0).add((Component)this.configSep, -2, 2, -2).addPreferredGap(0).add((Component)this.mainPanel, -1, -1, Short.MAX_VALUE)));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.rubyPlatformLabel.AccessibleContext.accessibleDescription"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.manageButton.AccessibleContext.accessibleDescription"));
        this.configLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configLabel.AccessibleContext.accessibleDescription"));
        this.configNew.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"CustomizerRun.configNew.AccessibleContext.accessibleDescription"));
    }

    private void configDelActionPerformed(ActionEvent evt) {
        String config = this.getSelectedConfig();
        assert (config != null);
        this.configs.put(config, null);
        this.configChanged(null);
        this.uiProperties.setActiveConfig(null);
    }

    private void configNewActionPerformed(ActionEvent evt) {
        String config = CustomizerSupport.askForNewConfiguration(this.configs);
        this.configChanged(config);
        this.uiProperties.setActiveConfig(config);
    }

    private void configComboActionPerformed(ActionEvent evt) {
        String config = this.getSelectedConfig();
        this.configChanged(config);
        this.uiProperties.setActiveConfig(config);
    }

    private void jButtonWorkingDirectoryBrowseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        String workDir = this.jTextWorkingDirectory.getText();
        if (workDir.equals("")) {
            workDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory()).getAbsolutePath();
        }
        chooser.setSelectedFile(new File(workDir));
        chooser.setDialogTitle(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_CustomizeRun_Run_Working_Directory_Browse_Title"));
        if (0 == chooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)chooser.getSelectedFile());
            this.jTextWorkingDirectory.setText(file.getAbsolutePath());
        }
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void configChanged(String activeConfig) {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement("");
        TreeSet<String> alphaConfigs = new TreeSet<String>(new Comparator<String>(){
            Collator coll = Collator.getInstance();

            @Override
            public int compare(String s1, String s2) {
                return this.coll.compare(this.label(s1), this.label(s2));
            }

            private String label(String c) {
                Map m = (Map)CustomizerRun.this.configs.get(c);
                String label = (String)m.get("$label");
                return label != null ? label : c;
            }
        });
        for (Map.Entry<String, Map<String, String>> entry : this.configs.entrySet()) {
            String config = entry.getKey();
            if (config == null || entry.getValue() == null) continue;
            alphaConfigs.add(config);
        }
        for (String c : alphaConfigs) {
            model.addElement(c);
        }
        this.configCombo.setModel(model);
        this.configCombo.setSelectedItem(activeConfig != null ? activeConfig : "");
        Map<String, String> active = this.configs.get(activeConfig);
        Map<String, String> def = this.configs.get(null);
        if (active != null) {
            for (int i = 0; i < this.configFields.length; ++i) {
                String v = active.get(this.configPropsKeys[i]);
                if (v == null) {
                    v = def.get(this.configPropsKeys[i]);
                }
                this.configFields[i].setText(v);
            }
            String activePlatformID = active.get("platform.active");
            if (activePlatformID == null) {
                activePlatformID = def.get("platform.active");
            }
            this.platforms.setSelectedItem(RubyPlatformManager.getPlatformByID((String)activePlatformID));
        }
        this.configDel.setEnabled(activeConfig != null);
    }

    private class ConfigChangeListener
    implements DocumentListener {
        private final JTextField field;
        private final JLabel label;
        private final String prop;

        ConfigChangeListener(String prop, JLabel label, JTextField field) {
            this.field = field;
            this.label = label;
            this.prop = prop;
            this.updateFont();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        void changed() {
            String config = CustomizerRun.this.getSelectedConfig();
            String v = this.field.getText();
            if (v != null && config != null && v.equals(((Map)CustomizerRun.this.configs.get(null)).get(this.prop))) {
                v = null;
            }
            ((Map)CustomizerRun.this.configs.get(config)).put(this.prop, v);
            this.updateFont();
        }

        void updateFont() {
            Font basefont = this.label.getFont();
            Font boldfont = basefont.deriveFont(1);
            String v = this.field.getText();
            String def = (String)((Map)CustomizerRun.this.configs.get(null)).get(this.prop);
            this.label.setFont(CustomizerRun.this.getSelectedConfig() != null && !Utilities.compareObjects((Object)(v != null ? v : ""), (Object)(def != null ? def : "")) ? boldfont : basefont);
        }
    }

    private class MainClassListener
    implements ActionListener {
        private final JButton okButton;
        private final SourceRoots sourceRoots;
        private final JTextField mainClassTextField;

        MainClassListener(SourceRoots sourceRoots, JTextField mainClassTextField) {
            this.sourceRoots = sourceRoots;
            this.mainClassTextField = mainClassTextField;
            this.okButton = new JButton(NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_OK"));
            this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerRun.class, (String)"AD_ChooseMainClass_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final MainClassChooser panel = new MainClassChooser(this.sourceRoots.getRoots());
            Object[] options = new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION};
            panel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        MainClassListener.this.okButton.doClick();
                    } else {
                        MainClassListener.this.okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                }
            });
            this.okButton.setEnabled(false);
            DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(CustomizerRun.class, (String)"LBL_ChooseMainClass_Title"), true, options, options[0], 0, null, null);
            Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
            dlg.setVisible(true);
            if (desc.getValue() == options[0]) {
                this.mainClassTextField.setText(panel.getSelectedMainClass());
            }
            dlg.dispose();
        }
    }
}

