/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.api;

import java.awt.Color;
import java.util.ResourceBundle;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.openide.util.NbBundle;

public enum ThreadStateResources {
    THREAD_RUNNING(new Color(178, 188, 0), ThreadState.MSAState.Running),
    THREAD_RUNNING_USER(new Color(178, 188, 0), ThreadState.MSAState.RunningUser),
    THREAD_RUNNING_SYSTEM(new Color(0, 166, 80), ThreadState.MSAState.RunningSystemCall),
    THREAD_RUNNING_OTHER(new Color(0, 169, 157), ThreadState.MSAState.RunningOther),
    THREAD_BLOCKED(new Color(231, 111, 0), ThreadState.MSAState.Blocked),
    THREAD_SLEEP_USE_LOCK(new Color(231, 111, 0), ThreadState.MSAState.SleepingUserLock),
    THREAD_WAITING(new Color(255, 199, 38), ThreadState.MSAState.Waiting),
    THREAD_WAITING_CPU(new Color(255, 199, 38), ThreadState.MSAState.WaitingCPU),
    THREAD_SLEEPING(new Color(83, 130, 161), ThreadState.MSAState.Sleeping),
    THREAD_SLEEPING_OTHER(new Color(83, 130, 161), ThreadState.MSAState.SleepingOther),
    THREAD_SLEEPING_USER_DATA_PAGE_FAULT(new Color(247, 149, 29), ThreadState.MSAState.SleepingUserDataPageFault),
    THREAD_SLEEPING_USER_TEXT_PAGE_FAULT(new Color(231, 111, 0), ThreadState.MSAState.SleepingUserTextPageFault),
    THREAD_SLEEPING_KERNEL_PAGE_FAULT(new Color(114, 138, 132), ThreadState.MSAState.SleepingKernelPageFault),
    THREAD_THREAD_STOPPED(new Color(255, 242, 0), ThreadState.MSAState.ThreadStopped);

    public final Color color;
    public final String name;
    public final String tooltip;

    private ThreadStateResources(Color color, ThreadState.MSAState state) {
        this.color = color;
        ResourceBundle bundle = NbBundle.getBundle(((Object)((Object)this)).getClass());
        this.name = bundle.getString("ThreadState" + state.name() + "Name");
        this.tooltip = bundle.getString("ThreadState" + state.name() + "Tooltip");
    }

    public static ThreadStateResources forState(ThreadState.MSAState threadState) {
        if (threadState == null) {
            return THREAD_THREAD_STOPPED;
        }
        switch (threadState) {
            case Running: {
                return THREAD_RUNNING;
            }
            case RunningUser: {
                return THREAD_RUNNING_USER;
            }
            case RunningSystemCall: {
                return THREAD_RUNNING_SYSTEM;
            }
            case RunningOther: {
                return THREAD_RUNNING_OTHER;
            }
            case Blocked: {
                return THREAD_BLOCKED;
            }
            case SleepingUserLock: {
                return THREAD_SLEEP_USE_LOCK;
            }
            case Waiting: {
                return THREAD_WAITING;
            }
            case WaitingCPU: {
                return THREAD_WAITING_CPU;
            }
            case Sleeping: {
                return THREAD_SLEEPING;
            }
            case SleepingOther: {
                return THREAD_SLEEPING_OTHER;
            }
            case SleepingUserDataPageFault: {
                return THREAD_SLEEPING_USER_DATA_PAGE_FAULT;
            }
            case SleepingUserTextPageFault: {
                return THREAD_SLEEPING_USER_TEXT_PAGE_FAULT;
            }
            case SleepingKernelPageFault: {
                return THREAD_SLEEPING_KERNEL_PAGE_FAULT;
            }
            case Stopped: {
                return THREAD_SLEEPING;
            }
            case ThreadStopped: {
                return THREAD_THREAD_STOPPED;
            }
        }
        return null;
    }
}

