/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.dlight.api.impl.TreeTableNode;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.TreeTableDataProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.AdvancedTableViewVisualizer;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerRefreshVisualizerHandler;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.TreeTableVisualizerColumnModel;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.TreeTableVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.TreeTableVisualizerConfigurationAccessor;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

class TreeTableVisualizer<T extends TreeTableNode>
extends JPanel
implements Visualizer<TreeTableVisualizerConfiguration>,
OnTimerTask,
ComponentListener {
    private final Object queryLock = TreeTableVisualizer.class.getName() + "Lock";
    private boolean isShown = true;
    private JToolBar buttonsToolbar;
    private JButton refresh;
    private final TreeTableVisualizerConfiguration configuration;
    private final DefaultTreeModel treeModel;
    protected final DefaultMutableTreeNode TREE_ROOT = new DefaultMutableTreeNode("ROOT");
    private JPanel mainPanel = null;
    private TreeModelImpl treeModelImpl;
    private TableModelImpl tableModelImpl;
    private Models.CompoundModel compoundModel;
    protected JComponent treeTableView;
    private final TreeTableDataProvider<T> dataProvider;
    private OnTimerRefreshVisualizerHandler timerHandler;
    protected boolean isEmptyContent;
    protected boolean isLoadingContent;
    private Future<Boolean> task;
    private Future<List<T>> syncFillDataTask;
    private final Object syncFillInLock = new Object();
    private final ColumnsUIMapping columnsUIMapping;

    TreeTableVisualizer(TreeTableVisualizerConfiguration configuration, TreeTableDataProvider<T> dataProvider) {
        this.configuration = configuration;
        this.dataProvider = dataProvider;
        this.columnsUIMapping = TreeTableVisualizerConfigurationAccessor.getDefault().getColumnsUIMapping(configuration);
        this.treeModel = new DefaultTreeModel(this.TREE_ROOT);
        this.setLoadingContent();
    }

    protected void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel label = new JLabel(NbBundle.getMessage(AdvancedTableViewVisualizer.class, (String)"Loading"));
        label.setAlignmentX(0.5f);
        this.add(label);
        this.repaint();
        this.revalidate();
    }

    protected void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
        } else {
            this.mainPanel.removeAll();
        }
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        JLabel label = new JLabel(NbBundle.getMessage(TreeTableVisualizer.class, (String)"NoDataAvailableYet"));
        label.setAlignmentX(0.5f);
        this.mainPanel.add(label);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.repaint();
        this.revalidate();
    }

    protected void setContent(final boolean isEmpty) {
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                if (TreeTableVisualizer.this.isLoadingContent && isEmpty) {
                    TreeTableVisualizer.this.isLoadingContent = false;
                    TreeTableVisualizer.this.setEmptyContent();
                    return;
                }
                if (TreeTableVisualizer.this.isLoadingContent && !isEmpty) {
                    TreeTableVisualizer.this.isLoadingContent = false;
                    TreeTableVisualizer.this.setNonEmptyContent();
                    return;
                }
                if (TreeTableVisualizer.this.isEmptyContent && isEmpty) {
                    return;
                }
                if (TreeTableVisualizer.this.isEmptyContent && !isEmpty) {
                    TreeTableVisualizer.this.setNonEmptyContent();
                    return;
                }
                if (!TreeTableVisualizer.this.isEmptyContent && isEmpty) {
                    TreeTableVisualizer.this.setEmptyContent();
                    return;
                }
            }
        });
    }

    protected void setNonEmptyContent() {
        this.initComponents();
        this.updateButtons();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        if (this.timerHandler != null && this.timerHandler.isSessionRunning()) {
            this.timerHandler.startTimer();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
        object = this.syncFillInLock;
        synchronized (object) {
            if (this.syncFillDataTask != null) {
                this.syncFillDataTask.cancel(true);
                this.syncFillDataTask = null;
            }
        }
        if (this.timerHandler != null) {
            this.timerHandler.stopTimer();
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setNodes(List<DefaultMutableTreeNode> nodes) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.TREE_ROOT;
        synchronized (defaultMutableTreeNode) {
            this.TREE_ROOT.removeAllChildren();
            this.fireTreeModelChanged();
            if (nodes != null) {
                for (DefaultMutableTreeNode node : nodes) {
                    this.TREE_ROOT.add(node);
                }
                this.fireTreeModelChanged();
            }
        }
    }

    protected void fireTreeModelChanged() {
        this.fireTreeModelChanged(null);
    }

    protected void fireTreeModelChanged(final DefaultMutableTreeNode node) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (node == null) {
                    TreeTableVisualizer.this.treeModelImpl.fireTreeModelChanged();
                } else {
                    TreeTableVisualizer.this.treeModelImpl.fireTreeModelChanged(node);
                }
            }
        });
    }

    protected void updateButtons() {
    }

    protected JToolBar getButtonsTolbar() {
        return this.buttonsToolbar;
    }

    protected void initComponents() {
        DataTableMetadata.Column[] tableColumns;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.buttonsToolbar = new JToolBar();
        this.refresh = new JButton();
        this.buttonsToolbar.setFloatable(false);
        this.buttonsToolbar.setOrientation(1);
        this.buttonsToolbar.setRollover(true);
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setFocusable(false);
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeTableVisualizer.this.asyncFillModel(TreeTableVisualizer.this.configuration.getMetadata().getColumns(), false);
            }
        });
        this.buttonsToolbar.add(this.refresh);
        this.add((Component)this.buttonsToolbar, "Before");
        this.mainPanel = new JPanel();
        this.mainPanel.removeAll();
        this.add((Component)this.mainPanel, "Center");
        TreeTableVisualizerConfigurationAccessor configInfo = TreeTableVisualizerConfigurationAccessor.getDefault();
        ArrayList<TreeTableVisualizerColumnModel> columns = new ArrayList<TreeTableVisualizerColumnModel>();
        for (DataTableMetadata.Column column : tableColumns = configInfo.getTableColumns(this.configuration)) {
            columns.add(new TreeTableVisualizerColumnModel(column, this.columnsUIMapping));
        }
        DataTableMetadata.Column treeColumn = configInfo.getTreeColumn(this.configuration);
        columns.add(new TreeTableVisualizerColumnModel(treeColumn, this.columnsUIMapping){

            public Class getType() {
                return null;
            }
        });
        this.treeModelImpl = new TreeModelImpl();
        this.tableModelImpl = new TableModelImpl();
        NodeActionsProvider nodesActionProvider = configInfo.getNodesActionProvider(this.configuration);
        ArrayList<Object> models = new ArrayList<Object>();
        models.add(this.treeModelImpl);
        models.add(this.tableModelImpl);
        models.addAll(columns);
        models.add(new NodeModelImpl());
        if (nodesActionProvider != null) {
            models.add(nodesActionProvider);
        }
        this.compoundModel = Models.createCompoundModel(models);
        this.treeTableView = Models.createView((Models.CompoundModel)this.compoundModel);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.treeTableView, "Center");
        this.treeModelImpl.fireTreeModelChanged();
        this.mainPanel.repaint();
        this.repaint();
        this.revalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void asyncFillModel(final List<DataTableMetadata.Column> columns, boolean cancelIfNotDone) {
        Object object = this.queryLock;
        synchronized (object) {
            if (this.task != null && !this.task.isDone()) {
                if (cancelIfNotDone) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    TreeTableVisualizer.this.syncFillModel(columns);
                    return Boolean.TRUE;
                }
            }, (String)("Async TreeTableVisualizer model fill " + this.configuration.getID()));
        }
    }

    protected void syncFillModel(List<DataTableMetadata.Column> columns) {
        List list = this.dataProvider.getTableView(columns, null, Integer.MAX_VALUE);
        this.updateList(list);
    }

    protected void updateList(List<T> list) {
        if (list == null) {
            return;
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(list.size());
        for (TreeTableNode value : list) {
            nodes.add(new DefaultMutableTreeNode(value));
        }
        this.setNodes(nodes);
    }

    protected void loadTree(final DefaultMutableTreeNode rootNode, final List<T> path) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final List result = TreeTableVisualizer.this.dataProvider.getChildren(path, TreeTableVisualizer.this.configuration.getMetadata().getColumns(), null);
                UIThread.invoke((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeTableVisualizer.this.updateTree(rootNode, result);
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            DLightExecutorService.submit((Runnable)r, (String)("Loading data for TreeTableVisualizer " + this.configuration.getID()));
        } else {
            r.run();
        }
    }

    protected void updateTree(DefaultMutableTreeNode rootNode, List<T> result) {
        rootNode.removeAllChildren();
        if (result != null) {
            for (TreeTableNode value : result) {
                rootNode.add(new DefaultMutableTreeNode(value));
            }
        }
        this.fireTreeModelChanged();
    }

    protected boolean isShown() {
        return this.isShown;
    }

    @Override
    public int onTimer() {
        if (!this.isShown() || !this.isShowing()) {
            return 0;
        }
        this.syncFillModel(this.configuration.getMetadata().getColumns());
        return 0;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public TreeTableVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    @Override
    public void timerStopped() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    public void refresh() {
        this.asyncFillModel(this.configuration.getMetadata().getColumns(), false);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.isShown = false;
    }

    public void updateVisualizerConfiguration(TreeTableVisualizerConfiguration configuration) {
    }

    protected String getIcon(T node) {
        return null;
    }

    class NodeModelImpl
    implements ExtendedNodeModel {
        private final Object nodesMapLock = new Object();
        private final Object listenersLock = new Object();
        private Vector<ModelListener> listeners = new Vector();
        private Map<String, String> nodes = new HashMap<String, String>();

        NodeModelImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getDisplayName(Object node) {
            if (node == "Root") {
                String treeColumnDisplayedName = TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnUName();
                return treeColumnDisplayedName;
            }
            final Object finalNodeObject = node;
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                Object nodeObject = treeNode.getUserObject();
                String result = "";
                if (nodeObject instanceof TreeTableNode) {
                    final Object value = ((TreeTableNode)nodeObject).getValue();
                    Object object = this.nodesMapLock;
                    synchronized (object) {
                        if (this.nodes.containsKey(value + "")) {
                            return this.nodes.get(value + "");
                        }
                    }
                    if (TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnClass() == String.class) {
                        return value + "";
                    }
                    DLightExecutorService.submit((Runnable)new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            PropertyEditor editor = PropertyEditorManager.findEditor(TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnClass());
                            if (editor != null) {
                                editor.setValue(value);
                                Object object = NodeModelImpl.this.nodesMapLock;
                                synchronized (object) {
                                    NodeModelImpl.this.nodes.put(value + "", editor.getAsText());
                                }
                                NodeModelImpl.this.fireNodeModelChanged(finalNodeObject);
                            }
                        }
                    }, (String)"insight getDisplayName.. ");
                    return "...";
                }
                result = nodeObject.toString();
                return result;
            }
            return "Unknown";
        }

        public String getIconBase(Object node) {
            DefaultMutableTreeNode treeNode;
            Object nodeObject;
            if (node == "Root") {
                return null;
            }
            if (node instanceof DefaultMutableTreeNode && (nodeObject = (treeNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof TreeTableNode) {
                return TreeTableVisualizer.this.getIcon((TreeTableNode)nodeObject);
            }
            return null;
        }

        public String getShortDescription(Object node) {
            if (node == "Root") {
                return TreeTableVisualizerConfigurationAccessor.getDefault().getTreeColumn(TreeTableVisualizer.this.configuration).getColumnUName();
            }
            if (node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                return ((TreeTableNode)treeNode.getUserObject()).getValue() + "";
            }
            return "Unknown";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireNodeModelChanged(final Object node) {
            if (EventQueue.isDispatchThread()) {
                Object object = this.listenersLock;
                synchronized (object) {
                    for (ModelListener l : this.listeners) {
                        l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, node));
                    }
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = NodeModelImpl.this.listenersLock;
                        synchronized (object) {
                            for (ModelListener l : NodeModelImpl.this.listeners) {
                                l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)NodeModelImpl.this, node));
                            }
                        }
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener l) {
            Object object = this.listenersLock;
            synchronized (object) {
                if (this.listeners.contains(l)) {
                    return;
                }
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener l) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(l);
            }
        }

        public boolean canRename(Object arg0) throws UnknownTypeException {
            return false;
        }

        public boolean canCopy(Object arg0) throws UnknownTypeException {
            return false;
        }

        public boolean canCut(Object arg0) throws UnknownTypeException {
            return false;
        }

        public Transferable clipboardCopy(Object arg0) throws IOException, UnknownTypeException {
            return null;
        }

        public Transferable clipboardCut(Object arg0) throws IOException, UnknownTypeException {
            return null;
        }

        public PasteType[] getPasteTypes(Object arg0, Transferable arg1) throws UnknownTypeException {
            return null;
        }

        public void setName(Object node, String name) throws UnknownTypeException {
        }

        public String getIconBaseWithExtension(Object arg0) throws UnknownTypeException {
            return null;
        }
    }

    class TableModelImpl
    implements TableModel {
        private Vector<ModelListener> listeners = new Vector();

        TableModelImpl() {
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            if (!(node instanceof DefaultMutableTreeNode)) {
                throw new UnknownTypeException(node);
            }
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)node;
            Object nodeObject = theNode.getUserObject();
            if (nodeObject instanceof TreeTableNode) {
                return ((TreeTableNode)nodeObject).getValue(columnID);
            }
            return "";
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            return true;
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        }

        public void addModelListener(ModelListener l) {
            this.listeners.add(l);
        }

        void fireTableValueChanged() {
        }

        public void removeModelListener(ModelListener l) {
            this.listeners.remove(l);
        }
    }

    protected class TreeModelImpl
    implements TreeModel,
    TreeExpansionModel {
        private final Object listenersLock = new Object();
        private Vector<ModelListener> listeners = new Vector();

        protected TreeModelImpl() {
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            Object real_parent = parent;
            if (parent == "Root") {
                real_parent = TreeTableVisualizer.this.TREE_ROOT;
            }
            if (real_parent instanceof DefaultMutableTreeNode) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (int i = from; i <= to; ++i) {
                    if (i < 0 || i >= TreeTableVisualizer.this.treeModel.getChildCount(real_parent)) continue;
                    result.add(TreeTableVisualizer.this.treeModel.getChild(real_parent, i));
                }
                return result.toArray();
            }
            throw new UnknownTypeException(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireTreeModelChanged(DefaultMutableTreeNode node) {
            Object object = this.listenersLock;
            synchronized (object) {
                for (ModelListener l : this.listeners) {
                    l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)TreeTableVisualizer.this, (Object)node));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void fireTreeModelChanged() {
            Object object = this.listenersLock;
            synchronized (object) {
                for (ModelListener l : this.listeners) {
                    l.modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)TreeTableVisualizer.this));
                    l.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)TreeTableVisualizer.this, (Object)"Root"));
                }
            }
        }

        public boolean isLeaf(Object node) {
            if (node == "Root") {
                return false;
            }
            if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(TreeTableVisualizer.this.configuration)) {
                return true;
            }
            return TreeTableVisualizer.this.timerHandler != null && TreeTableVisualizer.this.timerHandler.isSessionRunning();
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            Object real_node = node;
            if (node == "Root") {
                real_node = TreeTableVisualizer.this.TREE_ROOT;
                return TreeTableVisualizer.this.treeModel.getChildCount(real_node);
            }
            if (real_node instanceof DefaultMutableTreeNode) {
                if (TreeTableVisualizerConfigurationAccessor.getDefault().isTableView(TreeTableVisualizer.this.configuration)) {
                    return 0;
                }
                return 1;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener l) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener l) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(l);
            }
        }

        public boolean isExpanded(Object node) throws UnknownTypeException {
            return false;
        }

        public void nodeExpanded(Object node) {
            if (node == "Root") {
                return;
            }
            if (!(node instanceof DefaultMutableTreeNode)) {
                return;
            }
            DefaultMutableTreeNode tNode = (DefaultMutableTreeNode)node;
            List<TreeTableNode> result = Arrays.asList((TreeTableNode)tNode.getUserObject());
            TreeTableVisualizer.this.loadTree(tNode, result);
        }

        public void nodeCollapsed(Object node) {
        }
    }
}

