/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionsListDataProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.spi.AnnotatedSourceSupport;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.SourceSupportProvider;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.visualizers.FunctionsListSheetCell;
import org.netbeans.modules.dlight.visualizers.ImageLoader;
import org.netbeans.modules.dlight.visualizers.OnTimerTask;
import org.netbeans.modules.dlight.visualizers.VisualizerTopComponentTopComponent;
import org.netbeans.modules.dlight.visualizers.VisualizersSupport;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.impl.FunctionsListViewVisualizerConfigurationAccessor;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.ETableColumn;
import org.netbeans.swing.etable.ETableColumnModel;
import org.netbeans.swing.outline.Outline;
import org.openide.awt.HtmlRenderer;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FunctionsListViewVisualizer
extends JPanel
implements Visualizer<FunctionsListViewVisualizerConfiguration>,
OnTimerTask,
ComponentListener,
ExplorerManager.Provider {
    private static final long MIN_REFRESH_MILLIS = 500L;
    private static final Logger log = DLightLogger.getLogger(FunctionsListViewVisualizer.class);
    private Future<Boolean> task;
    private final QueryLock queryLock = new QueryLock();
    private final SourcePrefetchExecutorLock sourcePrefetchExecutorLock = new SourcePrefetchExecutorLock();
    private final UILock uiLock = new UILock();
    private JButton refresh;
    private boolean isEmptyContent;
    private boolean isLoadingContent;
    private boolean isShown = true;
    private final OutlineView outlineView;
    private final ExplorerManager explorerManager;
    private final FunctionDatatableDescription functionDatatableDescription;
    private final FunctionsListDataProvider dataProvider;
    private final DataTableMetadata metadata;
    private final ColumnsUIMapping columnsUIMapping;
    private final List<DataTableMetadata.Column> metrics;
    private final FunctionsListViewVisualizerConfiguration configuration;
    private final VisualizersSupport visSupport;
    private FunctionCallChildren currentChildren;
    private ExecutorService sourcePrefetchExecutor;
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final boolean useHtmlFormat;
    private static final Color htmlEnabledForeground;
    private static final Color htmlDisabledForeground;
    private static final Color tooltipBG;
    private Map<Integer, Boolean> ascColumnValues = new HashMap<Integer, Boolean>();
    private final SourceSupportProvider sourceSupportProvider = (SourceSupportProvider)Lookup.getDefault().lookup(SourceSupportProvider.class);

    private static Color getColor(String propName, Color defaultColor) {
        Color result = UIManager.getDefaults().getColor(propName);
        return result == null ? defaultColor : result;
    }

    public FunctionsListViewVisualizer(FunctionsListDataProvider dataProvider, FunctionsListViewVisualizerConfiguration configuration) {
        super(new BorderLayout());
        this.visSupport = new VisualizersSupport(new VisualizerImplSessionStateListener());
        this.explorerManager = new ExplorerManager();
        this.configuration = configuration;
        this.functionDatatableDescription = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getFunctionDatatableDescription(configuration);
        this.metrics = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getMetricsList(configuration);
        this.columnsUIMapping = FunctionsListViewVisualizerConfigurationAccessor.getDefault().getColumnsUIMapping(configuration);
        this.dataProvider = dataProvider;
        this.metadata = configuration.getMetadata();
        this.addComponentListener(this);
        String nodeLabel = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn()) == null ? this.metadata.getColumnByName(this.functionDatatableDescription.getNameColumn()).getColumnUName() : this.columnsUIMapping.getDisplayedName(this.functionDatatableDescription.getNameColumn());
        this.outlineView = new OutlineView(nodeLabel);
        this.outlineView.setDragSource(false);
        this.outlineView.setDropTarget(false);
        this.outlineView.setAllowedDragActions(0);
        this.outlineView.setAllowedDropActions(0);
        final Outline outline = this.outlineView.getOutline();
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setRootVisible(false);
        outline.putClientProperty((Object)"ComputingTooltip", (Object)Boolean.TRUE);
        outline.setDefaultRenderer(Object.class, (TableCellRenderer)new ExtendedTableCellRendererForNode(this.explorerManager));
        outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)new FunctionsListSheetCell.OutlineSheetCell(this.outlineView.getOutline(), this.metrics));
        outline.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FunctionCallNode node;
                GoToSourceAction a;
                Node[] nodes;
                if (SwingUtilities.isLeftMouseButton(e) && MouseUtils.isDoubleClick((MouseEvent)e) && (nodes = FunctionsListViewVisualizer.this.explorerManager.getSelectedNodes()) != null && nodes.length > 0 && nodes[0] instanceof FunctionCallNode && (a = (node = (FunctionCallNode)nodes[0]).getGoToSourceAction()) != null) {
                    if (a.isEnabled()) {
                        a.actionPerformed(new ActionEvent((Object)node, 1001, ""));
                    } else {
                        Logger.getLogger(OutlineView.class.getName()).info("Action " + a + " on node " + (Object)((Object)node) + " is disabled");
                    }
                    e.consume();
                    return;
                }
                super.mouseClicked(e);
            }
        });
        for (DataTableMetadata.Column c : this.metrics) {
            String displayedName = this.columnsUIMapping == null || this.columnsUIMapping.getDisplayedName(c.getColumnName()) == null ? c.getColumnUName() : this.columnsUIMapping.getDisplayedName(c.getColumnName());
            String displayedTooltip = this.columnsUIMapping == null || this.columnsUIMapping.getTooltip(c.getColumnName()) == null ? c.getColumnLongUName() : this.columnsUIMapping.getTooltip(c.getColumnName());
            this.outlineView.addPropertyColumn(c.getColumnName(), displayedName, displayedTooltip);
        }
        int columnCount = this.metrics.size() + 1;
        int firstKey = 49;
        for (int i = 1; i <= columnCount; ++i) {
            final int columnNumber = i - 1;
            KeyStroke columnKey = KeyStroke.getKeyStroke(firstKey++, 8, true);
            this.outlineView.getInputMap(1).put(columnKey, "ascSortFor" + i);
            this.outlineView.getActionMap().put("ascSortFor" + i, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int column = columnNumber;
                    ETableColumnModel columnModel = null;
                    if (outline.getColumnModel() instanceof ETableColumnModel) {
                        columnModel = (ETableColumnModel)outline.getColumnModel();
                        columnModel.clearSortedColumns();
                    }
                    boolean asc = !FunctionsListViewVisualizer.this.ascColumnValues.containsKey(column) ? true : (Boolean)FunctionsListViewVisualizer.this.ascColumnValues.get(column);
                    outline.setColumnSorted(column, asc, 1);
                    FunctionsListViewVisualizer.this.ascColumnValues.put(column, !asc);
                    outline.getTableHeader().resizeAndRepaint();
                }
            });
        }
        outline.getSelectionModel().setSelectionMode(0);
        VisualizerTopComponentTopComponent.findInstance().addComponentListener(this);
        KeyStroke returnKey = KeyStroke.getKeyStroke(27, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(returnKey, "return");
        this.outlineView.getOutline().getActionMap().put("return", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionsListViewVisualizer.this.refresh.requestFocus(false);
            }
        });
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, true);
        this.outlineView.getOutline().getInputMap(1).put(enterKey, "enter");
        this.outlineView.getOutline().getActionMap().put("enter", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FunctionCallNode callNode;
                GoToSourceAction goToSourceAction;
                Node[] nodes = FunctionsListViewVisualizer.this.explorerManager.getSelectedNodes();
                if (nodes != null && nodes.length > 0 && nodes[0] instanceof FunctionCallNode && (goToSourceAction = (callNode = (FunctionCallNode)nodes[0]).getGoToSourceAction()) != null) {
                    goToSourceAction.actionPerformed(null);
                }
            }
        });
        ETableColumnModel colModel = (ETableColumnModel)outline.getColumnModel();
        TableColumn firstColumn = colModel.getColumn(0);
        ETableColumn col = (ETableColumn)firstColumn;
        col.setNestedComparator((Comparator)new Comparator<FunctionCallNode>(){

            @Override
            public int compare(FunctionCallNode o1, FunctionCallNode o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        if (this.refresh != null) {
            this.refresh.requestFocus();
        }
    }

    public FunctionsListViewVisualizerConfiguration getVisualizerConfiguration() {
        return this.configuration;
    }

    public JComponent getComponent() {
        return this;
    }

    public VisualizerContainer getDefaultContainer() {
        return VisualizerTopComponentTopComponent.findInstance();
    }

    public void refresh() {
        this.asyncFillModel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncFillModel(boolean cancelIfNotDone) {
        QueryLock queryLock = this.queryLock;
        synchronized (queryLock) {
            if (this.task != null && !this.task.isDone()) {
                if (cancelIfNotDone) {
                    this.task.cancel(true);
                } else {
                    return;
                }
            }
            UIThread.invoke((Runnable)new Runnable(){

                @Override
                public void run() {
                    FunctionsListViewVisualizer.this.setLoadingContent();
                }
            });
            this.task = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    FunctionsListViewVisualizer.this.syncFillModel(true);
                    return Boolean.TRUE;
                }
            }, (String)("FunctionsListViewVisualizer Async data load for " + this.configuration.getID() + " from main table " + this.configuration.getMetadata().getName()));
        }
    }

    private void syncFillModel(boolean wait) {
        long startTime = System.currentTimeMillis();
        List callsList = this.dataProvider.getFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        List detailedCallsList = this.dataProvider.getDetailedFunctionsList(this.metadata, this.functionDatatableDescription, this.metrics);
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        try {
            if (wait && duration < 500L) {
                Thread.sleep(500L - duration);
            }
            this.updateList(callsList, detailedCallsList);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void asyncNotifyAnnotedSourceProviders(final List<FunctionCallWithMetric> functionsList, final List<FunctionCallWithMetric> list) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Collection supports = Lookup.getDefault().lookupAll(AnnotatedSourceSupport.class);
        for (final AnnotatedSourceSupport sourceSupport : supports) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    sourceSupport.updateSource((SourceFileInfoDataProvider)FunctionsListViewVisualizer.this.dataProvider, FunctionsListViewVisualizer.this.metrics, list, functionsList);
                }
            }, (String)"Annoted Source from FunctionsListView Visualizer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateList(final List<FunctionCallWithMetric> list, List<FunctionCallWithMetric> detailedList) {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        final boolean isEmptyConent = list == null || list.isEmpty();
        SourcePrefetchExecutorLock sourcePrefetchExecutorLock = this.sourcePrefetchExecutorLock;
        synchronized (sourcePrefetchExecutorLock) {
            if (this.sourcePrefetchExecutor != null) {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return FunctionsListViewVisualizer.this.sourcePrefetchExecutor.shutdownNow();
                    }
                });
                this.sourcePrefetchExecutor = null;
            }
            if (!this.isEmptyContent) {
                this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
            }
        }
        this.asyncNotifyAnnotedSourceProviders(list, detailedList);
        UIThread.invoke((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                UILock uILock = FunctionsListViewVisualizer.this.uiLock;
                synchronized (uILock) {
                    FunctionsListViewVisualizer.this.setContent(isEmptyConent);
                    if (!isEmptyConent) {
                        final FunctionCallChildren children = new FunctionCallChildren(list);
                        FunctionsListViewVisualizer.this.currentChildren = children;
                        if (!Children.MUTEX.isReadAccess()) {
                            Children.MUTEX.writeAccess(new Runnable(){

                                @Override
                                public void run() {
                                    FunctionsListViewVisualizer.this.explorerManager.setRootContext((Node)new AbstractNode((Children)children));
                                    FunctionsListViewVisualizer.this.setNonEmptyContent();
                                }
                            });
                        }
                    }
                }
            }
        });
    }

    private void setEmptyContent() {
        this.isEmptyContent = true;
        this.removeAll();
        JLabel label = new JLabel(this.visSupport != null && this.visSupport.isSessionAnalyzed() ? FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyAnalyzeMessage(this.configuration) : FunctionsListViewVisualizerConfigurationAccessor.getDefault().getEmptyRunningMessage(this.configuration), 0);
        this.add((Component)label, "Center");
        this.add((Component)this.createToolbar(), "West");
        this.repaint();
        this.revalidate();
    }

    private void setLoadingContent() {
        this.isEmptyContent = false;
        this.isLoadingContent = true;
        this.removeAll();
        JLabel label = new JLabel(FunctionsListViewVisualizer.getMessage("Loading"), 0);
        this.add((Component)label, "Center");
        this.repaint();
        this.revalidate();
    }

    private void setContent(boolean isEmpty) {
        if (this.isLoadingContent && isEmpty) {
            this.isLoadingContent = false;
            this.setEmptyContent();
            return;
        }
        if (this.isLoadingContent && !isEmpty) {
            this.isLoadingContent = false;
            this.setNonEmptyContent();
            return;
        }
        if (this.isEmptyContent && !isEmpty) {
            this.setNonEmptyContent();
            return;
        }
        if (isEmpty) {
            this.setEmptyContent();
            return;
        }
    }

    private void setNonEmptyContent() {
        this.isEmptyContent = false;
        this.removeAll();
        JToolBar toolbar = this.createToolbar();
        this.add((Component)toolbar, "West");
        this.add((Component)this.outlineView, "Center");
        this.repaint();
        this.validate();
        this.refresh.requestFocus();
    }

    private JToolBar createToolbar() {
        JToolBar buttonsToolbar = new JToolBar();
        if (isMacLaf) {
            buttonsToolbar.setBackground(macBackground);
        }
        buttonsToolbar.setFloatable(false);
        buttonsToolbar.setOrientation(1);
        buttonsToolbar.setRollover(true);
        this.refresh = new JButton();
        this.refresh.setIcon(ImageLoader.loadIcon("refresh.png"));
        this.refresh.setToolTipText(FunctionsListViewVisualizer.getMessage("Refresh.Tooltip"));
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FunctionsListViewVisualizer.this.asyncFillModel(false);
            }
        });
        buttonsToolbar.add(this.refresh);
        return buttonsToolbar;
    }

    @Override
    public int onTimer() {
        return 0;
    }

    @Override
    public void addNotify() {
        super.addNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        QueryLock queryLock = this.queryLock;
        synchronized (queryLock) {
            if (this.task != null) {
                this.task.cancel(false);
                this.task = null;
            }
        }
        this.removeComponentListener(this);
        VisualizerTopComponentTopComponent.findInstance().removeComponentListener(this);
    }

    @Override
    public void timerStopped() {
        if (this.isEmptyContent) {
            this.setEmptyContent();
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        if (this.isShown) {
            return;
        }
        this.isShown = this.isShowing();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.isShown = false;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void updateVisualizerConfiguration(FunctionsListViewVisualizerConfiguration configuration) {
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(FunctionsListViewVisualizer.class, (String)key);
    }

    static {
        String property = System.getProperty("FunctionsListViewVisualizer.usehtml", "true");
        useHtmlFormat = "true".equalsIgnoreCase(property);
        htmlEnabledForeground = FunctionsListViewVisualizer.getColor("FormattedTextField.foreground", Color.BLACK);
        htmlDisabledForeground = FunctionsListViewVisualizer.getColor("FormattedTextField.inactiveForeground", Color.GRAY);
        tooltipBG = FunctionsListViewVisualizer.getColor("ToolTip.background", Color.YELLOW);
    }

    private static final class UILock {
        private UILock() {
        }
    }

    private static final class SourcePrefetchExecutorLock {
        private SourcePrefetchExecutorLock() {
        }
    }

    private static final class QueryLock {
        private QueryLock() {
        }
    }

    private static class VisualizerImplSessionStateListener
    implements SessionStateListener {
        private VisualizerImplSessionStateListener() {
        }

        public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        }
    }

    private static class ExtendedTableCellRendererForNode
    extends DefaultTableCellRenderer {
        private static final String dots = " ... ";
        private final Graphics2D scratchGraphics = new BufferedImage(1, 1, 1).createGraphics();
        private FunctionCallNode node;
        private int cellwidth;
        private int cellheight;
        private final ExplorerManager manager;

        public ExtendedTableCellRendererForNode(ExplorerManager manager) {
            this.manager = manager;
            this.setVerticalAlignment(1);
        }

        @Override
        public String getToolTipText() {
            return this.ensureVisible(this.node.getHtmlDisplayName(), tooltipBG);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table instanceof ETable) {
                row = ((ETable)table).convertRowIndexToModel(row);
                Node n = this.manager.getRootContext().getChildren().getNodeAt(row);
                if (n instanceof FunctionCallNode) {
                    this.node = (FunctionCallNode)n;
                    this.setText(this.ensureVisible(this.node.getHtmlDisplayName(), this.getBackground()));
                }
            }
            return this;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            int strw = 0;
            if (width > 0 && height > 0) {
                this.cellwidth = width;
                this.cellheight = height;
                strw = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)x, (int)y, (int)width, (int)height, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
            }
            super.setBounds(x, y, Math.max(width, strw) + 10, height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            FontMetrics fm = g.getFontMetrics();
            int strw = (int)HtmlRenderer.renderHTML((String)(this.node.getHtmlDisplayName() + ' '), (Graphics)this.scratchGraphics, (int)0, (int)0, (int)this.cellwidth, (int)0, (Font)this.getFont(), (Color)Color.black, (int)0, (boolean)false);
            if (this.cellwidth < strw) {
                int dotsw = (int)g.getFontMetrics().getStringBounds(dots, g).getMaxX();
                ((Graphics2D)g).setBackground(this.getBackground());
                g.setColor(this.getContrastGrayColor(htmlDisabledForeground, this.getBackground()));
                g.clearRect(this.cellwidth - dotsw, 0, dotsw, this.cellheight);
                g.drawString(dots, this.cellwidth - dotsw, fm.getHeight() + fm.getLeading() - fm.getDescent());
            }
        }

        private Color getContrastGrayColor(Color orig, Color bg) {
            int rgb = orig.getRGB();
            int orig_gray = ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
            int bg_gray = (((rgb = bg.getRGB()) >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
            if (Math.abs(orig_gray - bg_gray) > 100) {
                return new Color(orig_gray, orig_gray, orig_gray);
            }
            int avg = bg_gray > 128 ? bg_gray - 100 : bg_gray + 100;
            return new Color(avg, avg, avg);
        }

        private String ensureVisible(String html, Color bg) {
            Color black = this.getContrastGrayColor(htmlEnabledForeground, bg);
            Color gray = this.getContrastGrayColor(htmlDisabledForeground, bg);
            String sblack = String.format("color='#%02x%02x%02x'", black.getRed(), black.getGreen(), black.getBlue());
            String sgray = String.format("color='#%02x%02x%02x'", gray.getRed(), gray.getGreen(), gray.getBlue());
            html = html.replace("color='#000000'", sblack);
            return html.replace("color='#808080'", sgray);
        }
    }

    private class GoToSourceAction
    extends AbstractAction {
        private final FunctionCallNode functionCallNode;
        private SourceFileInfoProvider.SourceFileInfo sourceInfo;
        private Future<Boolean> goToSourceTask;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoToSourceAction(FunctionCallNode funcCallNode) {
            super(NbBundle.getMessage(FunctionsListViewVisualizer.class, (String)"GoToSourceActionName"));
            this.functionCallNode = funcCallNode;
            SourcePrefetchExecutorLock sourcePrefetchExecutorLock = FunctionsListViewVisualizer.this.sourcePrefetchExecutorLock;
            synchronized (sourcePrefetchExecutorLock) {
                if (FunctionsListViewVisualizer.this.sourcePrefetchExecutor == null) {
                    FunctionsListViewVisualizer.this.sourcePrefetchExecutor = Executors.newFixedThreadPool(2);
                }
            }
            FunctionsListViewVisualizer.this.sourcePrefetchExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    FunctionCallWithMetric functionCall = GoToSourceAction.this.functionCallNode.getFunctionCall();
                    SourceFileInfoProvider.SourceFileInfo result = FunctionsListViewVisualizer.this.dataProvider.getSourceFileInfo((FunctionCall)functionCall);
                    if (result != null && result.isSourceKnown()) {
                        GoToSourceAction.this.setEnabled(true);
                    }
                    GoToSourceAction goToSourceAction = GoToSourceAction.this;
                    synchronized (goToSourceAction) {
                        GoToSourceAction.this.sourceInfo = result;
                    }
                    GoToSourceAction.this.functionCallNode.fire();
                }
            });
            this.setEnabled(false);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            if (this.goToSourceTask != null && !this.goToSourceTask.isDone()) {
                return;
            }
            this.goToSourceTask = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    SourceFileInfoProvider.SourceFileInfo source = GoToSourceAction.this.getSource();
                    if (source == null || !source.isSourceKnown()) {
                        return false;
                    }
                    FunctionsListViewVisualizer.this.sourceSupportProvider.showSource(source);
                    return true;
                }
            }, (String)"GoToSource from Functions List View");
        }

        private synchronized SourceFileInfoProvider.SourceFileInfo getSource() {
            return this.sourceInfo;
        }
    }

    private class FunctionCallNode
    extends AbstractNode {
        private final FunctionCallWithMetric functionCall;
        private Node.PropertySet propertySet;
        private final Action[] actions;
        private final GoToSourceAction goToSourceAction;
        private String plainDisplayName;
        private String htmlDisplayName;
        private String functionName;

        FunctionCallNode(FunctionCallWithMetric row) {
            super(Children.LEAF);
            this.plainDisplayName = null;
            this.htmlDisplayName = null;
            this.functionName = null;
            this.functionCall = row;
            this.goToSourceAction = new GoToSourceAction(this);
            this.actions = new Action[]{this.goToSourceAction};
            this.propertySet = new Node.PropertySet(){

                public Node.Property<?>[] getProperties() {
                    ArrayList<1> result = new ArrayList<1>();
                    for (final DataTableMetadata.Column metric : FunctionsListViewVisualizer.this.metrics) {
                        PropertySupport property = new PropertySupport(metric.getColumnName(), metric.getColumnClass(), metric.getColumnUName(), metric.getColumnLongUName(), true, false){

                            public Object getValue() throws IllegalAccessException, InvocationTargetException {
                                return !FunctionCallNode.this.functionCall.hasMetric(metric.getColumnName()) ? FunctionsListViewVisualizer.getMessage("NotDefined") : FunctionCallNode.this.functionCall.getMetricValue(metric.getColumnName());
                            }

                            public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                            }
                        };
                        result.add(property);
                    }
                    return result.toArray(new Node.Property[0]);
                }
            };
            this.updateNames();
        }

        public synchronized String getName() {
            return this.functionName;
        }

        public FunctionCallWithMetric getFunctionCall() {
            return this.functionCall;
        }

        public Image getIcon(int type) {
            return null;
        }

        public Image getOpenedIcon(int type) {
            return null;
        }

        public Action getPreferredAction() {
            return null;
        }

        GoToSourceAction getGoToSourceAction() {
            return this.goToSourceAction;
        }

        private void fire() {
            this.updateNames();
            this.fireDisplayNameChange(null, this.getDisplayName());
        }

        public Action[] getActions(boolean context) {
            return this.actions;
        }

        public synchronized String getDisplayName() {
            return useHtmlFormat ? this.htmlDisplayName : this.plainDisplayName;
        }

        public synchronized String getHtmlDisplayName() {
            return this.htmlDisplayName;
        }

        private synchronized void updateNames() {
            this.plainDisplayName = this.functionCall.getDisplayedName();
            String name = this.functionCall.getFunction().getName();
            String funcName = this.functionCall.getFunction().getQuilifiedName();
            int idx1 = name.indexOf(funcName);
            int idx2 = funcName.lastIndexOf(58);
            if (idx2 > 0) {
                idx1 += idx2 + 1;
                funcName = funcName.substring(idx2 + 1);
            }
            this.functionName = funcName;
            String prefix = name.substring(0, idx1);
            String suffix = name.substring(idx1 + funcName.length());
            prefix = this.toHtml(prefix);
            funcName = this.toHtml(funcName);
            suffix = this.toHtml(suffix);
            funcName = "<b>" + funcName + "</b>";
            String dispName = prefix + funcName + suffix + "&nbsp;";
            GoToSourceAction action = this.getGoToSourceAction();
            StringBuilder result = new StringBuilder("<html>");
            String infoSuffix = null;
            if (action.isEnabled()) {
                result.append("<font color='#000000'>" + dispName + "</font>");
                SourceFileInfoProvider.SourceFileInfo sourceInfo = action.getSource();
                if (sourceInfo != null && sourceInfo.isSourceKnown()) {
                    String fname = new File(sourceInfo.getFileName()).getName();
                    int line = sourceInfo.getLine();
                    String infoPrefix = line > 0 ? FunctionsListViewVisualizer.getMessage("FunctionCallNode.prefix.withLine") : FunctionsListViewVisualizer.getMessage("FunctionCallNode.prefix.withoutLine");
                    infoSuffix = infoPrefix + "&nbsp;" + fname + (line > 0 ? ":" + line : "");
                    result.append("<font color='#808080'>" + infoSuffix + "</font>");
                }
            } else {
                result.append("<font color='#808080'>" + dispName + "</font>");
            }
            result.append("</html>");
            this.htmlDisplayName = result.toString();
        }

        public Node.PropertySet[] getPropertySets() {
            return new Node.PropertySet[]{this.propertySet};
        }

        private String toHtml(String plain) {
            plain = plain.replace("&", "&amp;");
            plain = plain.replace("<", "&lt;");
            plain = plain.replace(">", "&gt;");
            plain = plain.replace(" ", "&nbsp;");
            return plain;
        }
    }

    public class FunctionCallChildren
    extends Children.Keys<FunctionCallWithMetric> {
        private final List<FunctionCallWithMetric> list;

        public FunctionCallChildren(List<FunctionCallWithMetric> list) {
            this.list = list;
        }

        protected Node[] createNodes(FunctionCallWithMetric key) {
            return new Node[]{new FunctionCallNode(key)};
        }

        protected void addNotify() {
            this.setKeys(this.list);
        }
    }
}

