/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.j2ee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.websvc.api.client.WebServicesClientSupport;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.j2ee.support.J2eeUtil;
import org.netbeans.modules.websvc.saas.codegen.java.SoapClientPojoCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientOperationInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SoapClientSaasBean;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.netbeans.modules.websvc.saas.model.WsdlSaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class SoapClientServletCodeGenerator
extends SoapClientPojoCodeGenerator {
    public SoapClientServletCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.SERVLET);
        this.setPrecedence(1);
    }

    public boolean canAccept(SaasMethod saasMethod, Document document) {
        return SaasBean.canAccept((SaasMethod)saasMethod, WsdlSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && J2eeUtil.isServlet(NbEditorUtilities.getDataObject((Document)document));
    }

    protected void preGenerate() throws IOException {
        super.preGenerate();
        SoapClientOperationInfo[] soapClientOperationInfoArray = this.getBean().getOperationInfos();
        ArrayList<WSService> arrayList = new ArrayList<WSService>();
        for (SoapClientOperationInfo soapClientOperationInfo : soapClientOperationInfoArray) {
            WSService wSService;
            if (!soapClientOperationInfo.isRPCEncoded() || arrayList.contains(wSService = soapClientOperationInfo.getService())) continue;
            arrayList.add(wSService);
            this.preGenerateRpcClient(soapClientOperationInfo, wSService);
        }
    }

    public void init(SaasMethod saasMethod, Document document) throws IOException {
        super.init(saasMethod, document);
        WsdlSaasMethod wsdlSaasMethod = (WsdlSaasMethod)saasMethod;
        Project project = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)document));
        SoapClientSaasBean soapClientSaasBean = new SoapClientSaasBean(wsdlSaasMethod, project, (SoapClientOperationInfo[])J2eeUtil.toJaxwsOperationInfos(wsdlSaasMethod, project));
        this.setBean((SaasBean)soapClientSaasBean);
    }

    private void preGenerateRpcClient(SoapClientOperationInfo soapClientOperationInfo, WSService wSService) throws IOException {
        WebServicesClientSupport webServicesClientSupport = WebServicesClientSupport.getWebServicesClientSupport((FileObject)this.getTargetFile());
        if (webServicesClientSupport != null) {
            Object object;
            FileObject fileObject;
            String string = soapClientOperationInfo.getWsdlLocation();
            File file = new File(string);
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            FileObject fileObject3 = webServicesClientSupport.getWsdlFolder(true);
            if (fileObject3.getFileObject(fileObject2.getName(), fileObject2.getExt()) == null) {
                FileUtil.copyFile((FileObject)fileObject2, (FileObject)fileObject3, (String)fileObject2.getName());
            }
            if ((fileObject = this.getCatalogDir(soapClientOperationInfo)) != null && (object = fileObject.getFileObject("mapping.xml")) != null && fileObject3.getFileObject(object.getName(), object.getExt()) == null) {
                FileUtil.copyFile((FileObject)object, (FileObject)fileObject3, (String)object.getName());
            }
            object = "service/" + wSService.getName();
            String string2 = wSService.getJavaName();
            string = string.substring(string.lastIndexOf(File.separator) + 1);
            string = "WEB-INF/wsdl/" + string;
            String string3 = "WEB-INF/wsdl/mapping.xml";
            List list = wSService.getPorts();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                stringArray[i] = ((WSPort)list.get(i)).getJavaName();
            }
            webServicesClientSupport.addServiceClientReference((String)object, string2, string, string3, stringArray);
        }
    }

    private FileObject findParentDir(FileObject fileObject, String string) {
        if (fileObject == null || fileObject.getName().equals(string)) {
            return fileObject;
        }
        return this.findParentDir(fileObject.getParent(), string);
    }

    private FileObject getCatalogDir(SoapClientOperationInfo soapClientOperationInfo) throws IOException {
        FileObject fileObject = null;
        String string = soapClientOperationInfo.getWsdlLocation();
        File file = new File(string);
        if (file.exists()) {
            FileObject fileObject2 = FileUtil.toFileObject((File)file);
            fileObject = this.findParentDir(fileObject2.getParent(), "catalog");
        }
        return fileObject;
    }
}

