/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.spi.KeymapManager;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.NbBundle;

public class LayersBridge
extends KeymapManager {
    static final String KEYMAPS_FOLDER = "Keymaps";
    private static final String SHORTCUTS_FOLDER = "Shortcuts";
    private static final String LAYERS_BRIDGE = "LayersBridge";
    private Map<GlobalAction, DataObject> actionToDataObject = new HashMap<GlobalAction, DataObject>();
    private Map<String, Set<ShortcutAction>> categoryToActions;
    private Set<GlobalAction> actions = new HashSet<GlobalAction>();
    private List<String> keymapNames;
    private Map<String, String> keymapDisplayNames;
    private Map<String, Map<ShortcutAction, Set<String>>> keymaps = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Map<String, Map<ShortcutAction, Set<String>>> keymapDefaults = new HashMap<String, Map<ShortcutAction, Set<String>>>();

    public LayersBridge() {
        super(LAYERS_BRIDGE);
    }

    @Override
    public Map<String, Set<ShortcutAction>> getActions() {
        if (this.categoryToActions == null) {
            this.categoryToActions = new HashMap<String, Set<ShortcutAction>>();
            this.initActions("Actions", null);
            this.categoryToActions.remove("Hidden");
            this.categoryToActions = Collections.unmodifiableMap(this.categoryToActions);
        }
        return this.categoryToActions;
    }

    private void initActions(String folder, String category) {
        FileObject fo = FileUtil.getConfigFile((String)folder);
        if (fo == null) {
            return;
        }
        DataFolder root = DataFolder.findFolder((FileObject)fo);
        Enumeration en = root.children();
        while (en.hasMoreElements()) {
            DataObject dataObject = (DataObject)en.nextElement();
            if (!(dataObject instanceof DataFolder)) continue;
            this.initActions((DataFolder)dataObject, null, category);
        }
    }

    private void initActions(DataFolder folder, String folderName, String category) {
        String name = folder.getName();
        if (category != null) {
            name = category;
        } else {
            String bundleName = (String)folder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle");
            if (bundleName != null) {
                try {
                    name = NbBundle.getBundle((String)bundleName).getString(folder.getPrimaryFile().getPath());
                }
                catch (MissingResourceException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (folderName != null) {
                name = folderName + '/' + name;
            }
        }
        Enumeration en = folder.children();
        while (en.hasMoreElements()) {
            DataObject dataObject = (DataObject)en.nextElement();
            if (dataObject instanceof DataFolder) {
                this.initActions((DataFolder)dataObject, name, category);
                continue;
            }
            GlobalAction action = this.createAction(dataObject);
            if (this.actions.contains(action) || action == null) continue;
            this.actions.add(action);
            Set<ShortcutAction> a = this.categoryToActions.get(name);
            if (a == null) {
                a = new HashSet<ShortcutAction>();
                this.categoryToActions.put(name, a);
            }
            a.add(action);
            while (dataObject instanceof DataShadow) {
                dataObject = ((DataShadow)dataObject).getOriginal();
            }
            this.actionToDataObject.put(action, dataObject);
        }
    }

    private void refreshKeymapNames() {
        DataFolder root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
        Enumeration en = root.children(false);
        this.keymapNames = new ArrayList<String>();
        this.keymapDisplayNames = new HashMap<String, String>();
        while (en.hasMoreElements()) {
            String displayName;
            FileObject f = ((DataObject)en.nextElement()).getPrimaryFile();
            if (!f.isFolder()) continue;
            String name = f.getNameExt();
            try {
                displayName = f.getFileSystem().getStatus().annotateName(name, Collections.singleton(f));
            }
            catch (FileStateInvalidException fsie) {
                displayName = name;
            }
            this.keymapNames.add(name);
            this.keymapDisplayNames.put(name, displayName);
        }
        if (this.keymapNames.isEmpty()) {
            this.keymapNames.add("NetBeans");
        }
    }

    @Override
    public List<String> getProfiles() {
        if (this.keymapNames == null) {
            this.refreshKeymapNames();
        }
        return Collections.unmodifiableList(this.keymapNames);
    }

    @Override
    public String getProfileDisplayName(String profileName) {
        String displayName = this.keymapDisplayNames.get(profileName);
        return displayName == null ? profileName : displayName;
    }

    @Override
    public Map<ShortcutAction, Set<String>> getKeymap(String profile) {
        if (!this.keymaps.containsKey(profile)) {
            DataFolder root = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> m = this.readKeymap(root);
            root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
            m.putAll(this.readKeymap(root));
            this.keymaps.put(profile, m);
        }
        return Collections.unmodifiableMap(this.keymaps.get(profile));
    }

    @Override
    public Map<ShortcutAction, Set<String>> getDefaultKeymap(String profile) {
        if (!this.keymapDefaults.containsKey(profile)) {
            DataFolder root = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
            Map<ShortcutAction, Set<String>> m = this.readKeymap(root);
            root = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
            m.putAll(this.readKeymap(root));
            this.keymapDefaults.put(profile, m);
        }
        return Collections.unmodifiableMap(this.keymapDefaults.get(profile));
    }

    DataObject getDataObject(Object action) {
        return this.actionToDataObject.get(action);
    }

    private Map<ShortcutAction, Set<String>> readKeymap(DataFolder root) {
        HashMap<ShortcutAction, Set<String>> keymap = new HashMap<ShortcutAction, Set<String>>();
        if (root == null) {
            return keymap;
        }
        Enumeration en = root.children(false);
        while (en.hasMoreElements()) {
            GlobalAction action;
            DataObject dataObject = (DataObject)en.nextElement();
            if (dataObject instanceof DataFolder || (action = this.createAction(dataObject)) == null) continue;
            String shortcut = dataObject.getName();
            HashSet<String> s = (HashSet<String>)keymap.get(action);
            if (s == null) {
                s = new HashSet<String>();
                keymap.put(action, s);
            }
            s.add(shortcut);
        }
        return keymap;
    }

    @Override
    public void deleteProfile(String profile) {
        FileObject root = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (root == null) {
            return;
        }
        if ((root = root.getFileObject(profile)) == null) {
            return;
        }
        try {
            root.delete();
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    @Override
    public void saveKeymap(String profile, Map<ShortcutAction, Set<String>> actionToShortcuts) {
        this.keymaps.remove(profile);
        DataFolder folder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, profile);
        if (folder == null) {
            folder = LayersBridge.getRootFolder(KEYMAPS_FOLDER, null);
            try {
                folder = DataFolder.create((DataFolder)folder, (String)profile);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return;
            }
        }
        this.saveKeymap(folder, actionToShortcuts, true);
        folder = LayersBridge.getRootFolder(SHORTCUTS_FOLDER, null);
        this.saveKeymap(folder, actionToShortcuts, false);
    }

    private void saveKeymap(DataFolder folder, Map<ShortcutAction, Set<String>> actionToShortcuts, boolean add) {
        GlobalAction action;
        this.getActions();
        Map<String, ShortcutAction> shortcutToAction = LayersBridge.shortcutToAction(actionToShortcuts);
        Enumeration en = folder.children();
        while (en.hasMoreElements()) {
            DataObject dataObject = (DataObject)en.nextElement();
            GlobalAction a1 = (GlobalAction)shortcutToAction.get(dataObject.getName());
            if (a1 != null) {
                action = this.createAction(dataObject);
                if (action == null) continue;
                if (action.equals(a1)) {
                    shortcutToAction.remove(dataObject.getName());
                    continue;
                }
            }
            try {
                dataObject.delete();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (!add) {
            return;
        }
        for (String shortcut : shortcutToAction.keySet()) {
            action = (GlobalAction)shortcutToAction.get(shortcut);
            DataObject dataObject = this.actionToDataObject.get(action);
            if (dataObject == null) {
                if (System.getProperty("org.netbeans.optionsDialog") == null) continue;
                System.out.println("No original DataObject specified! Not possible to create shadow1. " + action);
                continue;
            }
            try {
                DataShadow.create((DataFolder)folder, (String)shortcut, (DataObject)dataObject);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static DataFolder getRootFolder(String name1, String name2) {
        FileObject root = FileUtil.getConfigRoot();
        FileObject fo1 = root.getFileObject(name1);
        try {
            if (fo1 == null) {
                fo1 = root.createFolder(name1);
            }
            if (fo1 == null) {
                return null;
            }
            if (name2 == null) {
                return DataFolder.findFolder((FileObject)fo1);
            }
            FileObject fo2 = fo1.getFileObject(name2);
            if (fo2 == null) {
                fo2 = fo1.createFolder(name2);
            }
            if (fo2 == null) {
                return null;
            }
            return DataFolder.findFolder((FileObject)fo2);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    private GlobalAction createAction(DataObject dataObject) {
        InstanceCookie ic = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
        if (ic == null) {
            return null;
        }
        try {
            Object action = ic.instanceCreate();
            if (action == null) {
                return null;
            }
            if (!(action instanceof Action)) {
                return null;
            }
            return new GlobalAction((Action)action);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static Map<String, ShortcutAction> shortcutToAction(Map<ShortcutAction, Set<String>> actionToShortcuts) {
        HashMap<String, ShortcutAction> shortcutToAction = new HashMap<String, ShortcutAction>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : actionToShortcuts.entrySet()) {
            ShortcutAction action = entry.getKey();
            Set<String> shortcuts = entry.getValue();
            ShortcutAction shortcutAction = action = action != null ? action.getKeymapManagerInstance(LAYERS_BRIDGE) : null;
            if (!(action instanceof GlobalAction)) continue;
            for (String multiShortcut : shortcuts) {
                shortcutToAction.put(multiShortcut, action);
            }
        }
        return shortcutToAction;
    }

    @Override
    public void refreshActions() {
        this.refreshKeymapNames();
    }

    @Override
    public String getCurrentProfile() {
        return null;
    }

    @Override
    public void setCurrentProfile(String profileName) {
    }

    @Override
    public boolean isCustomProfile(String profileName) {
        return false;
    }

    private static class GlobalAction
    implements ShortcutAction {
        private Action action;
        private String name;
        private String id;

        private GlobalAction(Action a) {
            this.action = a;
        }

        @Override
        public String getDisplayName() {
            if (this.name == null) {
                this.name = (String)this.action.getValue("Name");
                if (this.name == null) {
                    this.name = this.action.toString();
                }
                this.name = this.name.replaceAll("&", "").trim();
            }
            return this.name;
        }

        @Override
        public String getId() {
            if (this.id == null) {
                this.id = this.action.getClass().getName();
            }
            return this.id;
        }

        @Override
        public String getDelegatingActionId() {
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GlobalAction)) {
                return false;
            }
            return ((GlobalAction)o).action.equals(this.action);
        }

        public int hashCode() {
            return this.action.hashCode();
        }

        public String toString() {
            return "GlobalAction[" + this.getDisplayName() + ":" + this.id + "]";
        }

        @Override
        public ShortcutAction getKeymapManagerInstance(String keymapManagerName) {
            if (LayersBridge.LAYERS_BRIDGE.equals(keymapManagerName)) {
                return this;
            }
            return null;
        }
    }
}

