/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.registration;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.tomcat5.TomcatFactory;
import org.netbeans.modules.tomcat5.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AutomaticRegistration {
    private static final Logger LOGGER = Logger.getLogger(AutomaticRegistration.class.getName());

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            AutomaticRegistration.printHelpAndExit();
        }
        if ("--add".equals(stringArray[0])) {
            if (stringArray.length < 3) {
                AutomaticRegistration.printHelpAndExit();
            }
            int n = AutomaticRegistration.registerTomcatInstance(stringArray[1], stringArray[2]);
            System.exit(n);
        } else if ("--remove".equals(stringArray[0])) {
            if (stringArray.length < 3) {
                AutomaticRegistration.printHelpAndExit();
            }
            int n = AutomaticRegistration.unregisterTomcatInstance(stringArray[1], stringArray[2]);
            System.exit(n);
        } else if ("--list".equals(stringArray[0])) {
            if (stringArray.length < 2) {
                AutomaticRegistration.printHelpAndExit();
            }
            AutomaticRegistration.list(stringArray[1]);
        } else {
            AutomaticRegistration.printHelpAndExit();
        }
    }

    private static void printHelpAndExit() {
        System.out.println("Available actions:");
        System.out.println("\t--add <clusterDir> <catalinaHome>");
        System.out.println("\t--remove <clusterDir> <catalinaHome>");
        System.out.println("\t--list <clusterDir>");
        System.exit(-1);
    }

    private static int registerTomcatInstance(String string, String string2) {
        StringBuilder stringBuilder;
        String string3;
        System.setProperty("netbeans.user", string);
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server. The config/J2EE/InstalledServers folder cannot be created.");
            return 2;
        }
        File file = new File(string2);
        if (!file.exists()) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server. The Catalina Home directory " + string2 + " does not exist.");
            return 3;
        }
        try {
            string3 = TomcatFactory.getTomcatVersion(file);
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.  Cannot recognize the Tomcat version.");
            LOGGER.log(Level.INFO, null, illegalStateException);
            return 4;
        }
        if (string3.startsWith("5.0.")) {
            stringBuilder = new StringBuilder("tomcat:");
        } else if (string3.startsWith("5.5.")) {
            stringBuilder = new StringBuilder("tomcat55:");
        } else if (string3.startsWith("6.")) {
            stringBuilder = new StringBuilder("tomcat60:");
        } else {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.  The version " + string3 + " is not supported.");
            return 5;
        }
        stringBuilder.append("home=");
        stringBuilder.append(string2);
        stringBuilder.append(":base=");
        stringBuilder.append("apache-tomcat-");
        stringBuilder.append(string3);
        stringBuilder.append("_base");
        String string4 = stringBuilder.toString();
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (!string4.equals(fileObject2.getAttribute("url"))) continue;
            return 0;
        }
        String string5 = AutomaticRegistration.generateUniqueDisplayName(fileObject, string3);
        int n = AutomaticRegistration.registerServerInstanceFO(fileObject, string4, string5) ? 1 : 0;
        if (n != 0) {
            return 0;
        }
        return 6;
    }

    private static int unregisterTomcatInstance(String string, String string2) {
        System.setProperty("netbeans.user", string);
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^(" + Pattern.quote("tomcat:") + "|" + Pattern.quote("tomcat55:") + "|" + Pattern.quote("tomcat60:") + ")" + Pattern.quote("home=") + Pattern.quote(string2) + "(" + Pattern.quote(":base=") + ".+)?$");
        try {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                String string3 = fileObject2.getAttribute("url").toString();
                if (string3 == null || !pattern.matcher(string3).matches()) continue;
                fileObject2.delete();
                return 0;
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Cannot unregister the default Tomcat server.");
            LOGGER.log(Level.INFO, null, iOException);
            return 6;
        }
        return 0;
    }

    private static int list(String string) {
        System.setProperty("netbeans.user", string);
        FileObject fileObject = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        if (fileObject == null) {
            LOGGER.log(Level.INFO, "The config/J2EE/InstalledServers folder does not exist.");
            return 2;
        }
        Pattern pattern = Pattern.compile("^(" + Pattern.quote("tomcat:") + "|" + Pattern.quote("tomcat55:") + "|" + Pattern.quote("tomcat60:") + ")" + Pattern.quote("home=") + "(.+)$");
        for (FileObject fileObject2 : fileObject.getChildren()) {
            Matcher matcher;
            String string2 = fileObject2.getAttribute("url").toString();
            if (string2 == null || !(matcher = pattern.matcher(string2)).matches()) continue;
            String string3 = matcher.group(2);
            int n = string3.indexOf(":base=");
            System.out.println(string3.substring(0, n));
        }
        return 0;
    }

    private static String generateUniqueDisplayName(FileObject fileObject, String string) {
        String string2 = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcat", (Object)string);
        boolean bl = true;
        int n = 1;
        while (true) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (!string2.equals(fileObject2.getAttribute("displayName"))) continue;
                bl = false;
                break;
            }
            if (bl) break;
            string2 = NbBundle.getMessage(TomcatFactory.class, (String)"LBL_ApacheTomcatAlt", (Object)string, (Object)n++);
            bl = true;
        }
        return string2;
    }

    private static boolean registerServerInstanceFO(FileObject fileObject, String string, String string2) {
        String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"tomcat_autoregistered_instance", null);
        try {
            FileObject fileObject2 = fileObject.createData(string3);
            fileObject2.setAttribute("url", (Object)string);
            fileObject2.setAttribute("username", (Object)"ide");
            String string4 = Utils.generatePassword(8);
            fileObject2.setAttribute("password", (Object)string4);
            fileObject2.setAttribute("displayName", (Object)string2);
            fileObject2.setAttribute("httpportnumber", (Object)"8084");
            fileObject2.setAttribute("admin_port", (Object)"8025");
            fileObject2.setAttribute("monitor_enabled", (Object)"true");
            fileObject2.setAttribute("is_it_bundled_tomcat", (Object)"true");
            fileObject2.setAttribute("autoregistered", (Object)"true");
            return true;
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, "Cannot register the default Tomcat server.");
            LOGGER.log(Level.INFO, null, iOException);
            return false;
        }
    }
}

