/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.openide.util.NbBundle;

public final class TomcatFactory
implements DeploymentFactory {
    public static final String SERVER_ID_50 = "Tomcat";
    public static final String SERVER_ID_55 = "Tomcat55";
    public static final String SERVER_ID_60 = "Tomcat60";
    public static final String TOMCAT_URI_PREFIX_50 = "tomcat:";
    public static final String TOMCAT_URI_PREFIX_55 = "tomcat55:";
    public static final String TOMCAT_URI_PREFIX_60 = "tomcat60:";
    public static final String TOMCAT_URI_HOME_PREFIX = "home=";
    public static final String TOMCAT_URI_BASE_PREFIX = ":base=";
    private static final String DISCONNECTED_URI_50 = "tomcat:jakarta-tomcat-5.0.x";
    private static final String DISCONNECTED_URI_55 = "tomcat55:jakarta-tomcat-5.5.x";
    private static final String DISCONNECTED_URI_60 = "tomcat60:apache-tomcat-6.0.x";
    private static TomcatFactory instance;
    private static TomcatFactory instance55;
    private static TomcatFactory instance60;
    private static final WeakHashMap managerCache;
    private static Logger err;
    private final String tomcatUriPrefix;
    private final String disconnectedUri;
    private final TomcatManager.TomcatVersion version;

    private TomcatFactory(TomcatManager.TomcatVersion tomcatVersion) {
        this.version = tomcatVersion;
        switch (tomcatVersion) {
            case TOMCAT_50: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_50;
                this.disconnectedUri = DISCONNECTED_URI_50;
                break;
            }
            case TOMCAT_55: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_55;
                this.disconnectedUri = DISCONNECTED_URI_55;
                break;
            }
            default: {
                this.tomcatUriPrefix = TOMCAT_URI_PREFIX_60;
                this.disconnectedUri = DISCONNECTED_URI_60;
            }
        }
    }

    public static synchronized TomcatFactory create50() {
        if (instance == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_50);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
        }
        return instance;
    }

    public static synchronized TomcatFactory create55() {
        if (instance55 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance55 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_55);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance55);
        }
        return instance55;
    }

    public static synchronized TomcatFactory create60() {
        if (instance60 == null) {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, "Creating TomcatFactory");
            }
            instance60 = new TomcatFactory(TomcatManager.TomcatVersion.TOMCAT_60);
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance60);
        }
        return instance60;
    }

    public synchronized DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        if (!this.handlesURI(string)) {
            throw new DeploymentManagerCreationException("Invalid URI:" + string);
        }
        InstanceProperties instanceProperties = InstanceProperties.getInstanceProperties((String)string);
        if (instanceProperties == null && !this.disconnectedUri.equals(string)) {
            throw new DeploymentManagerCreationException("Tomcat instance: " + string + " is not registered in the IDE.");
        }
        TomcatManager tomcatManager = (TomcatManager)managerCache.get(instanceProperties);
        if (tomcatManager == null) {
            try {
                tomcatManager = new TomcatManager(true, string.substring(this.tomcatUriPrefix.length()), this.version);
                managerCache.put(instanceProperties, tomcatManager);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DeploymentManagerCreationException deploymentManagerCreationException = new DeploymentManagerCreationException("Cannot create deployment manager for Tomcat instance: " + string + ".");
                throw (DeploymentManagerCreationException)deploymentManagerCreationException.initCause(illegalArgumentException);
            }
        }
        return tomcatManager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        return this.getDeploymentManager(string, null, null);
    }

    public String getDisplayName() {
        switch (this.version) {
            case TOMCAT_50: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory");
            }
            case TOMCAT_55: {
                return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory55");
            }
        }
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactory60");
    }

    public String getProductVersion() {
        return NbBundle.getMessage(TomcatFactory.class, (String)"LBL_TomcatFactoryVersion");
    }

    public boolean handlesURI(String string) {
        return string != null && string.startsWith(this.tomcatUriPrefix);
    }

    public static String getTomcatVersion(File file) throws IllegalStateException {
        File file2 = new File(file, "lib/catalina.jar");
        if (!file2.exists()) {
            file2 = new File(file, "server/lib/catalina.jar");
        }
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{file2.toURL()});
            Class<?> clazz = uRLClassLoader.loadClass("org.apache.catalina.util.ServerInfo");
            Method method = clazz.getMethod("getServerInfo", new Class[0]);
            String string = (String)method.invoke(clazz, new Object[0]);
            int n = string.indexOf(47);
            if (n > 0) {
                return string.substring(n + 1);
            }
            throw new IllegalStateException("Cannot identify the version of the server.");
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalStateException(malformedURLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    static {
        managerCache = new WeakHashMap();
        err = Logger.getLogger("org.netbeans.modules.tomcat5");
    }
}

