/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.modules.editor.lib2.view.DocumentView;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorBoxViewChildren;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ParagraphView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;
import org.netbeans.modules.editor.lib2.view.WrapInfo;
import org.netbeans.modules.editor.lib2.view.WrapInfoUpdater;
import org.netbeans.modules.editor.lib2.view.WrapLine;

public final class ParagraphViewChildren
extends EditorBoxViewChildren<EditorView> {
    private static final Logger LOG = Logger.getLogger(ParagraphViewChildren.class.getName());
    private static final long serialVersionUID = 0L;
    private WrapInfo wrapInfo;

    public ParagraphViewChildren(int capacity) {
        super(capacity);
    }

    @Override
    protected boolean rawOffsetUpdate() {
        return true;
    }

    @Override
    protected boolean handleTabableViews() {
        return true;
    }

    @Override
    protected double getMajorAxisChildrenSpan(EditorBoxView boxView) {
        return this.wrapInfo != null ? this.wrapInfo.childrenWidth : super.getMajorAxisChildrenSpan(boxView);
    }

    @Override
    protected void setMajorAxisChildrenSpan(EditorBoxView boxView, double majorAxisSpan) {
        if (this.wrapInfo != null) {
            this.wrapInfo.childrenWidth = majorAxisSpan;
        } else {
            super.setMajorAxisChildrenSpan(boxView, majorAxisSpan);
        }
    }

    @Override
    protected float getMinorAxisChildrenSpan(EditorBoxView boxView) {
        return this.wrapInfo != null ? this.wrapInfo.childrenHeight : super.getMinorAxisChildrenSpan(boxView);
    }

    @Override
    protected void setMinorAxisChildrenSpan(EditorBoxView boxView, float minorAxisSpan) {
        if (this.wrapInfo != null) {
            this.wrapInfo.childrenHeight = minorAxisSpan;
        } else {
            super.setMinorAxisChildrenSpan(boxView, minorAxisSpan);
        }
    }

    @Override
    protected EditorView getWithChildrenValid(EditorBoxView boxView, int index) {
        return (EditorView)this.get(index);
    }

    @Override
    protected void updateSpans(EditorBoxView boxView, EditorBoxView.ReplaceResult result, int index, int removedCount, int addedCount, boolean majorAxisSpanChange, double visualOffset, double addedVisualSpan, double removedVisualSpan, boolean removedTillEnd, boolean minorAxisSpanChange, Shape alloc) {
        double origWidth = boxView.getMajorAxisSpan();
        float origHeight = boxView.getMinorAxisSpan();
        this.recomputeSpans(boxView);
        double width = boxView.getMajorAxisSpan();
        float height = boxView.getMinorAxisSpan();
        majorAxisSpanChange |= origWidth != width;
        minorAxisSpanChange |= origHeight != height;
        if (alloc != null) {
            Rectangle2D.Double repaintBounds = ViewUtils.shape2Bounds(alloc);
            if (this.wrapInfo == null) {
                repaintBounds.x += visualOffset;
                repaintBounds.width -= visualOffset;
            }
            if (majorAxisSpanChange || removedTillEnd) {
                result.widthChanged = true;
                repaintBounds.width = 1.073741823E9;
            }
            if (minorAxisSpanChange) {
                result.heightChanged = true;
                repaintBounds.height = 1.073741823E9;
            }
            result.repaintBounds = ViewUtils.toRect(repaintBounds);
        } else if (majorAxisSpanChange || minorAxisSpanChange) {
            boxView.preferenceChanged(null, majorAxisSpanChange, minorAxisSpanChange);
        }
    }

    void recomputeSpans(EditorBoxView boxView) {
        ParagraphView paragraphView = (ParagraphView)boxView;
        DocumentView docView = paragraphView.getDocumentView();
        if (docView != null) {
            boolean wrapDone = false;
            double childrenWidth = this.getMajorAxisChildrenSpan(boxView);
            float childrenHeight = this.getMinorAxisChildrenSpan(boxView);
            if (docView.getLineWrapType() != DocumentView.LineWrapType.NONE) {
                this.wrapInfo = null;
                float visibleWidth = docView.getVisibleWidth();
                if (visibleWidth > docView.getDefaultCharWidth() && childrenWidth > (double)visibleWidth) {
                    wrapDone = true;
                    this.wrapInfo = new WrapInfo(childrenWidth, childrenHeight);
                    float prefWidth = new WrapInfoUpdater(this.wrapInfo, this, paragraphView).initWrapInfo();
                    float prefHeight = this.wrapInfo.preferredHeight();
                    boxView.setMajorAxisSpan(prefWidth);
                    boxView.setMinorAxisSpan(prefHeight);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("WrapInfo.init(): pref[" + prefWidth + "," + prefHeight + "] " + this.wrapInfo.toString(paragraphView));
                    }
                }
            }
            if (!wrapDone) {
                boxView.setMajorAxisSpan(childrenWidth);
                boxView.setMinorAxisSpan(childrenHeight);
            }
        }
    }

    @Override
    protected void paint(EditorBoxView boxView, Graphics2D g, Shape alloc, Rectangle clipBounds) {
        if (this.wrapInfo != null) {
            Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
            double relY = (double)clipBounds.y - allocBounds.y;
            float wrapLineHeight = this.wrapInfo.childrenHeight;
            int startWrapLineIndex = relY < (double)wrapLineHeight ? 0 : (int)(relY / (double)wrapLineHeight);
            int endWrapLineIndex = relY >= (double)boxView.getMinorAxisSpan() ? this.wrapInfo.size() : (int)((relY += (double)((float)clipBounds.height + (wrapLineHeight - 1.0f))) / (double)wrapLineHeight);
            this.wrapInfo.paintWrapLines(this, (ParagraphView)boxView, startWrapLineIndex, endWrapLineIndex, g, alloc, clipBounds);
        } else {
            super.paint(boxView, g, alloc, clipBounds);
        }
    }

    @Override
    public Shape modelToViewChecked(EditorBoxView boxView, int offset, Shape alloc, Position.Bias bias) {
        if (this.wrapInfo != null) {
            Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
            int wrapLineCount = this.wrapInfo.size();
            int wrapLineIndex = 0;
            WrapLine wrapLine = null;
            while (++wrapLineIndex < wrapLineCount && this.getWrapLineStartOffset(boxView, wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex)) <= offset) {
            }
            wrapLine = (WrapLine)this.wrapInfo.get(--wrapLineIndex);
            allocBounds.y += (double)((float)wrapLineIndex * this.wrapInfo.childrenHeight);
            allocBounds.height = this.wrapInfo.childrenHeight;
            Shape ret = null;
            if (wrapLine.startViewPart != null && offset < wrapLine.startViewPart.getEndOffset()) {
                ret = wrapLine.startViewPart.modelToViewChecked(offset, allocBounds, bias);
                allocBounds.width = wrapLine.startViewX;
            } else if (wrapLine.endViewPart != null && offset >= wrapLine.endViewPart.getStartOffset()) {
                assert (wrapLine.endViewPart != null) : "Invalid wrapLine: " + wrapLine;
                allocBounds.x += (double)wrapLine.startViewX;
                if (wrapLine.hasFullViews()) {
                    allocBounds.x += boxView.getViewVisualOffset(wrapLine.endViewIndex) - boxView.getViewVisualOffset(wrapLine.startViewIndex);
                }
                allocBounds.width = wrapLine.endViewPart.getPreferredSpan(0);
                ret = wrapLine.endViewPart.modelToViewChecked(offset, allocBounds, bias);
            } else {
                assert (wrapLine.hasFullViews()) : this.wrapInfo.dumpWrapLine(boxView, wrapLineIndex);
                for (int i = wrapLine.startViewIndex; i < wrapLine.endViewIndex; ++i) {
                    if (offset >= ((View)boxView.getEditorView(i)).getEndOffset()) continue;
                    double startVisualOffset = boxView.getViewVisualOffset(wrapLine.startViewIndex);
                    double visualOffset = i != wrapLine.startViewIndex ? boxView.getViewVisualOffset(i) : startVisualOffset;
                    allocBounds.x += (double)wrapLine.startViewX + (visualOffset - startVisualOffset);
                    allocBounds.width = boxView.getViewVisualOffset(i + 1) - visualOffset;
                    ret = ((EditorView)boxView.getEditorView(i)).modelToViewChecked(offset, allocBounds, bias);
                    assert (ret != null);
                    break;
                }
            }
            return ret;
        }
        return super.modelToViewChecked(boxView, offset, alloc, bias);
    }

    private int getWrapLineStartOffset(EditorBoxView boxView, WrapLine wrapLine) {
        if (wrapLine.startViewPart != null) {
            return wrapLine.startViewPart.getStartOffset();
        }
        if (wrapLine.hasFullViews()) {
            return boxView.getView(wrapLine.startViewIndex).getStartOffset();
        }
        assert (wrapLine.endViewPart != null) : "Invalid wrapLine: " + wrapLine;
        return wrapLine.endViewPart.getStartOffset();
    }

    @Override
    public int viewToModelChecked(EditorBoxView boxView, double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        if (this.wrapInfo != null) {
            int wrapLineIndex;
            Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
            double relY = y - allocBounds.y;
            float wrapLineHeight = this.wrapInfo.childrenHeight;
            if (relY < (double)wrapLineHeight) {
                wrapLineIndex = 0;
            } else {
                wrapLineIndex = (int)(relY / (double)wrapLineHeight);
                int wrapLineCount = this.wrapInfo.size();
                if (wrapLineIndex >= wrapLineCount) {
                    wrapLineIndex = wrapLineCount - 1;
                }
            }
            allocBounds.y += relY;
            allocBounds.height = this.wrapInfo.childrenHeight;
            WrapLine wrapLine = (WrapLine)this.wrapInfo.get(wrapLineIndex);
            if (wrapLine.startViewPart != null && (x < (double)wrapLine.startViewX || !wrapLine.hasFullViews() && wrapLine.endViewPart == null)) {
                allocBounds.width = wrapLine.startViewX;
                return wrapLine.startViewPart.viewToModelChecked(x, y, allocBounds, biasReturn);
            }
            allocBounds.x += (double)wrapLine.startViewX;
            if (wrapLine.hasFullViews()) {
                double lastVisualOffset = boxView.getViewVisualOffset(wrapLine.startViewIndex);
                for (int i = wrapLine.startViewIndex; i < wrapLine.endViewIndex; ++i) {
                    double nextVisualOffset = boxView.getViewVisualOffset(i + 1);
                    allocBounds.width = nextVisualOffset - lastVisualOffset;
                    if (x < allocBounds.x + allocBounds.width) {
                        return ((EditorView)boxView.getEditorView(i)).viewToModelChecked(x, y, allocBounds, biasReturn);
                    }
                    allocBounds.x += allocBounds.width;
                    lastVisualOffset = nextVisualOffset;
                }
                if (wrapLine.endViewPart == null) {
                    allocBounds.x -= allocBounds.width;
                    return ((EditorView)boxView.getEditorView(wrapLine.endViewIndex - 1)).viewToModelChecked(x, y, allocBounds, biasReturn);
                }
            }
            assert (wrapLine.endViewPart != null) : "Null endViewPart";
            allocBounds.width = wrapLine.endViewPart.getPreferredSpan(0);
            return wrapLine.endViewPart.viewToModelChecked(x, y, allocBounds, biasReturn);
        }
        return super.viewToModelChecked(boxView, x, y, alloc, biasReturn);
    }

    @Override
    public StringBuilder appendChildrenInfo(EditorBoxView boxView, StringBuilder sb, int indent, int importantIndex) {
        super.appendChildrenInfo(boxView, sb, indent, importantIndex);
        if (this.wrapInfo != null) {
            this.wrapInfo.appendInfo(sb, (ParagraphView)boxView, indent);
        }
        return sb;
    }
}

