/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Position;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.modules.editor.lib2.view.EditorBoxView;
import org.netbeans.modules.editor.lib2.view.EditorView;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

public class EditorBoxViewChildren<V extends EditorView>
extends GapList<V> {
    private static final Logger LOG = Logger.getLogger(EditorBoxViewChildren.class.getName());
    protected static final double EXTEND_TO_END = 1.073741823E9;
    private static final int GAP_STORAGE_THRESHOLD = 10;
    private static final long serialVersionUID = 0L;
    GapStorage gapStorage;

    EditorBoxViewChildren(int capacity) {
        super(capacity);
    }

    protected boolean rawOffsetUpdate() {
        return false;
    }

    protected boolean handleTabableViews() {
        return false;
    }

    public EditorBoxView.ReplaceResult replace(EditorBoxView<V> boxView, EditorBoxView.ReplaceResult result, int index, int removeCount, View[] addedViews, int offsetDelta, Shape alloc) {
        boolean majorAxisChildrenSpanChange;
        double removedSpan;
        boolean modified = false;
        int viewCount = this.size();
        if (index < 0) {
            throw new IllegalArgumentException("index=" + index + " < 0");
        }
        if (removeCount < 0) {
            throw new IllegalArgumentException("removeCount=" + removeCount + " < 0");
        }
        if (index + removeCount > viewCount) {
            throw new IllegalArgumentException("index=" + index + ", removeCount=" + removeCount + ", viewCount=" + viewCount);
        }
        boolean removedTillEnd = index + removeCount == viewCount;
        this.moveStorage(index + removeCount);
        double visualOffset = this.getViewVisualOffset(boxView, index);
        int gapIndexDelta = -removeCount;
        if (removeCount != 0) {
            removedSpan = this.getViewVisualOffset(boxView, index + removeCount) - visualOffset;
            this.remove(index, removeCount);
            modified = true;
        } else {
            removedSpan = 0.0;
        }
        double addedSpan = 0.0;
        float minorAxisChildrenSpan = this.getMinorAxisChildrenSpan(boxView);
        boolean minorAxisChildrenSpanChange = false;
        int majorAxis = boxView.getMajorAxis();
        if (this.gapStorage != null) {
            this.gapStorage.offsetGapStart += offsetDelta;
            this.gapStorage.offsetGapLength -= offsetDelta;
        }
        if (addedViews != null && addedViews.length != 0) {
            modified = true;
            gapIndexDelta += addedViews.length;
            this.addArray(index, addedViews);
            int boxViewStartOffset = boxView.getStartOffset();
            int minorAxis = ViewUtils.getOtherAxis(majorAxis);
            boolean supportsRawOffsetUpdate = this.rawOffsetUpdate();
            double viewVisualOffset = visualOffset;
            TabExpander tabExpander = boxView.getTabExpander();
            for (int i = 0; i < addedViews.length; ++i) {
                EditorView view = (EditorView)addedViews[i];
                if (supportsRawOffsetUpdate) {
                    int offset = view.getRawOffset();
                    view.setRawOffset(offset - boxViewStartOffset);
                }
                view.setParent(boxView);
                float majorSpan = this.handleTabableViews() && view instanceof TabableView ? ((TabableView)((Object)view)).getTabbedSpan((float)viewVisualOffset, tabExpander) : view.getPreferredSpan(majorAxis);
                float minorSpan = view.getPreferredSpan(minorAxis);
                view.setRawVisualOffset(viewVisualOffset);
                viewVisualOffset += (double)majorSpan;
                addedSpan += (double)majorSpan;
                if (!(minorSpan > minorAxisChildrenSpan)) continue;
                minorAxisChildrenSpan = minorSpan;
                minorAxisChildrenSpanChange = true;
            }
        }
        if (this.gapStorage != null) {
            this.gapStorage.gapIndex += gapIndexDelta;
        }
        boolean bl = majorAxisChildrenSpanChange = addedSpan != removedSpan;
        if (majorAxisChildrenSpanChange || offsetDelta != 0) {
            this.fixOffsetsAndMajorSpan(boxView, index + addedViews.length, offsetDelta, addedSpan - removedSpan);
        }
        if (minorAxisChildrenSpanChange) {
            this.setMinorAxisChildrenSpan(boxView, minorAxisChildrenSpan);
        }
        if (modified) {
            this.updateSpans(boxView, result, index, removeCount, addedViews.length, majorAxisChildrenSpanChange, visualOffset, addedSpan, removedSpan, removedTillEnd, minorAxisChildrenSpanChange, alloc);
        }
        boxView.setLength(this.getLength());
        return result;
    }

    protected double getMajorAxisChildrenSpan(EditorBoxView boxView) {
        return boxView.getMajorAxisSpan();
    }

    protected void setMajorAxisChildrenSpan(EditorBoxView boxView, double majorAxisSpan) {
        boxView.setMajorAxisSpan(majorAxisSpan);
    }

    protected float getMinorAxisChildrenSpan(EditorBoxView boxView) {
        return boxView.getMinorAxisSpan();
    }

    protected void setMinorAxisChildrenSpan(EditorBoxView boxView, float minorAxisSpan) {
        boxView.setMinorAxisSpan(minorAxisSpan);
    }

    protected void updateSpans(EditorBoxView boxView, EditorBoxView.ReplaceResult result, int index, int removedCount, int addedCount, boolean majorAxisSpanChange, double visualOffset, double addedSpan, double removedSpan, boolean removedTillEnd, boolean minorAxisSpanChange, Shape alloc) {
        int majorAxis = boxView.getMajorAxis();
        if (alloc != null) {
            Rectangle2D.Double repaintBounds = ViewUtils.shape2Bounds(alloc);
            assert (repaintBounds.width >= 0.0) : "repaintBounds.width=" + repaintBounds.width;
            assert (repaintBounds.height >= 0.0) : "repaintBounds.height=" + repaintBounds.height + "; boxView=" + boxView + ", addedSpan=" + addedSpan + ", removedSpan=" + removedSpan + ", visualOffset=" + visualOffset;
            if (majorAxis == 0) {
                repaintBounds.x += visualOffset;
                if (majorAxisSpanChange || removedTillEnd) {
                    result.widthChanged = true;
                    repaintBounds.width = 1.073741823E9;
                } else {
                    repaintBounds.width = removedSpan;
                }
                if (minorAxisSpanChange) {
                    result.heightChanged = true;
                    repaintBounds.height = 1.073741823E9;
                }
            } else {
                repaintBounds.y += visualOffset;
                if (majorAxisSpanChange || removedTillEnd) {
                    result.heightChanged = true;
                    repaintBounds.height = 1.073741823E9;
                } else {
                    repaintBounds.height = removedSpan;
                }
                if (minorAxisSpanChange) {
                    result.widthChanged = true;
                    repaintBounds.width = 1.073741823E9;
                }
            }
            result.repaintBounds = ViewUtils.toRect(repaintBounds);
        } else if (majorAxisSpanChange || minorAxisSpanChange) {
            if (majorAxis == 0) {
                boxView.preferenceChanged(null, majorAxisSpanChange, minorAxisSpanChange);
            } else {
                boxView.preferenceChanged(null, minorAxisSpanChange, majorAxisSpanChange);
            }
        }
    }

    protected V getWithChildrenValid(EditorBoxView boxView, int index) {
        EditorView child = (EditorView)this.get(index);
        if (child instanceof EditorBoxView) {
            EditorBoxView boxChild = (EditorBoxView)child;
            if (boxChild.children == null) {
                boxView.initChildren(index, index + 1);
                child = (EditorView)this.get(index);
                assert (((EditorBoxView)child).children != null);
            }
        }
        return (V)child;
    }

    int getViewIndex(int offset, Position.Bias bias) {
        if (bias == Position.Bias.Backward) {
            --offset;
        }
        return this.getViewIndex(offset);
    }

    int getViewIndex(int offset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midStartOffset = ((EditorView)this.get(mid)).getStartOffset();
            if (midStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (midStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(high, 0);
    }

    int raw2RelOffset(int rawOffset) {
        return this.gapStorage == null || rawOffset < this.gapStorage.offsetGapStart ? rawOffset : rawOffset - this.gapStorage.offsetGapLength;
    }

    int relOffset2Raw(int offset) {
        return this.gapStorage == null || offset < this.gapStorage.offsetGapStart ? offset : offset + this.gapStorage.offsetGapLength;
    }

    int getLength() {
        int size = this.size();
        if (size > 0) {
            EditorView lastChildView = (EditorView)this.get(size - 1);
            return this.raw2RelOffset(lastChildView.getRawOffset()) + lastChildView.getLength();
        }
        return 0;
    }

    private double raw2VisualOffset(double rawVisualOffset) {
        return this.gapStorage == null || rawVisualOffset < this.gapStorage.visualGapStart ? rawVisualOffset : rawVisualOffset - this.gapStorage.visualGapLength;
    }

    final double getViewVisualOffset(EditorBoxView boxView, int index) {
        return index == this.size() ? this.getMajorAxisChildrenSpan(boxView) : this.getViewVisualOffset(index);
    }

    final double getViewVisualOffset(int index) {
        return this.getViewVisualOffset(((EditorView)this.get(index)).getRawVisualOffset());
    }

    final double getViewVisualOffset(double rawVisualOffset) {
        return this.raw2VisualOffset(rawVisualOffset);
    }

    final double getViewMajorAxisSpan(EditorBoxView boxView, int index) {
        return index == this.size() - 1 ? this.getMajorAxisChildrenSpan(boxView) - this.getViewVisualOffset(index) : this.getViewVisualOffset(index + 1) - this.getViewVisualOffset(index);
    }

    Shape getChildAllocation(EditorBoxView boxView, int startIndex, int endIndex, Shape alloc) {
        double endVisualOffset;
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        double visualOffset = this.getViewVisualOffset(startIndex);
        double d = endVisualOffset = endIndex == this.size() ? this.getMajorAxisChildrenSpan(boxView) : this.getViewVisualOffset(endIndex);
        if (boxView.getMajorAxis() == 0) {
            mutableBounds.x += visualOffset;
            mutableBounds.width = endVisualOffset - visualOffset;
            mutableBounds.height = boxView.getMinorAxisSpan();
        } else {
            mutableBounds.y += visualOffset;
            mutableBounds.height = endVisualOffset - visualOffset;
            mutableBounds.width = boxView.getMinorAxisSpan();
        }
        return mutableBounds;
    }

    int getViewIndexFirst(int offset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            int viewStartOffset = ((EditorView)this.get(mid)).getStartOffset();
            if (viewStartOffset < offset) {
                low = mid + 1;
                continue;
            }
            if (viewStartOffset > offset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0) {
                if ((viewStartOffset = ((EditorView)this.get(--mid)).getStartOffset()) >= offset) continue;
                ++mid;
                break;
            }
            high = mid;
            break;
        }
        return Math.max(high, 0);
    }

    private int getViewIndexFirst(double visualOffset) {
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        while (low <= high) {
            int mid = low + high >>> 1;
            double viewVisualOffset = this.getViewVisualOffset(mid);
            if (viewVisualOffset < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (viewVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            while (mid > 0) {
                if (!((viewVisualOffset = this.getViewVisualOffset(--mid)) < visualOffset)) continue;
                ++mid;
                break;
            }
            high = mid;
            break;
        }
        return Math.max(high, 0);
    }

    final void moveStorage(int index) {
        if (this.size() > 0 && this.gapStorage != null) {
            this.moveGap(index);
        }
    }

    final void fixOffsetsAndMajorSpan(EditorBoxView boxView, int index, int offsetDelta, double visualDelta) {
        boolean visualUpdate;
        int viewCount = this.size();
        boolean bl = visualUpdate = visualDelta != 0.0;
        if (this.gapStorage != null) {
            this.gapStorage.visualGapStart += visualDelta;
            this.gapStorage.visualGapLength -= visualDelta;
            if (this.handleTabableViews()) {
                TabExpander tabExpander = boxView.getTabExpander();
                double tabVisualDelta = 0.0;
                boolean tabVisualUpdate = false;
                for (int i = index; i < viewCount; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    if (tabVisualUpdate) {
                        view.setRawVisualOffset(view.getRawVisualOffset() + tabVisualDelta);
                    }
                    if (!(view instanceof TabableView)) continue;
                    double visualOffset = view.getRawVisualOffset() - this.gapStorage.visualGapLength;
                    double nextViewVisualOffset = i != viewCount - 1 ? ((EditorView)this.get(i + 1)).getRawVisualOffset() - this.gapStorage.visualGapLength : this.getMajorAxisChildrenSpan(boxView) + visualDelta;
                    double origMajorSpan = nextViewVisualOffset + tabVisualDelta - visualOffset;
                    double majorSpan = ((TabableView)((Object)view)).getTabbedSpan((float)visualOffset, tabExpander);
                    double majorSpanDelta = majorSpan - origMajorSpan;
                    if (majorSpanDelta == 0.0) continue;
                    tabVisualUpdate = (tabVisualDelta += majorSpanDelta) != 0.0;
                }
                visualUpdate = (visualDelta += tabVisualDelta) != 0.0;
            }
        } else {
            boolean offsetUpdate = this.rawOffsetUpdate() && offsetDelta != 0;
            TabExpander tabExpander = boxView.getTabExpander();
            for (int i = index; i < viewCount; ++i) {
                EditorView view = (EditorView)this.get(i);
                if (offsetUpdate) {
                    view.setRawOffset(view.getRawOffset() + offsetDelta);
                }
                if (visualUpdate) {
                    view.setRawVisualOffset(view.getRawVisualOffset() + visualDelta);
                }
                if (!this.handleTabableViews() || !(view instanceof TabableView)) continue;
                double visualOffset = view.getRawVisualOffset();
                double nextViewVisualOffset = i != viewCount - 1 ? ((EditorView)this.get(i + 1)).getRawVisualOffset() : this.getMajorAxisChildrenSpan(boxView);
                double origMajorSpan = nextViewVisualOffset + visualDelta - visualOffset;
                double majorSpan = ((TabableView)((Object)view)).getTabbedSpan((float)visualOffset, tabExpander);
                double majorSpanDelta = majorSpan - origMajorSpan;
                if (majorSpanDelta == 0.0) continue;
                visualUpdate = (visualDelta += majorSpanDelta) != 0.0;
            }
        }
        if (visualUpdate) {
            this.setMajorAxisChildrenSpan(boxView, this.getMajorAxisChildrenSpan(boxView) + visualDelta);
        }
    }

    private void moveGap(int index) {
        this.checkGap();
        if (index != this.gapStorage.gapIndex) {
            boolean supportsRawOffsetUpdate = this.rawOffsetUpdate();
            if (index < this.gapStorage.gapIndex) {
                int lastOffset = 0;
                double lastVisualOffset = 0.0;
                for (int i = this.gapStorage.gapIndex - 1; i >= index; --i) {
                    EditorView view = (EditorView)this.get(i);
                    if (supportsRawOffsetUpdate) {
                        lastOffset = view.getRawOffset();
                        view.setRawOffset(lastOffset + this.gapStorage.offsetGapLength);
                    }
                    lastVisualOffset = view.getRawVisualOffset();
                    view.setRawVisualOffset(lastVisualOffset + this.gapStorage.visualGapLength);
                }
                if (supportsRawOffsetUpdate) {
                    this.gapStorage.offsetGapStart = lastOffset;
                }
                this.gapStorage.visualGapStart = lastVisualOffset;
            } else {
                for (int i = this.gapStorage.gapIndex; i < index; ++i) {
                    EditorView view = (EditorView)this.get(i);
                    view.setRawVisualOffset(view.getRawVisualOffset() - this.gapStorage.visualGapLength);
                    if (!supportsRawOffsetUpdate) continue;
                    view.setRawOffset(view.getRawOffset() - this.gapStorage.offsetGapLength);
                }
                if (index < this.size()) {
                    EditorView view = (EditorView)this.get(index);
                    if (supportsRawOffsetUpdate) {
                        this.gapStorage.offsetGapStart = view.getRawOffset() - this.gapStorage.offsetGapLength;
                    }
                    this.gapStorage.visualGapStart = view.getRawVisualOffset() - this.gapStorage.visualGapLength;
                } else {
                    assert (index == this.size()) : "Invalid requested index=" + index + ", size()=" + this.size() + ", gapIndex=" + this.gapStorage.gapIndex;
                    if (supportsRawOffsetUpdate) {
                        this.gapStorage.offsetGapStart = 0x3FFFFFFF;
                    }
                    this.gapStorage.visualGapStart = 2.147483647E9;
                }
            }
            this.gapStorage.gapIndex = index;
        }
        this.checkGap();
    }

    private void checkGap() {
        if (LOG.isLoggable(Level.FINE) && this.gapStorage != null) {
            String error = null;
            int gapIndex = this.gapStorage.gapIndex;
            if (gapIndex > this.size()) {
                error = "gapIndex=" + gapIndex + " > size()=" + this.size();
            } else {
                for (int i = 0; i < this.size(); ++i) {
                    EditorView view = (EditorView)this.get(i);
                    int rawOffset = view.getRawOffset();
                    int relOffset = this.raw2RelOffset(rawOffset);
                    double rawVisualOffset = view.getRawVisualOffset();
                    double visualOffset = this.raw2VisualOffset(rawVisualOffset);
                    if (this.rawOffsetUpdate()) {
                        if (i < gapIndex) {
                            if (rawOffset >= this.gapStorage.offsetGapStart) {
                                error = "Not below offset-gap: rawOffset=" + rawOffset + " >= offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                        } else {
                            if (rawOffset < this.gapStorage.offsetGapStart) {
                                error = "Not above offset-gap: rawOffset=" + rawOffset + " < offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                            if (i == gapIndex && relOffset != this.gapStorage.offsetGapStart) {
                                error = "relOffset=" + relOffset + " != gapStorage.offsetGapStart=" + this.gapStorage.offsetGapStart;
                            }
                        }
                    }
                    if (i < gapIndex) {
                        if (rawVisualOffset >= this.gapStorage.visualGapStart) {
                            error = "Not below visual-gap: rawVisualOffset=" + rawVisualOffset + " >= visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                    } else {
                        if (rawVisualOffset < this.gapStorage.visualGapStart) {
                            error = "Not above visual-gap: rawVisualOffset=" + rawVisualOffset + " < visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                        if (i == gapIndex && visualOffset != this.gapStorage.visualGapStart) {
                            error = "visualOffset=" + visualOffset + " != gapStorage.visualGapStart=" + this.gapStorage.visualGapStart;
                        }
                    }
                    if (error != null) break;
                }
            }
            if (error != null) {
                throw new IllegalStateException("gapStorage INTEGRITY ERROR!!!\n" + error);
            }
        }
    }

    public int getViewIndexAtPoint(EditorBoxView boxView, double x, double y, Shape alloc) {
        double visualOffset;
        Rectangle2D.Double mutableBounds = ViewUtils.shape2Bounds(alloc);
        x -= mutableBounds.x;
        y -= mutableBounds.y;
        int high = this.size() - 1;
        if (high == -1) {
            return -1;
        }
        int low = 0;
        double d = visualOffset = boxView.getMajorAxis() == 0 ? x : y;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midVisualOffset = this.getViewVisualOffset(mid);
            if (midVisualOffset < visualOffset) {
                low = mid + 1;
                continue;
            }
            if (midVisualOffset > visualOffset) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return Math.max(high, 0);
    }

    public Shape modelToViewChecked(EditorBoxView boxView, int offset, Shape alloc, Position.Bias bias) {
        int index = this.getViewIndex(offset, bias);
        if (index >= 0) {
            V view = this.getWithChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            return ((EditorView)view).modelToViewChecked(offset, childAlloc, bias);
        }
        return alloc;
    }

    public int viewToModelChecked(EditorBoxView boxView, double x, double y, Shape alloc, Position.Bias[] biasReturn) {
        int offset;
        int index = this.getViewIndexAtPoint(boxView, x, y, alloc);
        if (index >= 0) {
            V view = this.getWithChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            offset = ((EditorView)view).viewToModelChecked(x, y, childAlloc, biasReturn);
        } else {
            offset = boxView.getStartOffset();
        }
        return offset;
    }

    public String getToolTipTextChecked(EditorBoxView boxView, double x, double y, Shape alloc) {
        int index = this.getViewIndexAtPoint(boxView, x, y, alloc);
        if (index >= 0) {
            V view = this.getWithChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            return ((EditorView)view).getToolTipTextChecked(x, y, childAlloc);
        }
        return null;
    }

    protected void paint(EditorBoxView boxView, Graphics2D g, Shape alloc, Rectangle clipBounds) {
        int endIndex;
        int index;
        Rectangle2D.Double allocBounds = ViewUtils.shape2Bounds(alloc);
        if (clipBounds.contains(allocBounds)) {
            index = 0;
            endIndex = this.size();
        } else {
            Rectangle2D.Double mutableBounds = (Rectangle2D.Double)allocBounds.clone();
            Rectangle2D.intersect(mutableBounds, clipBounds, mutableBounds);
            if (!mutableBounds.isEmpty()) {
                double endVisualOffset;
                double visualOffset;
                int majorAxis = boxView.getMajorAxis();
                if (majorAxis == 0) {
                    visualOffset = mutableBounds.x;
                    endVisualOffset = visualOffset + mutableBounds.width;
                } else {
                    visualOffset = mutableBounds.y;
                    endVisualOffset = visualOffset + mutableBounds.height;
                }
                index = Math.max(this.getViewIndexFirst(visualOffset), 0);
                endIndex = this.getViewIndexFirst(endVisualOffset) + 1;
            } else {
                index = 0;
                endIndex = 0;
            }
        }
        while (index < endIndex) {
            V view = this.getWithChildrenValid(boxView, index);
            Shape childAlloc = this.getChildAllocation(boxView, index, index + 1, alloc);
            ((EditorView)view).paint(g, childAlloc, clipBounds);
            ++index;
        }
    }

    public StringBuilder appendChildrenInfo(EditorBoxView boxView, StringBuilder sb, int indent, int importantIndex) {
        int viewCount = this.size();
        int digitCount = ArrayUtilities.digitCount((int)viewCount);
        int importantLastIndex = -1;
        int childImportantIndex = importantIndex == -2 ? -2 : -1;
        for (int i = 0; i < viewCount; ++i) {
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            ArrayUtilities.appendBracketedIndex((StringBuilder)sb, (int)i, (int)digitCount);
            EditorView view = (EditorView)this.get(i);
            view.appendViewInfo(sb, indent, childImportantIndex);
            boolean appendDots = false;
            if (i == 4) {
                if (importantIndex == -1) {
                    if (i < viewCount - 6) {
                        appendDots = true;
                        i = viewCount - 6;
                    }
                } else if (importantIndex >= 0) {
                    importantLastIndex = importantIndex + 3;
                    if (i < (importantIndex -= 3) - 1) {
                        appendDots = true;
                        i = importantIndex - 1;
                    }
                }
            } else if (i == importantLastIndex && i < viewCount - 6) {
                appendDots = true;
                i = viewCount - 6;
            }
            if (!appendDots) continue;
            sb.append('\n');
            ArrayUtilities.appendSpaces((StringBuilder)sb, (int)indent);
            sb.append("...");
        }
        return sb;
    }

    protected StringBuilder appendViewInfoCore(StringBuilder sb, int indent, int importantChildIndex) {
        if (this.gapStorage != null) {
            this.gapStorage.appendInfo(sb);
        }
        return sb;
    }

    static final class GapStorage {
        static final double INITIAL_VISUAL_GAP_LENGTH = 2.147483647E9;
        static final int INITIAL_OFFSET_GAP_LENGTH = 0x3FFFFFFF;
        double visualGapStart = 2.147483647E9;
        double visualGapLength = 2.147483647E9;
        int offsetGapStart = 0x3FFFFFFF;
        int offsetGapLength = 0x3FFFFFFF;
        int gapIndex;

        GapStorage(int gapIndex) {
            this.gapIndex = gapIndex;
        }

        StringBuilder appendInfo(StringBuilder sb) {
            sb.append("<").append(this.offsetGapStart).append("|").append(this.offsetGapLength);
            sb.append(", vis<").append(this.visualGapStart).append("|").append(this.visualGapLength);
            return sb;
        }

        public String toString() {
            return this.appendInfo(new StringBuilder(100)).toString();
        }
    }
}

