/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.websvc.rest.model.api.RestApplication;
import org.netbeans.modules.websvc.rest.model.api.RestApplications;
import org.netbeans.modules.websvc.rest.model.impl.RestApplicationImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

public class RestApplicationsImpl
implements RestApplications {
    private Project project;
    private AnnotationModelHelper helper;
    private volatile PersistentObjectManager<RestApplicationImpl> restApplicationManager;

    public static RestApplicationsImpl create(AnnotationModelHelper annotationModelHelper, Project project) {
        RestApplicationsImpl restApplicationsImpl = new RestApplicationsImpl(annotationModelHelper, project);
        restApplicationsImpl.initialize();
        return restApplicationsImpl;
    }

    private void initialize() {
        this.restApplicationManager = this.helper.createPersistentObjectManager((ObjectProvider)new RestApplicationsProvider());
    }

    private RestApplicationsImpl(AnnotationModelHelper annotationModelHelper, Project project) {
        this.project = project;
        this.helper = annotationModelHelper;
    }

    @Override
    public List<RestApplication> getRestApplications() {
        return new ArrayList<RestApplication>(this.restApplicationManager.getObjects());
    }

    private final class RestApplicationsProvider
    implements ObjectProvider<RestApplicationImpl> {
        private RestApplicationsProvider() {
        }

        public List<RestApplicationImpl> createInitialObjects() throws InterruptedException {
            HashMap<TypeElement, RestApplicationImpl> hashMap = new HashMap<TypeElement, RestApplicationImpl>();
            this.findAnnotations("javax.ws.rs.ApplicationPath", EnumSet.of(ElementKind.CLASS), hashMap);
            return new ArrayList<RestApplicationImpl>(hashMap.values());
        }

        public List<RestApplicationImpl> createObjects(TypeElement typeElement) {
            if (Utils.isRestApplication(typeElement, RestApplicationsImpl.this.helper)) {
                return Collections.singletonList(new RestApplicationImpl(RestApplicationsImpl.this.helper, typeElement));
            }
            return Collections.emptyList();
        }

        public boolean modifyObjects(TypeElement typeElement, List<RestApplicationImpl> list) {
            assert (list.size() == 1);
            if (Utils.isRestApplication(typeElement, RestApplicationsImpl.this.helper)) {
                return false;
            }
            String string = list.get(0).getApplicationPath();
            return string != null && !string.equals(Utils.getApplicationPath(typeElement));
        }

        private void findAnnotations(String string, EnumSet<ElementKind> enumSet, final Map<TypeElement, RestApplicationImpl> map) throws InterruptedException {
            RestApplicationsImpl.this.helper.getAnnotationScanner().findAnnotations(string, enumSet, new AnnotationHandler(){

                public void handleAnnotation(TypeElement typeElement, Element element, AnnotationMirror annotationMirror) {
                    if (!map.containsKey(typeElement)) {
                        map.put(typeElement, new RestApplicationImpl(RestApplicationsImpl.this.helper, typeElement));
                    }
                }
            });
        }
    }
}

