/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.SwingUtilities;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsFileTableModel;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.VersionsCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.MultiDiffPanel;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class DiffExecutor {
    private final Context context;
    private final String contextName;

    public DiffExecutor(Context context, String contextName) {
        this.context = context;
        this.contextName = contextName;
    }

    public DiffExecutor(String contextName) {
        this.contextName = contextName;
        this.context = null;
    }

    public void showDiff(ExecutorGroup group, int type) {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException();
        }
        VersionsCache.getInstance().purgeVolatileRevisions();
        MultiDiffPanel panel = new MultiDiffPanel(this.context, type, this.contextName, group);
        this.openDiff(panel, group);
    }

    public void showDiff(File file, String rev1, String rev2) {
        MultiDiffPanel panel = new MultiDiffPanel(file, rev1, rev2);
        this.openDiff(panel, null);
    }

    private void openDiff(final MultiDiffPanel c, final ExecutorGroup group) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiffTopComponent tc = new DiffTopComponent(c);
                tc.setName(NbBundle.getMessage(DiffExecutor.class, (String)"CTL_DiffPanel_Title", (Object)DiffExecutor.this.contextName));
                tc.open();
                tc.requestActive();
                tc.setGroup(group);
            }
        });
    }

    public static File[] getModifiedFiles(Context context, int includeStatus) {
        CvsFileTableModel model = CvsVersioningSystem.getInstance().getFileTableModel(context, includeStatus);
        CvsFileNode[] nodes = model.getNodes();
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < nodes.length; ++i) {
            File file = nodes[i].getFile();
            if (CvsModuleConfig.getDefault().isExcludedFromCommit(file)) continue;
            files.add(file);
        }
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        File[] rootFiles = context.getRootFiles();
        for (int i = 0; i < rootFiles.length; ++i) {
            File file = rootFiles[i];
            if (!file.isFile() || (cache.getStatus(file).getStatus() & includeStatus) == 0 || files.contains(file)) continue;
            files.add(file);
        }
        return files.toArray(new File[files.size()]);
    }

    private static class DiffTopComponent
    extends TopComponent
    implements DiffSetupSource {
        private final Lookup lookup;

        public DiffTopComponent(MultiDiffPanel c) {
            this.setLayout(new BorderLayout());
            c.putClientProperty(TopComponent.class, this);
            this.add(c, "Center");
            this.lookup = c.getLookup();
            this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSN_Diff_Top_Component"));
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DiffTopComponent.class, (String)"ACSD_Diff_Top_Component"));
        }

        public Lookup getLookup() {
            return new ProxyLookup(new Lookup[]{super.getLookup(), this.lookup});
        }

        public boolean canClose() {
            return ((MultiDiffPanel)this.getComponent(0)).canClose();
        }

        public UndoRedo getUndoRedo() {
            MultiDiffPanel mainPanel = (MultiDiffPanel)this.getComponent(0);
            return mainPanel.getUndoRedo();
        }

        public int getPersistenceType() {
            return 2;
        }

        protected void componentClosed() {
            ((MultiDiffPanel)this.getComponent(0)).componentClosed();
            super.componentClosed();
        }

        protected String preferredID() {
            return "DiffExecutorTopComponent";
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        protected void componentActivated() {
            super.componentActivated();
            MultiDiffPanel mainPanel = (MultiDiffPanel)this.getComponent(0);
            mainPanel.requestActive();
        }

        @Override
        public Collection<Setup> getSetups() {
            DiffSetupSource mainPanel = (DiffSetupSource)((Object)this.getComponent(0));
            return mainPanel.getSetups();
        }

        @Override
        public String getSetupDisplayName() {
            DiffSetupSource mainPanel = (DiffSetupSource)((Object)this.getComponent(0));
            return mainPanel.getSetupDisplayName();
        }

        public void setGroup(ExecutorGroup group) {
            MultiDiffPanel mainPanel = (MultiDiffPanel)this.getComponent(0);
            mainPanel.setGroup(group);
        }
    }
}

