/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.db.h2;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.impl.SQLDataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Exceptions;

public final class H2DataStorage
extends SQLDataStorage {
    private static final String SQL_QUERY_DELIMETER = ";";
    private static final Logger logger = DLightLogger.getLogger(H2DataStorage.class);
    private static boolean driverLoaded = false;
    private static final AtomicInteger dbIndex = new AtomicInteger();
    private final Collection<DataStorageType> supportedStorageTypes = new ArrayList<DataStorageType>();
    private static final String storagesDir;
    private static final String tmpDir;
    private static final String url;
    private static String persistentURL;
    final String dbURL;
    private final List<DataTableMetadata> tableMetadatas;
    boolean isPersistent = false;

    private void initStorageTypes() {
        this.supportedStorageTypes.add(DataStorageTypeFactory.getInstance().getDataStorageType("db:sql:h2"));
        this.supportedStorageTypes.addAll(super.getStorageTypes());
    }

    H2DataStorage(boolean isPersistent, String storageUniqueKey) throws SQLException {
        this(isPersistent ? persistentURL + "/dlight" + storageUniqueKey : url + dbIndex.incrementAndGet() + "/dlight");
        this.isPersistent = isPersistent;
    }

    H2DataStorage() throws SQLException {
        this(false, null);
    }

    H2DataStorage(String url) throws SQLException {
        super(url);
        this.dbURL = url;
        this.tableMetadatas = new ArrayList<DataTableMetadata>();
        this.initStorageTypes();
    }

    public boolean shutdown() {
        if (this.isPersistent) {
            return true;
        }
        boolean result = super.shutdown();
        String folderToDelete = this.dbURL.substring(this.dbURL.lastIndexOf(":") + 1, this.dbURL.lastIndexOf("/") + 1);
        result = result && Util.deleteLocalDirectory((File)new File(folderToDelete));
        return result;
    }

    public String toString() {
        return "dburl=" + this.dbURL;
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        for (DataTableMetadata tdmd : tableMetadatas) {
            if (tdmd == null) continue;
            this.createTable(tdmd);
            this.tableMetadatas.add(tdmd);
        }
    }

    public Collection<DataStorageType> getStorageTypes() {
        return this.supportedStorageTypes;
    }

    protected void connect(String dburl) throws SQLException {
        this.connection = DriverManager.getConnection(dburl, "admin", "");
    }

    protected String getSQLQueriesDelimeter() {
        return SQL_QUERY_DELIMETER;
    }

    public boolean hasData(DataTableMetadata data) {
        return data.isProvidedBy(this.tableMetadatas);
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void loadSchema() {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.TABLES", null, "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE LIKE 'TABLE'");
            if (rs == null) {
                return;
            }
            while (rs.next()) {
                String tableName = rs.getString(1);
                this.loadTable(tableName);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadTable(String tableName) {
        try {
            ResultSet rs = this.select("INFORMATION_SCHEMA.COLUMNS", null, "SELECT COLUMN_NAME, TYPE_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME LIKE '" + tableName + "'");
            ArrayList<DataTableMetadata.Column> columns = new ArrayList<DataTableMetadata.Column>();
            while (rs.next()) {
                DataTableMetadata.Column c = new DataTableMetadata.Column(rs.getString("COLUMN_NAME"), this.getClassByString(rs.getString("TYPE_NAME")));
                columns.add(c);
            }
            DataTableMetadata result = new DataTableMetadata(tableName, columns, null);
            super.loadTable(result);
            this.tableMetadatas.add(result);
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private Class<?> getClassByString(String type) {
        Set clazzes = classToType.keySet();
        for (Class clazz : clazzes) {
            if (!((String)classToType.get(clazz)).equalsIgnoreCase(type)) continue;
            return clazz;
        }
        return String.class;
    }

    static {
        try {
            Class<?> driver = Class.forName("org.h2.Driver");
            logger.log(Level.FINE, "Driver for H2DB ({0}) Loaded ", driver.getName());
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        String tempDir = null;
        try {
            HostInfo hi = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
            tempDir = hi.getTempDir();
            if (hi.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                tempDir = WindowsSupport.getInstance().convertToWindowsPath(tempDir);
            }
        }
        catch (IOException ex) {
        }
        catch (CancellationException ex) {
            // empty catch block
        }
        if (tempDir == null || tempDir.trim().equals("")) {
            tempDir = System.getProperty("java.io.tmpdir");
        }
        storagesDir = System.getProperty("dlight.storages.folder") == null ? tempDir : System.getProperty("dlight.storages.folder");
        url = "jdbc:h2:" + storagesDir + "/h2_db_dlight";
        persistentURL = System.getProperty("dlight.storages.host") != null ? "jdbc:h2:tcp://" + System.getProperty("dlight.storages.host") + storagesDir : url;
        CommonTasksSupport.mkDir((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)storagesDir, (Writer)new StringWriter());
        tmpDir = tempDir;
        File tmpDirFile = new File(storagesDir);
        if (tmpDirFile.exists()) {
            final File[] files = tmpDirFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return dir.isDirectory() && name.startsWith("h2_db_dlight");
                }
            });
            int generalNameLength = "h2_db_dlight".length();
            int newValue = 0;
            for (int i = 0; i < files.length; ++i) {
                String suffix = files[i].getName().substring(generalNameLength);
                try {
                    newValue = Math.max(newValue, Integer.valueOf(suffix));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            dbIndex.getAndSet(newValue);
            if (System.getProperty("dlight.storages.folder") == null) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (File file : files) {
                            Util.deleteLocalDirectory((File)file);
                        }
                    }
                }, (String)"H2DataStorage removing old data bases");
            }
        }
    }
}

