/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.CommandBuffer;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxyEngine;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.openide.util.Utilities;

public class GdbProxy {
    private static final boolean GDBINIT = Boolean.getBoolean("gdb.init.enable");
    private final GdbDebugger debugger;
    private final GdbProxyEngine engine;
    private final GdbLogger gdbLogger;
    private final Map<Integer, CommandBuffer> map = Collections.synchronizedMap(new HashMap());
    public static final int MEMORY_READ_WIDTH = 16;

    public GdbProxy(GdbDebugger debugger, String debuggerCommand, MacroMap debuggerEnvironment, String workingDirectory, String tty, String cspath) throws IOException {
        this.debugger = debugger;
        ArrayList<String> dc = new ArrayList<String>();
        dc.add(debuggerCommand);
        if (!GDBINIT) {
            dc.add("-nx");
        }
        dc.add("--nw");
        dc.add("--silent");
        dc.add("--interpreter=mi");
        this.gdbLogger = new GdbLogger(debugger, this);
        this.engine = new GdbProxyEngine(debugger, this, dc, debuggerEnvironment, workingDirectory, tty, cspath);
    }

    public GdbProxyEngine getProxyEngine() {
        return this.engine;
    }

    public GdbLogger getLogger() {
        return this.gdbLogger;
    }

    public CommandBuffer getCommandBuffer(Integer id) {
        return this.map.get(id);
    }

    void removeCB(int id) {
        this.map.remove(id);
    }

    void putCB(int id, CommandBuffer cb) {
        this.map.put(id, cb);
    }

    public void file_exec_and_symbols(String programName) {
        this.engine.sendCommand("-file-exec-and-symbols \"" + programName + '\"');
    }

    public void addSymbolFile(String path, String addr) {
        this.engine.sendCommand("add-symbol-file \"" + path + "\" " + addr);
    }

    public CommandBuffer core(String core) {
        return this.engine.sendCommandEx("core " + core);
    }

    public CommandBuffer attach(int pid) {
        return this.engine.sendCommandEx("attach " + pid);
    }

    public CommandBuffer attachRemote(String target) {
        return this.engine.sendCommandEx("target remote " + target);
    }

    public void target_detach() {
        this.engine.sendCommand("detach");
    }

    public void file_symbol_file(String path) {
        this.engine.sendCommand("-file-symbol-file \"" + path + '\"');
    }

    public CommandBuffer gdb_version() {
        return this.engine.sendCommandEx("-gdb-version");
    }

    public void gdb_show(String arg) {
        this.engine.sendCommand("-gdb-show " + arg);
    }

    public void environment_cd(String dir) {
        this.engine.sendCommand(this.debugger.getVersionPeculiarity().environmentCdCommand() + " \"" + dir + '\"');
    }

    public void environment_directory(String dir) {
        this.environment_directory(Collections.singletonList(dir));
    }

    public void environment_directory(List<String> dirs) {
        assert (!dirs.isEmpty());
        StringBuilder cmd = new StringBuilder();
        cmd.append(this.debugger.getVersionPeculiarity().environmentDirectoryCommand());
        for (String dir : dirs) {
            cmd.append(" \"");
            cmd.append(dir);
            cmd.append("\"");
        }
        this.engine.sendCommand(cmd.toString());
    }

    public CommandBuffer info_threads() {
        return this.engine.sendCommandEx("info threads");
    }

    public CommandBuffer info_files() {
        return this.engine.sendCommandEx("info files");
    }

    public void thread_select(String id) {
        this.engine.sendCommand("-thread-select " + id);
    }

    public void info_proc() {
        this.engine.sendCommand("info proc");
    }

    public CommandBuffer info_share(boolean waitForCompletion) {
        return this.engine.sendCommandEx("info share", waitForCompletion);
    }

    public CommandBuffer data_evaluate_expressionEx(String string) {
        return this.engine.sendCommandEx("-data-evaluate-expression " + string);
    }

    public void data_list_register_names(String regIds) {
        this.engine.sendCommand("-data-list-register-names " + regIds);
    }

    public void data_list_register_values(String regIds) {
        this.engine.sendCommand("-data-list-register-values x " + regIds);
    }

    public void data_list_changed_registers() {
        this.engine.sendCommand("-data-list-changed-registers");
    }

    public void data_disassemble(String filename, int line, boolean withSource) {
        int src = withSource ? 1 : 0;
        this.engine.sendCommand("-data-disassemble -f \"" + filename + "\" -l " + line + " -- " + src);
    }

    public void data_disassemble(int size, boolean withSource) {
        int src = withSource ? 1 : 0;
        this.engine.sendCommand("-data-disassemble -s $pc -e \"$pc+" + size + "\" -- " + src);
    }

    public CommandBuffer data_read_memory(String addr, int lines) {
        return this.engine.sendCommandEx("-data-read-memory " + addr + " x 1 " + lines + " " + 16 + " .");
    }

    public CommandBuffer print(String expression) {
        return this.engine.sendCommandEx("print " + expression);
    }

    public CommandBuffer file_list_exec_source_file() {
        return this.engine.sendCommandEx("-file-list-exec-source-file");
    }

    public CommandBuffer exec_run(String programParameters) {
        return this.engine.sendCommandEx("-exec-run " + programParameters);
    }

    public void exec_run() {
        this.exec_run("");
    }

    public void exec_step() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.STEP);
        this.engine.sendCommand("-exec-step");
    }

    public void exec_next() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.NEXT);
        this.engine.sendCommand("-exec-next");
    }

    public void exec_step_instruction() {
        this.engine.sendCommand("-exec-step-instruction");
    }

    public void exec_next_instruction() {
        this.engine.sendCommand("-exec-next-instruction");
    }

    public void exec_finish() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.FINISH);
        this.engine.sendCommand("-exec-finish");
    }

    public void exec_continue() {
        this.debugger.setLastGo(GdbDebugger.LastGoState.CONTINUE);
        this.engine.sendCommand("-exec-continue");
    }

    public void exec_abort() {
        this.engine.sendCommand(this.debugger.getVersionPeculiarity().execAbortCommand());
    }

    public MICommand break_insertCMD(int flags, boolean temporary, String name, String threadID, boolean pending) {
        StringBuilder cmd = new StringBuilder();
        cmd.append("-break-insert ");
        if (temporary) {
            cmd.append("-t ");
        }
        if (pending) {
            cmd.append(this.debugger.getVersionPeculiarity().breakPendingFlag());
        }
        if (Utilities.isWindows() && name.indexOf(47) == 0 && name.indexOf(58) == 2) {
            name = name.substring(1);
        } else if (this.debugger.getPlatform() == 4) {
            cmd.append("-l 1 ");
        }
        if (flags == 1) {
            cmd.append("-p " + threadID + " ");
        }
        cmd.append('\"');
        cmd.append(name);
        cmd.append('\"');
        return this.engine.createMICommand(cmd.toString());
    }

    public void break_insert(String name) {
        this.break_insertCMD(0, false, name, null, true).send();
    }

    public void break_insert_temporary(String name) {
        this.break_insertCMD(0, true, name, null, true).send();
    }

    public CommandBuffer break_insert_temporaryEx(String name, boolean pending) {
        return this.engine.sendCommandEx(this.break_insertCMD(0, true, name, null, pending).getText());
    }

    public MICommand break_deleteCMD(Object number) {
        return this.engine.createMICommand("-break-delete " + number);
    }

    public MICommand break_enableCMD(Integer ... ids) {
        StringBuilder cmd = new StringBuilder("-break-enable");
        Integer[] arr$ = ids;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int id = arr$[i$];
            cmd.append(' ');
            cmd.append(id);
        }
        return this.engine.createMICommand(cmd.toString());
    }

    public MICommand break_disableCMD(Integer ... ids) {
        StringBuilder cmd = new StringBuilder("-break-disable");
        Integer[] arr$ = ids;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int id = arr$[i$];
            cmd.append(' ');
            cmd.append(id);
        }
        return this.engine.createMICommand(cmd.toString());
    }

    public MICommand break_conditionCMD(int number, String condition) {
        return this.engine.createMICommand("-break-condition " + Integer.toString(number) + " " + condition);
    }

    public MICommand break_afterCMD(int number, int count) {
        return this.engine.createMICommand("-break-after " + Integer.toString(number) + " " + Integer.toString(count));
    }

    public void stack_list_locals() {
        this.stack_list_locals("");
    }

    public void stack_list_locals(String printValues) {
        this.engine.sendCommand("-stack-list-locals " + printValues);
    }

    public void stack_list_arguments(int showValues) {
        this.engine.sendCommand("-stack-list-arguments " + showValues);
    }

    public void stack_select_frame(int frameNumber) {
        this.engine.sendCommand("-stack-select-frame " + frameNumber);
    }

    public void up_silently(int number) {
        this.engine.sendCommand("up-silently " + number);
    }

    public void stack_info_frame() {
        this.engine.sendCommand("-stack-info-frame ");
    }

    public void stack_list_frames() {
        this.engine.sendCommand("-stack-list-frames");
    }

    public CommandBuffer stack_list_framesEx() {
        return this.engine.sendCommandEx("-stack-list-frames");
    }

    public void gdb_set(String command, Object value) {
        StringBuilder sb = new StringBuilder();
        sb.append("-gdb-set ");
        sb.append(command);
        sb.append(' ');
        sb.append(value);
        this.engine.sendCommand(sb.toString());
    }

    public void set_new_console() {
        this.engine.sendCommand("set new-console");
    }

    public void set_unwindonsignal(String on_off) {
        this.engine.sendCommand("set unwindonsignal " + on_off);
    }

    public CommandBuffer symbol_type(String symbol) {
        return this.engine.sendCommandEx("ptype " + symbol);
    }

    public CommandBuffer whatis(String symbol) {
        return this.engine.sendCommandEx("whatis " + symbol);
    }

    public void handle(String signal, HandleAction action) {
        this.engine.sendCommand("handle " + signal + " " + (Object)((Object)action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gdb_exit() {
        this.engine.sendCommand("-gdb-exit ");
        this.engine.stopSending();
        Map<Integer, CommandBuffer> map = this.map;
        synchronized (map) {
            for (CommandBuffer cb : this.map.values()) {
                cb.error("gdb finished");
            }
        }
    }

    public static enum HandleAction {
        nostop,
        stop,
        print,
        noprint,
        pass,
        nopass;

    }
}

