/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.attach;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.debugger.gdb.actions.AttachTableColumn;
import org.netbeans.modules.cnd.debugger.gdb.attach.ProcessListReader;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class ProcessList {
    private PTYPE ptype = PTYPE.UNINITIALIZED;
    private String executable;
    private final List<String> argsSimple = new ArrayList<String>();
    private final ExecutionEnvironment exEnv;
    private boolean isSolaris = false;
    private final RequestProcessor RP = new RequestProcessor("Process list", 1);
    private RequestProcessor.Task task = null;
    private static final boolean DISABLE_PARGS = Boolean.getBoolean("gdb.disable.pargs");

    protected ProcessList(ExecutionEnvironment exEnv) {
        this.exEnv = exEnv;
    }

    private void init() throws IllegalStateException {
        String exec = "";
        try {
            HostInfo hostInfo;
            if (!ConnectionManager.getInstance().isConnectedTo(this.exEnv)) {
                ConnectionManager.getInstance().connectTo(this.exEnv);
            }
            if (!(hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.exEnv)).getOSFamily().isUnix()) {
                if (this.exEnv.isRemote()) {
                    throw new IllegalStateException("Remote windows machines are not supported yet");
                }
                File file = new File(CompilerSetUtils.getCygwinBase() + "/bin", "ps.exe");
                if (!file.exists()) {
                    file = new File(CompilerSetUtils.getCommandFolder(null), "ps.exe");
                }
                if (file.exists()) {
                    exec = file.getAbsolutePath();
                    this.ptype = PTYPE.WINDOWS;
                } else {
                    this.ptype = PTYPE.NONE;
                }
            } else {
                if (HostInfoUtils.fileExists((ExecutionEnvironment)this.exEnv, (String)"/bin/ps")) {
                    exec = "/bin/ps";
                } else if (HostInfoUtils.fileExists((ExecutionEnvironment)this.exEnv, (String)"/usr/bin/ps")) {
                    exec = "/usr/bin/ps";
                } else {
                    this.ptype = PTYPE.NONE;
                }
                if (exec.length() > 0) {
                    String user = this.exEnv.getUser();
                    if (user != null && user.length() > 0) {
                        this.argsSimple.add("-u");
                        this.argsSimple.add(user);
                    } else {
                        this.argsSimple.add("-a");
                    }
                    this.argsSimple.add("-o");
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.MACOSX) {
                        this.argsSimple.add("user,pid,ppid,stime,time,command");
                    } else {
                        this.argsSimple.add("user,pid,ppid,stime,time,args");
                    }
                    this.ptype = PTYPE.STD;
                }
                this.isSolaris = hostInfo.getOSFamily() == HostInfo.OSFamily.SUNOS;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            this.ptype = PTYPE.NONE;
        }
        catch (CancellationException caex) {
            this.ptype = PTYPE.NONE;
        }
        catch (InterruptedException ex) {
            this.ptype = PTYPE.NONE;
        }
        this.executable = exec;
    }

    private synchronized void request(final Pattern filter, final ProcessListReader plr, final boolean full) {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        if (this.ptype != PTYPE.NONE) {
            this.task = this.RP.post(new Runnable(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void run() {
                    try {
                        ArrayList<Vector<String>> res;
                        if (ProcessList.this.ptype == PTYPE.UNINITIALIZED) {
                            ProcessList.this.init();
                        }
                        if (ProcessList.this.ptype == PTYPE.NONE) {
                            plr.processListCallback(Collections.<Vector<String>>emptyList());
                            return;
                        }
                        ArrayList<String> args = new ArrayList<String>(ProcessList.this.argsSimple);
                        if (full) {
                            if (ProcessList.this.ptype == PTYPE.WINDOWS) {
                                args.add("-W");
                            } else if (ProcessList.this.ptype == PTYPE.STD) {
                                args.add("-A");
                            }
                        }
                        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ProcessList.this.exEnv);
                        npb.setExecutable(ProcessList.this.executable);
                        npb.setArguments(args.toArray(new String[args.size()]));
                        npb.redirectError();
                        List psOutput = ProcessUtils.readProcessOutput((Process)npb.call());
                        ArrayList<Vector<String>> proclist = new ArrayList<Vector<String>>();
                        boolean header = true;
                        for (String line : psOutput) {
                            if (header) {
                                header = false;
                                continue;
                            }
                            proclist.add(ProcessList.this.parseLine(line));
                        }
                        if (ProcessList.this.isSolaris && !DISABLE_PARGS && !proclist.isEmpty()) {
                            NativeProcessBuilder pargsBuilder = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)ProcessList.this.exEnv);
                            pargsBuilder.setExecutable("/usr/bin/pargs").redirectError();
                            String[] pargs_args = new String[proclist.size() + 1];
                            pargs_args[0] = "-Fl";
                            boolean bl = true;
                            for (Vector vector : proclist) {
                                pargs_args[++var8_10] = (String)vector.get(1);
                            }
                            pargsBuilder.setArguments(pargs_args);
                            List pargsOutput = ProcessUtils.readProcessOutput((Process)pargsBuilder.call());
                            boolean bl2 = false;
                            for (String procArgs : pargsOutput) {
                                void var8_12;
                                if (procArgs.isEmpty() || procArgs.startsWith("pargs: Warning")) continue;
                                if (!procArgs.startsWith("pargs:")) {
                                    ((Vector)proclist.get((int)var8_12)).set(5, procArgs);
                                }
                                ++var8_12;
                            }
                        }
                        if (filter == null) {
                            res = proclist;
                        } else {
                            res = new ArrayList();
                            block5: for (Vector vector : proclist) {
                                for (String string : vector) {
                                    if (!filter.matcher(string).find()) continue;
                                    res.add(vector);
                                    continue block5;
                                }
                            }
                        }
                        plr.processListCallback(res);
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        } else {
            plr.processListCallback(Collections.<Vector<String>>emptyList());
        }
    }

    private Vector<String> parseLine(String line) {
        Vector<String> row = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (this.isWindowsPsFound()) {
            while (tokenizer.hasMoreTokens()) {
                row.add(tokenizer.nextToken());
            }
            return ProcessList.reorderWindowsProcLine(row);
        }
        if (this.isStd()) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (++i <= 5) {
                    row.add(token);
                    continue;
                }
                sb.append(token);
                sb.append(' ');
            }
            if (sb.length() > 0) {
                row.add(sb.toString());
            }
            return row;
        }
        return row;
    }

    private static Vector<String> reorderWindowsProcLine(Vector<String> oldrow) {
        StringBuilder tmp = new StringBuilder();
        Vector<String> nurow = new Vector<String>(oldrow.size() - 2);
        String status = oldrow.get(0);
        if (status.length() == 1 && (status.equals("I") || status.equals("C") || status.equals("O"))) {
            int i;
            nurow.add(0, oldrow.get(6));
            nurow.add(1, oldrow.get(4));
            nurow.add(2, oldrow.get(1));
            nurow.add(3, oldrow.get(2));
            nurow.add(4, oldrow.get(7));
            String stime = oldrow.get(7);
            if (Character.isDigit(stime.charAt(0))) {
                i = 8;
            } else {
                stime = stime + ' ' + oldrow.get(8);
                i = 9;
            }
            nurow.add(4, stime);
            while (i < oldrow.size()) {
                tmp.append(oldrow.get(i++));
            }
        } else {
            int i;
            nurow.add(0, oldrow.get(5));
            nurow.add(1, oldrow.get(3));
            nurow.add(2, oldrow.get(0));
            nurow.add(3, oldrow.get(1));
            String stime = oldrow.get(6);
            if (Character.isDigit(stime.charAt(0))) {
                i = 7;
            } else {
                stime = stime + ' ' + oldrow.get(7);
                i = 8;
            }
            nurow.add(4, stime);
            while (i < oldrow.size()) {
                tmp.append(oldrow.get(i++));
            }
        }
        nurow.add(5, tmp.toString());
        return nurow;
    }

    void requestSimple(Pattern filter, ProcessListReader plr) {
        this.request(filter, plr, false);
    }

    void requestFull(Pattern filter, ProcessListReader plr) {
        this.request(filter, plr, true);
    }

    private boolean isStd() {
        return this.ptype == PTYPE.STD;
    }

    private boolean isWindowsPsFound() {
        return this.ptype == PTYPE.WINDOWS;
    }

    protected List<AttachTableColumn> getColumnHeaders() {
        ArrayList<AttachTableColumn> headers = new ArrayList<AttachTableColumn>();
        if (this.ptype == PTYPE.STD) {
            headers.add(new AttachTableColumn("user", NbBundle.getMessage(ProcessList.class, (String)"HDR_USER")));
            headers.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            headers.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            headers.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            headers.add(new AttachTableColumn("time", NbBundle.getMessage(ProcessList.class, (String)"HDR_TIME")));
            headers.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        } else if (this.ptype == PTYPE.WINDOWS) {
            headers.add(new AttachTableColumn("uid", NbBundle.getMessage(ProcessList.class, (String)"HDR_UID")));
            headers.add(new AttachTableColumn("winpid", NbBundle.getMessage(ProcessList.class, (String)"HDR_WINPID")));
            headers.add(new AttachTableColumn("pid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PID")));
            headers.add(new AttachTableColumn("ppid", NbBundle.getMessage(ProcessList.class, (String)"HDR_PPID")));
            headers.add(new AttachTableColumn("stime", NbBundle.getMessage(ProcessList.class, (String)"HDR_STIME")));
            headers.add(new AttachTableColumn("args", NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS")));
        }
        return headers;
    }

    protected String getArgsHeader() {
        return NbBundle.getMessage(ProcessList.class, (String)"HDR_ARGS");
    }

    private static enum PTYPE {
        UNINITIALIZED,
        NONE,
        STD,
        WINDOWS;

    }
}

