/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.kenai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiNotification;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.netbeans.modules.versioning.util.VCSKenaiAccessor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class VCSKenaiAccessorImpl
extends VCSKenaiAccessor
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(VCSKenaiAccessorImpl.class.getName());
    private static final String KENAI_WEB_SOURCES_REVISION_PATH = "{0}/sources/{1}/revision/{2}";
    private static final String PROVIDED_EXTENSIONS_REMOTE_LOCATION = "ProvidedExtensions.RemoteLocation";
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Set<KenaiProjectListener> registeredKenaiListenres = new HashSet<KenaiProjectListener>();

    public boolean isKenai(String url) {
        return KenaiProject.getNameForRepository((String)url) != null;
    }

    public PasswordAuthentication getPasswordAuthentication(String url) {
        return this.getPasswordAuthentication(url, true);
    }

    public PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        PasswordAuthentication a;
        Kenai kenai = this.getKenai(url);
        PasswordAuthentication passwordAuthentication = a = kenai != null ? kenai.getPasswordAuthentication() : null;
        if (a != null) {
            return a;
        }
        if (!forceLogin) {
            return null;
        }
        if (!this.showLogin()) {
            return null;
        }
        return kenai.getPasswordAuthentication();
    }

    public boolean showLogin() {
        return UIUtils.showLogin();
    }

    public boolean isLogged(String url) {
        try {
            KenaiProject kp = KenaiProject.forRepository((String)url);
            return kp != null ? kp.getKenai().getPasswordAuthentication() != null : false;
        }
        catch (KenaiException ex) {
            LOG.log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public VCSKenaiAccessor.KenaiUser forName(String user) {
        return new KenaiUserImpl(new KenaiUserUI(user));
    }

    public VCSKenaiAccessor.KenaiUser forName(String user, String url) {
        String fqUserName;
        assert (url != null);
        if (this.isKenai(url)) {
            Kenai kenai = this.getKenai(url);
            if (kenai == null) {
                return null;
            }
            fqUserName = user + "@" + kenai.getUrl().getHost();
        } else {
            fqUserName = user;
        }
        return new KenaiUserImpl(new KenaiUserUI(fqUserName));
    }

    public void addVCSNoficationListener(PropertyChangeListener l) {
        PropertyChangeListener[] ls = this.support.getPropertyChangeListeners("kenai.vcs.notification");
        if (ls == null || ls.length == 0) {
            KenaiManager.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
            for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
                if (!VCSKenaiAccessorImpl.isLoggedIn(kenai)) continue;
                this.attachToDashboard();
            }
        }
        this.support.addPropertyChangeListener("kenai.vcs.notification", l);
    }

    public void removeVCSNoficationListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener("kenai.vcs.notification", l);
        PropertyChangeListener[] ls = this.support.getPropertyChangeListeners("kenai.vcs.notification");
        if (ls == null || ls.length == 0) {
            KenaiManager.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
            for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
                if (VCSKenaiAccessorImpl.isLoggedIn(kenai)) continue;
                this.detachFromDashboard();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("openedProjects")) {
            this.registerVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
        } else if (evt.getPropertyName().equals("login")) {
            Kenai kenai = (Kenai)evt.getSource();
            if (VCSKenaiAccessorImpl.isLoggedIn(kenai)) {
                this.attachToDashboard();
            } else {
                this.detachFromDashboard();
            }
        }
    }

    public boolean isUserOnline(String user) {
        return KenaiUser.isOnline((String)user);
    }

    public String getRevisionUrl(String sourcesUrl, String revision) {
        if (revision == null || sourcesUrl == null) {
            throw new NullPointerException("Null parameter");
        }
        String revisionUrl = null;
        String projectUrl = VCSKenaiAccessorImpl.getProjectUrl(sourcesUrl);
        String repositoryName = this.getRepositoryName(sourcesUrl);
        if (projectUrl != null && repositoryName != null) {
            revisionUrl = KENAI_WEB_SOURCES_REVISION_PATH;
            revisionUrl = MessageFormat.format(revisionUrl, projectUrl, repositoryName, revision);
        }
        return revisionUrl;
    }

    public void logVcsUsage(String vcs, String repositoryUrl) {
        if (repositoryUrl != null && this.isKenai(repositoryUrl)) {
            UIUtils.logKenaiUsage((Object[])new Object[]{"SCM", vcs});
        }
    }

    private void attachToDashboard() {
        Dashboard.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
        this.registerVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
    }

    private void detachFromDashboard() {
        Dashboard.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        this.unregisterVCSNotificationListener(Dashboard.getDefault().getOpenProjects());
    }

    private static boolean isLoggedIn(Kenai kenai) {
        return kenai.getPasswordAuthentication() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerVCSNotificationListener(ProjectHandle[] phs) {
        Set<KenaiProjectListener> set = this.registeredKenaiListenres;
        synchronized (set) {
            this.unregisterVCSNotificationListener(phs);
            for (ProjectHandle projectHandle : phs) {
                KenaiProject kp = projectHandle.getKenaiProject();
                KenaiProjectListener l = new KenaiProjectListener(kp);
                this.registeredKenaiListenres.add(l);
                kp.addPropertyChangeListener((PropertyChangeListener)l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterVCSNotificationListener(ProjectHandle[] phs) {
        Set<KenaiProjectListener> set = this.registeredKenaiListenres;
        synchronized (set) {
            for (KenaiProjectListener l : this.registeredKenaiListenres) {
                l.kp.removePropertyChangeListener((PropertyChangeListener)l);
            }
        }
    }

    private static String getProjectUrl(String sourcesUrl) {
        try {
            KenaiProject kp = KenaiProject.forRepository((String)sourcesUrl);
            return kp != null ? kp.getWebLocation().toString() : null;
        }
        catch (KenaiException ex) {
            LOG.log(Level.WARNING, null, ex);
            return null;
        }
    }

    private String getRepositoryName(String sourcesUrl) {
        String repositoryNameCandidate;
        String repositoryName = null;
        int pos = sourcesUrl.lastIndexOf(126) + 1;
        if (pos > 0 && sourcesUrl.length() > pos && (repositoryNameCandidate = sourcesUrl.substring(pos)).indexOf(47) == -1) {
            repositoryName = repositoryNameCandidate;
        }
        return repositoryName;
    }

    private Kenai getKenai(String repositoryUr) {
        KenaiProject kp = null;
        try {
            kp = KenaiProject.forRepository((String)repositoryUr);
        }
        catch (KenaiException ex) {
            LOG.log(Level.FINE, null, ex);
        }
        if (kp == null) {
            return null;
        }
        return kp.getKenai();
    }

    private void handleKenaiProjectEvent(PropertyChangeEvent evt, String projectName) {
        if (!evt.getPropertyName().equals("project_notification")) {
            return;
        }
        Object newValue = evt.getNewValue();
        if (newValue instanceof KenaiNotification) {
            Project[] projects;
            KenaiNotification kn = (KenaiNotification)newValue;
            if (kn.getType() != KenaiService.Type.SOURCE) {
                return;
            }
            for (Project project : projects = OpenProjects.getDefault().getOpenProjects()) {
                KenaiProject kp;
                FileObject projectDir = project.getProjectDirectory();
                String url = (String)projectDir.getAttribute(PROVIDED_EXTENSIONS_REMOTE_LOCATION);
                if (url == null || !url.equals(kn.getUri().toString())) continue;
                try {
                    kp = KenaiProject.forRepository((String)url);
                }
                catch (KenaiException ex) {
                    LOG.log(Level.WARNING, null, ex);
                    return;
                }
                String name = kp.getName();
                if (!name.equals(projectName)) continue;
                this.support.firePropertyChange("kenai.vcs.notification", null, (Object)new VCSKenaiNotificationImpl(kn, kp, FileUtil.toFile((FileObject)projectDir)));
            }
        }
    }

    private class KenaiProjectListener
    implements PropertyChangeListener {
        private final KenaiProject kp;

        public KenaiProjectListener(KenaiProject kp) {
            this.kp = kp;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            VCSKenaiAccessorImpl.this.handleKenaiProjectEvent(evt, this.kp.getName());
        }
    }

    private class VCSKenaiModificationImpl
    extends VCSKenaiAccessor.VCSKenaiModification {
        private final KenaiNotification.Modification m;

        public VCSKenaiModificationImpl(KenaiNotification.Modification m) {
            this.m = m;
        }

        public VCSKenaiAccessor.VCSKenaiModification.Type getType() {
            switch (this.m.getType()) {
                case NEW: {
                    return VCSKenaiAccessor.VCSKenaiModification.Type.NEW;
                }
                case CHANGE: {
                    return VCSKenaiAccessor.VCSKenaiModification.Type.CHANGE;
                }
                case DELETE: {
                    return VCSKenaiAccessor.VCSKenaiModification.Type.DELETE;
                }
            }
            throw new IllegalStateException("unknown modification type" + this.m.getType());
        }

        public String getResource() {
            return this.m.getResource();
        }

        public String getId() {
            return this.m.getId();
        }
    }

    private class VCSKenaiNotificationImpl
    extends VCSKenaiAccessor.VCSKenaiNotification {
        private final KenaiNotification kn;
        private final File projectDir;
        private final KenaiProject kp;

        public VCSKenaiNotificationImpl(KenaiNotification kn, KenaiProject kp, File projectDir) {
            assert (kp != null);
            assert (kn != null);
            assert (kn.getType() == KenaiService.Type.SOURCE);
            this.kn = kn;
            this.kp = kp;
            this.projectDir = projectDir;
        }

        public URI getUri() {
            return this.kn.getUri();
        }

        public Date getStamp() {
            return this.kn.getStamp();
        }

        public VCSKenaiAccessor.Service getService() {
            String serviceName = this.kn.getServiceName();
            if (serviceName.equals("subversion")) {
                return VCSKenaiAccessor.Service.VCS_SVN;
            }
            if (serviceName.equals("mercurial")) {
                return VCSKenaiAccessor.Service.VCS_HG;
            }
            LOG.warning("Unknown kenai scm service name " + serviceName);
            return VCSKenaiAccessor.Service.UNKNOWN;
        }

        public List<VCSKenaiAccessor.VCSKenaiModification> getModifications() {
            ArrayList<VCSKenaiModificationImpl> ret = new ArrayList<VCSKenaiModificationImpl>(this.kn.getModifications().size());
            for (KenaiNotification.Modification m : this.kn.getModifications()) {
                ret.add(new VCSKenaiModificationImpl(m));
            }
            return Collections.unmodifiableList(ret);
        }

        public String getAuthor() {
            return this.kn.getAuthor();
        }

        public File getProjectDirectory() {
            return this.projectDir;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append(this.projectDir);
            sb.append(",");
            sb.append(this.getUri());
            sb.append(",");
            sb.append(this.getService());
            sb.append(",");
            sb.append(this.getStamp());
            return sb.toString();
        }
    }

    private static class KenaiUserImpl
    extends VCSKenaiAccessor.KenaiUser {
        KenaiUserUI delegate;

        public KenaiUserImpl(KenaiUserUI delegate) {
            this.delegate = delegate;
        }

        public void startChat() {
            this.delegate.startChat();
        }

        public void startChat(String msg) {
            this.delegate.startChat(msg);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.getKenaiUser().removePropertyChangeListener(listener);
        }

        public boolean isOnline() {
            return this.delegate.getKenaiUser().isOnline();
        }

        public String getUser() {
            return this.delegate.getUserName();
        }

        public Icon getIcon() {
            return this.delegate.getIcon();
        }

        public JLabel createUserWidget() {
            return this.delegate.createUserWidget();
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.delegate.getKenaiUser().addPropertyChangeListener(listener);
        }
    }
}

