/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;

public class ArtifactGraphNode {
    public static final int UNMANAGED = 0;
    public static final int MANAGED = 1;
    public static final int OVERRIDES_MANAGED = 2;
    public static final int NO_CONFLICT = 0;
    public static final int POTENTIAL_CONFLICT = 1;
    public static final int CONFLICT = 2;
    private DependencyNode artifact;
    private DependencyNode parentAfterFix;
    double locX;
    double locY;
    double dispX;
    double dispY;
    private boolean fixed;
    private ArtifactWidget widget;
    private boolean root;
    private HashSet<DependencyNode> dupl;
    private int level;
    private int managedState = 0;

    public ArtifactGraphNode(DependencyNode art) {
        this.artifact = art;
        this.dupl = new HashSet();
    }

    DependencyNode getArtifact() {
        return this.artifact;
    }

    DependencyNode getArtifactParent() {
        if (this.parentAfterFix != null) {
            return this.parentAfterFix;
        }
        return this.getArtifact().getParent();
    }

    void setArtifactParent(DependencyNode newParent) {
        this.parentAfterFix = newParent;
    }

    void setArtifact(DependencyNode ar) {
        this.artifact = ar;
    }

    void addDuplicateOrConflict(DependencyNode nd) {
        this.dupl.add(nd);
    }

    Set<DependencyNode> getDuplicatesOrConflicts() {
        return this.dupl;
    }

    boolean represents(DependencyNode node) {
        if (this.artifact.equals((Object)node)) {
            return true;
        }
        for (DependencyNode nd : this.dupl) {
            if (!nd.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    int getConflictType() {
        int ret = 0;
        DefaultArtifactVersion includedV = new DefaultArtifactVersion(this.getArtifact().getArtifact().getVersion());
        for (DependencyNode curDepN : this.getDuplicatesOrConflicts()) {
            if (curDepN.getState() != 2) continue;
            int result = includedV.compareTo((Object)new DefaultArtifactVersion(curDepN.getArtifact().getVersion()));
            if (result < 0) {
                return 2;
            }
            if (result <= 0) continue;
            ret = 1;
        }
        return ret;
    }

    public boolean isRoot() {
        return this.level == 0;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isVisible() {
        return this.widget != null ? this.widget.isVisible() : true;
    }

    void setPrimaryLevel(int i) {
        this.level = i;
    }

    public int getPrimaryLevel() {
        return this.level;
    }

    void setWidget(ArtifactWidget wid) {
        this.widget = wid;
    }

    ArtifactWidget getWidget() {
        return this.widget;
    }

    public int getManagedState() {
        return this.managedState;
    }

    public void setManagedState(int state) {
        this.managedState = state;
    }

    static int compareVersions(String v1, String v2) {
        String[] v1Elems = v1.split("\\.");
        String[] v2Elems = v2.split("\\.");
        for (int i = 0; i < Math.min(v1Elems.length, v2Elems.length); ++i) {
            int res = v1Elems[i].compareTo(v2Elems[i]);
            if (res == 0) continue;
            return res;
        }
        return v1Elems.length - v2Elems.length;
    }
}

