/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.bridge;

import com.sun.enterprise.admin.jmx.remote.SunOneHttpJmxConnectorFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.deployapi.SunDeploymentManager;
import com.sun.enterprise.deployapi.SunTargetModuleID;
import com.sun.enterprise.deployment.client.ServerConnectionEnvironment;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.netbeans.modules.j2ee.sun.bridge.DirectoryDeployment;
import org.netbeans.modules.j2ee.sun.bridge.X509TrustManager;

public class AppServerBridge {
    public static File getDirLocation(TargetModuleID tmid) {
        File dirLocation = null;
        String modulePart = null;
        try {
            SunTargetModuleID ddd = (SunTargetModuleID)tmid;
            String earPart = null;
            String mid = ddd.getModuleID();
            int dex = mid.indexOf(35);
            if (dex > -1) {
                earPart = mid.substring(0, dex);
                modulePart = mid.substring(dex + 1);
                mid = earPart;
            }
            if (ddd.getModuleType().equals(ModuleType.WAR)) {
                if (null == earPart) {
                    ObjectName aaaa = new ObjectName("com.sun.appserv:type=web-module,name=" + mid + ",category=config");
                    dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
                } else {
                    if (!modulePart.startsWith("/")) {
                        modulePart = "/" + modulePart;
                    }
                    ObjectName aaaa = new ObjectName("com.sun.appserv:j2eeType=WebModule,name=//server" + modulePart + ",J2EEApplication=" + earPart + ",J2EEServer=server");
                    dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "docBase"));
                    modulePart = null;
                }
            } else if (mid == earPart) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=j2ee-application,name=" + mid + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (ddd.getModuleType().equals(ModuleType.EJB)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=ejb-module,name=" + mid + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (ddd.getModuleType().equals(ModuleType.EAR)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=j2ee-application,name=" + mid + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (ddd.getModuleType().equals(ModuleType.CAR)) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=appclient-module,name=" + mid + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else if (null == earPart) {
                ObjectName aaaa = new ObjectName("com.sun.appserv:type=extension-module,name=" + mid + ",category=config");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
            } else {
                if (!modulePart.startsWith("/")) {
                    modulePart = "/" + modulePart;
                }
                ObjectName aaaa = new ObjectName("com.sun.appserv:j2eeType=WebModule,name=//server" + modulePart + ",J2EEApplication=" + earPart + ",J2EEServer=server");
                dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "docBase"));
                modulePart = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        if (null != modulePart) {
            dirLocation = new File(dirLocation.getAbsolutePath(), DirectoryDeployment.transform(modulePart));
        }
        return dirLocation;
    }

    public static boolean isApp(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.EAR);
    }

    public static boolean isWar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.WAR);
    }

    public static Boolean isCar(TargetModuleID tmid) {
        ModuleType mt = ((SunTargetModuleID)tmid).getModuleType();
        return mt.equals(ModuleType.CAR);
    }

    public static String getModuleUrl(TargetModuleID module) {
        ModuleType mt = ((SunTargetModuleID)module).getModuleType();
        String suffix = null;
        String moduleID = module.getModuleID();
        int i = moduleID.indexOf(35);
        if (i > -1) {
            moduleID = moduleID.substring(i + 1);
        }
        if (ModuleType.EAR.equals(mt)) {
            suffix = ".ear";
        }
        if (ModuleType.RAR.equals(mt)) {
            suffix = ".rar";
        }
        if (ModuleType.EJB.equals(mt) || ModuleType.CAR.equals(mt)) {
            suffix = ".jar";
        }
        if (null == suffix) {
            suffix = ".war";
            File dirLocation = null;
            String modulePart = null;
            if (!moduleID.toLowerCase(Locale.ENGLISH).endsWith(suffix)) {
                try {
                    SunTargetModuleID ddd = (SunTargetModuleID)module;
                    String earPart = null;
                    String mid = ddd.getModuleID();
                    int dex = mid.indexOf(35);
                    if (dex > -1) {
                        earPart = mid.substring(0, dex);
                        modulePart = mid.substring(dex + 1);
                        mid = earPart;
                    }
                    if (!modulePart.startsWith("/")) {
                        modulePart = "/" + modulePart;
                    }
                    if (ddd.getModuleType().equals(ModuleType.WAR)) {
                        if (null == earPart) {
                            ObjectName aaaa = new ObjectName("com.sun.appserv:type=web-module,name=" + mid + ",category=config");
                            dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
                        } else {
                            ObjectName aaaa = new ObjectName("com.sun.appserv:j2eeType=WebModule,name=//server" + modulePart + ",J2EEApplication=" + earPart + ",J2EEServer=server");
                            dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "docBase"));
                            String t = dirLocation.getName();
                            moduleID = t.substring(0, t.length() - 4);
                            modulePart = null;
                        }
                    } else if (null == earPart) {
                        ObjectName aaaa = new ObjectName("com.sun.appserv:type=extension-module,name=" + mid + ",category=config");
                        dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "location"));
                    } else {
                        ObjectName aaaa = new ObjectName("com.sun.appserv:j2eeType=WebModule,name=//server" + modulePart + ",J2EEApplication=" + earPart + ",J2EEServer=server");
                        dirLocation = new File("" + ddd.getMBeanServerConnection().getAttribute(aaaa, "docBase"));
                        String t = dirLocation.getName();
                        moduleID = t.substring(0, t.length() - 4);
                        modulePart = null;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    IllegalStateException ise = new IllegalStateException(e.getMessage());
                    ise.initCause(e);
                    throw ise;
                }
            }
        }
        if (moduleID.endsWith(suffix) || moduleID.endsWith(suffix.toUpperCase(Locale.ENGLISH))) {
            return moduleID;
        }
        return moduleID + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHostPort(File domainXml, File platformDir) {
        String hostPort = null;
        BufferedInputStream inFile = null;
        try {
            inFile = new BufferedInputStream(new FileInputStream(domainXml));
            Domain domain = Domain.createGraph((InputStream)inFile);
            String domainSysID = domain.graphManager().getXmlDocument().getDoctype().getSystemId();
            if (null == domainSysID) {
                String string = null;
                return string;
            }
            int dtdsDex = domainSysID.indexOf("dtds/");
            if (-1 == dtdsDex) {
                String ioe = null;
                return ioe;
            }
            File domainDtd = new File(platformDir, "lib/" + domainSysID.substring(dtdsDex));
            if (!domainDtd.exists()) {
                String ioe = null;
                return ioe;
            }
            Config conf = domain.getConfigs().getConfigByName("server-config");
            HttpListener list = conf.getHttpService().getHttpListenerById("admin-listener");
            hostPort = "localhost:" + list.getPort();
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINER, "", ex);
        }
        catch (IOException ex) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINER, "", ex);
        }
        catch (RuntimeException re) {
            Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINER, "", re);
        }
        finally {
            if (null != inFile) {
                try {
                    ((InputStream)inFile).close();
                }
                catch (IOException ioe) {
                    Logger.getLogger("org.netbeans.modules.j2ee.sun.bridge").log(Level.FINEST, "", ioe);
                }
            }
        }
        return hostPort;
    }

    public String getNonAdminPortNumber(File domainXml) {
        String port = null;
        try {
            FileInputStream inFile = new FileInputStream(domainXml);
            Domain domain = Domain.createGraph((InputStream)inFile);
            Config conf = domain.getConfigs().getConfigByName("server-config");
            HttpListener list = conf.getHttpService().getHttpListenerById("http-listener-1");
            port = list.getPort();
            ((InputStream)inFile).close();
        }
        catch (Exception ex) {
            return null;
        }
        return port;
    }

    public static MBeanServerConnection getJMXConnector(String host, int port, String username, String password, boolean secure) throws MalformedURLException, IOException {
        MBeanServerConnection serverConn = null;
        String mode = null;
        mode = secure ? "s1ashttps" : "s1ashttp";
        JMXServiceURL serverUrl = new JMXServiceURL(mode, host, port);
        JMXConnector connector = SunOneHttpJmxConnectorFactory.connect((JMXServiceURL)serverUrl, (String)username, (String)password);
        serverConn = connector.getMBeanServerConnection();
        return serverConn;
    }

    public static void setServerConnectionEnvironment(DeploymentManager dm) {
        ServerConnectionEnvironment env = new ServerConnectionEnvironment();
        env.put((Object)"TRUST_MANAGER_KEY", (Object)new X509TrustManager());
        if (dm instanceof SunDeploymentManager) {
            ((SunDeploymentManager)dm).setServerConnectionEnvironment(env);
        }
    }
}

