/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.DayDateRange;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.WeekDateRange;
import org.eclipse.mylyn.tasks.core.IRepositoryElement;
import org.eclipse.mylyn.tasks.core.ITask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskContainer
extends AbstractTaskContainer {
    private final TaskActivityManager activityManager;
    private final String summary;
    private final DateRange range;

    public ScheduledTaskContainer(TaskActivityManager activityManager, DateRange range, String summary) {
        super(summary == null ? range.toString(false) : summary);
        this.activityManager = activityManager;
        this.range = range;
        this.summary = summary == null ? range.toString(false) : summary;
    }

    public ScheduledTaskContainer(TaskActivityManager taskActivityManager, DateRange day) {
        this(taskActivityManager, day, null);
    }

    public boolean isFuture() {
        return !this.isPresent() && this.range.getStartDate().after(Calendar.getInstance());
    }

    public boolean isPresent() {
        return this.range.getStartDate().before(Calendar.getInstance()) && this.range.getEndDate().after(Calendar.getInstance());
    }

    @Override
    public Collection<ITask> getChildren() {
        HashSet<ITask> children = new HashSet<ITask>();
        for (ITask task : this.activityManager.getScheduledTasks(this.range)) {
            if (task.isCompleted() && (!task.isCompleted() || !TaskActivityUtil.getDayOf(task.getCompletionDate()).isPresent())) continue;
            children.add(task);
        }
        if (!(this.range instanceof WeekDateRange) || !((WeekDateRange)this.range).isPresent()) {
            for (ITask task : this.activityManager.getDueTasks(this.range.getStartDate(), this.range.getEndDate())) {
                if (!this.activityManager.isOwnedByUser(task)) continue;
                children.add(task);
            }
        }
        if (this.range instanceof DayDateRange && ((DayDateRange)this.range).isPresent()) {
            for (ITask task : this.activityManager.getOverScheduledTasks()) {
                if (!(task instanceof AbstractTask) || ((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange) continue;
                children.add(task);
            }
            children.addAll(this.activityManager.getOverDueTasks());
            ITask activeTask = this.activityManager.getActiveTask();
            if (activeTask != null && !children.contains(activeTask)) {
                children.add(activeTask);
            }
        }
        if (this.range instanceof WeekDateRange && ((WeekDateRange)this.range).isThisWeek()) {
            for (ITask task : this.activityManager.getOverScheduledTasks()) {
                if (!(task instanceof AbstractTask) || !(((AbstractTask)task).getScheduledForDate() instanceof WeekDateRange)) continue;
                children.add(task);
            }
        }
        return children;
    }

    @Override
    public String getSummary() {
        if (this.summary != null) {
            return this.summary;
        }
        return this.range.toString();
    }

    @Override
    public String getHandleIdentifier() {
        return this.summary;
    }

    @Override
    public String getPriority() {
        return "";
    }

    @Override
    public String getUrl() {
        return "";
    }

    @Override
    public int compareTo(IRepositoryElement element) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            return this.range.compareTo(container.getDateRange());
        }
        return 0;
    }

    public DateRange getDateRange() {
        return this.range;
    }

    public Calendar getEnd() {
        return this.range.getEndDate();
    }

    public Calendar getStart() {
        return this.range.getStartDate();
    }

    public boolean includes(Calendar pastWeeksTaskStart) {
        return this.range.includes(pastWeeksTaskStart);
    }
}

