/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import java.util.LinkedList;
import java.util.ListIterator;
import org.netbeans.lib.terminalemulator.Coord;
import org.netbeans.lib.terminalemulator.Extent;

public class ActiveRegion {
    public Coord begin = new Coord();
    public Coord end = new Coord();
    ActiveRegion parent;
    boolean nested;
    private LinkedList<ActiveRegion> children;
    private boolean has_end;
    private int parentAttrs;
    private boolean selectable;
    private boolean feedback_enabled;
    private boolean feedback_via_parent;
    private boolean link;
    private Object user_object;

    ActiveRegion(ActiveRegion parent, Coord begin, boolean nested) {
        this.parent = parent;
        this.begin.copyFrom(begin);
        this.nested = nested;
    }

    void setParentAttrs(int attrs) {
        this.parentAttrs = attrs;
    }

    int getParentAttrs() {
        return this.parentAttrs;
    }

    public ActiveRegion parent() {
        return this.parent;
    }

    public Extent getExtent() {
        if (this.has_end) {
            return new Extent(this.begin, this.end);
        }
        return new Extent(this.begin, this.begin);
    }

    void setEnd(Coord end) {
        this.end.copyFrom(end);
        this.has_end = true;
    }

    void addChild(ActiveRegion child) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(child);
    }

    void removeChild(ActiveRegion child) {
        if (this.children == null) {
            return;
        }
        this.children.remove(child);
    }

    ActiveRegion contains(Coord coord) {
        boolean coord_past_end;
        boolean bl = coord_past_end = this.has_end && coord.compareTo(this.end) > 0;
        if (this.parent != null && (coord.compareTo(this.begin) < 0 || coord_past_end)) {
            return null;
        }
        if (this.children != null) {
            ListIterator iter = this.children.listIterator();
            while (iter.hasNext()) {
                ActiveRegion child = (ActiveRegion)iter.next();
                if (coord.compareTo(child.begin) < 0) break;
                ActiveRegion target = child.contains(coord);
                if (target == null) continue;
                return target;
            }
        }
        return this;
    }

    void relocate(int delta) {
        this.begin.row += delta;
        this.end.row += delta;
        if (this.children != null) {
            ListIterator iter = this.children.listIterator();
            while (iter.hasNext()) {
                ActiveRegion child = (ActiveRegion)iter.next();
                child.relocate(delta);
            }
        }
    }

    void cull(int origin) {
        if (this.children == null) {
            return;
        }
        int nculled = 0;
        ListIterator iter = this.children.listIterator();
        while (iter.hasNext()) {
            ActiveRegion child = (ActiveRegion)iter.next();
            if (child.begin.row >= origin) break;
            iter.remove();
            ++nculled;
        }
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setFeedbackEnabled(boolean feedback) {
        this.feedback_enabled = feedback;
    }

    public boolean isFeedbackEnabled() {
        return this.feedback_enabled;
    }

    public void setFeedbackViaParent(boolean feedback_via_parent) {
        this.feedback_via_parent = feedback_via_parent;
    }

    public boolean isFeedbackViaParent() {
        return this.feedback_via_parent;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setUserObject(Object object) {
        this.user_object = object;
    }

    public Object getUserObject() {
        return this.user_object;
    }

    public ActiveRegion firstChild() {
        if (this.children == null) {
            return null;
        }
        return this.children.getFirst();
    }

    public ActiveRegion lastChild() {
        if (this.children == null) {
            return null;
        }
        return this.children.getLast();
    }

    public ActiveRegion getPreviousSibling() {
        if (this.parent != null) {
            return this.parent.previous_sibling_of(this);
        }
        return null;
    }

    public ActiveRegion getNextSibling() {
        if (this.parent != null) {
            return this.parent.next_sibling_of(this);
        }
        return null;
    }

    private ActiveRegion previous_sibling_of(ActiveRegion child) {
        ListIterator iter = this.children.listIterator();
        ActiveRegion previousChild = null;
        while (iter.hasNext()) {
            ActiveRegion candidate = (ActiveRegion)iter.next();
            if (candidate == child) {
                return previousChild;
            }
            previousChild = candidate;
        }
        return null;
    }

    private ActiveRegion next_sibling_of(ActiveRegion child) {
        ListIterator iter = this.children.listIterator();
        while (iter.hasNext()) {
            ActiveRegion candidate = (ActiveRegion)iter.next();
            if (candidate != child) continue;
            return iter.hasNext() ? iter.next() : null;
        }
        return null;
    }
}

