/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.JSFUtils;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.wizards.ManagedBeanIterator;
import org.netbeans.modules.web.wizards.Utilities;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ManagedBeanPanelVisual
extends JPanel
implements HelpCtx.Provider,
ListDataListener,
DocumentListener {
    private final DefaultComboBoxModel scopeModel = new DefaultComboBoxModel();
    private boolean isCDIEnabled = false;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxConfigFile;
    private JComboBox jComboBoxScope;
    private JLabel jLabelConfigFile;
    private JLabel jLabelDesc;
    private JLabel jLabelName;
    private JLabel jLabelScope;
    private JScrollPane jScrollPaneDesc;
    private JTextArea jTextAreaDesc;
    private JTextField jTextFieldName;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ManagedBeanPanelVisual(Project project) {
        Object[] objectArray;
        this.initComponents();
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        if (webModule != null) {
            Profile profile;
            objectArray = JSFConfigUtilities.getConfigFiles(webModule);
            if (objectArray.length > 0) {
                profile = webModule.getDocumentBase();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < objectArray.length; ++i) {
                    if (profile.getFileObject(objectArray[i]) == null) continue;
                    arrayList.add(objectArray[i]);
                }
                objectArray = arrayList.toArray(new String[arrayList.size()]);
            }
            this.jComboBoxConfigFile.setModel(new DefaultComboBoxModel<String>(objectArray));
            if (objectArray.length == 0) {
                this.jCheckBox1.setEnabled(false);
                this.jComboBoxConfigFile.setEnabled(false);
            } else {
                profile = webModule.getJ2eeProfile();
                if (profile != Profile.JAVA_EE_6_FULL && profile != Profile.JAVA_EE_6_WEB) {
                    this.jCheckBox1.setSelected(true);
                    this.jCheckBox1.setEnabled(false);
                }
            }
        }
        this.isCDIEnabled = JSFUtils.isCDIEnabled(webModule);
        objectArray = this.isCDIEnabled ? ManagedBeanIterator.NamedScope.values() : ManagedBean.Scope.values();
        for (Profile profile : objectArray) {
            this.scopeModel.addElement(profile);
        }
        this.jTextFieldName.setText("newJSFManagedBean");
        this.jTextFieldName.getDocument().addDocumentListener(this);
    }

    private void updateScopeModel(boolean bl) {
        if (this.isCDIEnabled && bl) {
            this.scopeModel.removeAllElements();
            for (ManagedBean.Scope scope : ManagedBean.Scope.values()) {
                this.scopeModel.addElement(scope);
            }
        } else if (this.isCDIEnabled && !bl) {
            this.scopeModel.removeAllElements();
            for (ManagedBeanIterator.NamedScope namedScope : ManagedBeanIterator.NamedScope.values()) {
                this.scopeModel.addElement(namedScope);
            }
        } else {
            return;
        }
        this.jComboBoxScope.setModel(this.scopeModel);
        this.repaint();
    }

    private void initComponents() {
        this.jLabelConfigFile = new JLabel();
        this.jComboBoxConfigFile = new JComboBox();
        this.jLabelName = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelScope = new JLabel();
        this.jComboBoxScope = new JComboBox();
        this.jLabelDesc = new JLabel();
        this.jScrollPaneDesc = new JScrollPane();
        this.jTextAreaDesc = new JTextArea();
        this.jCheckBox1 = new JCheckBox();
        this.jLabelConfigFile.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_ConfigFile").charAt(0));
        this.jLabelConfigFile.setLabelFor(this.jComboBoxConfigFile);
        this.jLabelConfigFile.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_ConfigFile"));
        this.jComboBoxConfigFile.setEnabled(this.jCheckBox1.isSelected());
        this.jComboBoxConfigFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManagedBeanPanelVisual.this.jComboBoxConfigFileActionPerformed(actionEvent);
            }
        });
        this.jLabelName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Name").charAt(0));
        this.jLabelName.setLabelFor(this.jTextFieldName);
        this.jLabelName.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Name"));
        this.jLabelScope.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_Scope").charAt(0));
        this.jLabelScope.setLabelFor(this.jComboBoxScope);
        this.jLabelScope.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Scope"));
        this.jComboBoxScope.setModel(this.scopeModel);
        this.jLabelDesc.setDisplayedMnemonic(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MNE_BeanDescription").charAt(0));
        this.jLabelDesc.setLabelFor(this.jTextAreaDesc);
        this.jLabelDesc.setText(NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_BeanDescription"));
        this.jTextAreaDesc.setColumns(20);
        this.jTextAreaDesc.setRows(5);
        this.jScrollPaneDesc.setViewportView(this.jTextAreaDesc);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jTextAreaDesc.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_BeanDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBox1, (String)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"LBL_Add_data_to_conf_file"));
        this.jCheckBox1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ManagedBeanPanelVisual.this.jCheckBox1ItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelName).add((Component)this.jLabelScope).add((Component)this.jLabelDesc).add((Component)this.jLabelConfigFile)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextFieldName, -1, 302, Short.MAX_VALUE).add((Component)this.jComboBoxScope, 0, 302, Short.MAX_VALUE).add((Component)this.jScrollPaneDesc, -1, 302, Short.MAX_VALUE).add((Component)this.jComboBoxConfigFile, 0, 302, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jCheckBox1).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jCheckBox1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabelConfigFile).add((Component)this.jComboBoxConfigFile, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jTextFieldName, -2, -1, -2).add((Component)this.jLabelName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jComboBoxScope, -2, -1, -2).add((Component)this.jLabelScope)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelDesc).add((Component)this.jScrollPaneDesc, -1, 102, Short.MAX_VALUE))));
        this.jComboBoxConfigFile.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ConfigurationFile"));
        this.jComboBoxScope.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ManagedBeanScope"));
    }

    private void jComboBoxConfigFileActionPerformed(ActionEvent actionEvent) {
        this.fireChange();
    }

    private void jCheckBox1ItemStateChanged(ItemEvent itemEvent) {
        boolean bl = this.jCheckBox1.isSelected();
        this.jComboBoxConfigFile.setEnabled(bl);
        this.updateScopeModel(bl);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string = (String)this.jComboBoxConfigFile.getSelectedItem();
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        WebModule webModule = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroupArray.length == 0) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_No_Sources_found"));
            return false;
        }
        if (string == null) {
            if (!(Utilities.isJavaEE6((TemplateWizard)((TemplateWizard)wizardDescriptor)) || this.isAddBeanToConfig() || JSFUtils.isJavaEE5((TemplateWizard)wizardDescriptor) && JSFUtils.isJSF20(webModule))) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_NoConfigFile"));
                return false;
            }
            return true;
        }
        FileObject fileObject = webModule.getDocumentBase();
        FileObject fileObject2 = fileObject.getFileObject(string);
        FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObject2, true).getRootComponent();
        if (facesConfig == null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_InvalidConfigFile"));
            return false;
        }
        String string2 = this.jTextFieldName.getText();
        if (string2.trim().equals("")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(ManagedBeanPanelVisual.class, (String)"MSG_InvalidBeanName"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    void read(WizardDescriptor wizardDescriptor) {
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("ConfigFile", this.jComboBoxConfigFile.getSelectedItem());
        wizardDescriptor.putProperty("Name", (Object)this.jTextFieldName.getText());
        wizardDescriptor.putProperty("Scope", this.jComboBoxScope.getSelectedItem());
        wizardDescriptor.putProperty("Description", (Object)this.jTextAreaDesc.getText());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ManagedBeanPanelVisual.class);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public void setManagedBeanName(String string) {
        this.jTextFieldName.setText(string);
    }

    public String getManagedBeanName() {
        return this.jTextFieldName.getText();
    }

    public boolean isAddBeanToConfig() {
        return this.jCheckBox1.isSelected();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChange();
    }
}

