/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.toolchain;

import java.io.File;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.EnvUtils;

public abstract class AbstractCompiler
extends Tool {
    private String includeFilePrefix;

    protected AbstractCompiler(ExecutionEnvironment env, CompilerFlavor flavor, ToolKind kind, String name, String displayName, String path) {
        super(env, flavor, kind, name, displayName, path);
        this.includeFilePrefix = !env.isLocal() ? CndUtils.getIncludeFilePrefix((String)EnvUtils.toHostID((ExecutionEnvironment)env)) : null;
    }

    @Override
    public String getIncludeFilePathPrefix() {
        if (this.includeFilePrefix == null && this.getExecutionEnvironment().isLocal()) {
            this.includeFilePrefix = "";
            ToolchainManager.CompilerDescriptor c = this.getDescriptor();
            if (c != null) {
                int i;
                String path = this.getPath().replaceAll("\\\\", "/");
                if (c.getRemoveIncludePathPrefix() != null && (i = path.toLowerCase().indexOf("/bin")) > 0) {
                    this.includeFilePrefix = path.substring(0, i);
                }
            }
        }
        return this.includeFilePrefix;
    }

    @Override
    public abstract ToolchainManager.CompilerDescriptor getDescriptor();

    public String getDevelopmentModeOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getDevelopmentModeFlags() != null && compiler.getDevelopmentModeFlags().length > value) {
            return compiler.getDevelopmentModeFlags()[value];
        }
        return "";
    }

    public String getWarningLevelOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getWarningLevelFlags() != null && compiler.getWarningLevelFlags().length > value) {
            return compiler.getWarningLevelFlags()[value];
        }
        return "";
    }

    public String getSixtyfourBitsOption(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getArchitectureFlags() != null && compiler.getArchitectureFlags().length > value) {
            return compiler.getArchitectureFlags()[value];
        }
        return "";
    }

    public String getStripOption(boolean value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && value) {
            return compiler.getStripFlag();
        }
        return "";
    }

    public String getDependencyGenerationOption() {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getDependencyGenerationFlags() != null) {
            return compiler.getDependencyGenerationFlags();
        }
        return "";
    }

    public String getMTLevelOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getMultithreadingFlags() != null && compiler.getMultithreadingFlags().length > value) {
            return compiler.getMultithreadingFlags()[value];
        }
        return "";
    }

    public String getLanguageExtOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getLanguageExtensionFlags() != null && compiler.getLanguageExtensionFlags().length > value) {
            return compiler.getLanguageExtensionFlags()[value];
        }
        return "";
    }

    public String getLibraryLevelOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getLibraryFlags() != null && compiler.getLibraryFlags().length > value) {
            return compiler.getLibraryFlags()[value];
        }
        return "";
    }

    public String getStandardEvaluationOptions(int value) {
        ToolchainManager.CompilerDescriptor compiler = this.getDescriptor();
        if (compiler != null && compiler.getStandardFlags() != null && compiler.getStandardFlags().length > value) {
            return compiler.getStandardFlags()[value];
        }
        return "";
    }

    public List<String> getSystemPreprocessorSymbols() {
        return new Vector<String>();
    }

    public List<String> getSystemIncludeDirectories() {
        return new Vector<String>();
    }

    public boolean setSystemPreprocessorSymbols(List<String> values) {
        return false;
    }

    public boolean setSystemIncludeDirectories(List<String> values) {
        return false;
    }

    protected final void normalizePaths(List<String> paths) {
        for (int i = 0; i < paths.size(); ++i) {
            paths.set(i, this.normalizePath(paths.get(i)));
        }
    }

    protected String normalizePath(String path) {
        return CndFileUtils.normalizeAbsolutePath((String)new File(path).getAbsolutePath());
    }

    protected final String applyPathPrefix(String path) {
        String prefix = this.getIncludeFilePathPrefix();
        return this.normalizePath(prefix != null ? prefix + path : path);
    }

    public final void resetSystemProperties() {
        this.resetSystemProperties(false);
    }

    public void resetSystemProperties(boolean lazy) {
    }

    public void saveSettings(Preferences prefs, String prefix) {
    }

    public void loadSettings(Preferences prefs, String prefix) {
    }
}

