/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.SwingUtilities;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.ExternalProcessBuilder;
import org.netbeans.api.extexecution.input.InputProcessor;
import org.netbeans.api.extexecution.input.InputProcessors;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.URLWait;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.config.WLDatasource;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicWebApp;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentStatus;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLProgressObject;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLTargetModuleID;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public final class WLCommandDeployer {
    private static final Logger LOGGER = Logger.getLogger(WLCommandDeployer.class.getName());
    private static final String WEBLOGIC_JAR_PATH = "server/lib/weblogic.jar";
    private static final int TIMEOUT = 300000;
    private static final Pattern LIST_APPS_PATTERN = Pattern.compile("\\s+(.*)");
    private static boolean showConsole = Boolean.getBoolean(WLCommandDeployer.class.getName() + ".showConsole");
    private final WLDeploymentFactory factory;
    private final InstanceProperties ip;

    public WLCommandDeployer(WLDeploymentFactory wLDeploymentFactory, InstanceProperties instanceProperties) {
        this.factory = wLDeploymentFactory;
        this.ip = instanceProperties;
    }

    public ProgressObject deploy(Target[] targetArray, final File file, File file2, String string, String string2) {
        WLTargetModuleID wLTargetModuleID = WLCommandDeployer.createModuleId(new Target(){

            public String getName() {
                return "default";
            }

            public String getDescription() {
                return "server";
            }
        }, file, string, string2);
        final WLProgressObject wLProgressObject = new WLProgressObject(wLTargetModuleID);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deploying", (Object)file.getAbsolutePath())));
        this.factory.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                ExecutionService executionService = WLCommandDeployer.this.createService("-deploy", null, new String[]{file.getAbsolutePath()});
                Future future = executionService.run();
                try {
                    Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
                    if (n != 0) {
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deployment_Failed")));
                    } else {
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deployment_Completed")));
                    }
                }
                catch (InterruptedException interruptedException) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deployment_Failed_Interrupted")));
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                }
                catch (TimeoutException timeoutException) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deployment_Failed_Timeout")));
                    future.cancel(true);
                }
                catch (ExecutionException executionException) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Deployment_Failed_With_Message")));
                }
            }
        });
        return wLProgressObject;
    }

    public ProgressObject undeploy(final TargetModuleID[] targetModuleIDArray) {
        final WLProgressObject wLProgressObject = new WLProgressObject(targetModuleIDArray);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Started")));
        this.factory.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (TargetModuleID targetModuleID : targetModuleIDArray) {
                    String string = targetModuleID.getModuleID();
                    ExecutionService executionService = WLCommandDeployer.this.createService("-undeploy", null, new String[]{"-name", string});
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeploying", (Object)string)));
                    Future future = executionService.run();
                    try {
                        Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
                        if (n == 0) continue;
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Failed")));
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Failed_Interrupted")));
                        future.cancel(true);
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException timeoutException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Failed_Timeout")));
                        future.cancel(true);
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.UNDEPLOY, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Failed_With_Message")));
                    }
                    break;
                }
                if (!bl) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Undeployment_Completed")));
                }
            }
        });
        return wLProgressObject;
    }

    public ProgressObject start(final TargetModuleID[] targetModuleIDArray) {
        final WLProgressObject wLProgressObject = new WLProgressObject(targetModuleIDArray);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Started")));
        this.factory.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (TargetModuleID targetModuleID : targetModuleIDArray) {
                    String string = targetModuleID.getModuleID();
                    ExecutionService executionService = WLCommandDeployer.this.createService("-start", null, new String[]{"-name", string});
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Starting", (Object)string)));
                    Future future = executionService.run();
                    try {
                        Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
                        if (n != 0) {
                            bl = true;
                            wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Failed")));
                            break;
                        }
                        WLCommandDeployer.waitForUrlReady(WLCommandDeployer.this.factory, targetModuleID, wLProgressObject);
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Failed_Interrupted")));
                        future.cancel(true);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Failed_Timeout")));
                        future.cancel(true);
                        break;
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Failed_With_Message")));
                        break;
                    }
                }
                if (!bl) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Start_Completed")));
                }
            }
        });
        return wLProgressObject;
    }

    public ProgressObject stop(final TargetModuleID[] targetModuleIDArray) {
        final WLProgressObject wLProgressObject = new WLProgressObject(targetModuleIDArray);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Started")));
        this.factory.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (TargetModuleID targetModuleID : targetModuleIDArray) {
                    String string = targetModuleID.getModuleID();
                    ExecutionService executionService = WLCommandDeployer.this.createService("-stop", null, new String[]{"-name", string});
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stopping", (Object)string)));
                    Future future = executionService.run();
                    try {
                        Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
                        if (n == 0) continue;
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Failed")));
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Failed_Interrupted")));
                        future.cancel(true);
                        Thread.currentThread().interrupt();
                    }
                    catch (TimeoutException timeoutException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Failed_Timeout")));
                        future.cancel(true);
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Failed_With_Message")));
                    }
                    break;
                }
                if (!bl) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.COMPLETED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Stop_Completed")));
                }
            }
        });
        return wLProgressObject;
    }

    public ProgressObject deployDatasource(final Collection<WLDatasource> collection) {
        final WLProgressObject wLProgressObject = new WLProgressObject(new TargetModuleID[0]);
        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Started")));
        this.factory.getExecutorService().submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (WLDatasource wLDatasource : collection) {
                    if (wLDatasource.getOrigin() == null) {
                        LOGGER.log(Level.INFO, "Could not deploy {0}", wLDatasource.getName());
                        continue;
                    }
                    ExecutionService executionService = WLCommandDeployer.this.createService("-deploy", null, new String[]{"-name", wLDatasource.getName(), "-upload", wLDatasource.getOrigin().getAbsolutePath()});
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Deploying", (Object)wLDatasource.getName())));
                    Future future = executionService.run();
                    try {
                        Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
                        if (n == 0) continue;
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Failed")));
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Failed_Interrupted")));
                        future.cancel(true);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    catch (TimeoutException timeoutException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Failed_Timeout")));
                        future.cancel(true);
                        break;
                    }
                    catch (ExecutionException executionException) {
                        bl = true;
                        wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.FAILED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Failed_With_Message")));
                        break;
                    }
                }
                if (!bl) {
                    wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.COMPLETED, NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Datasource_Completed")));
                }
            }
        });
        return wLProgressObject;
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetArray) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Should not be executed in EDT";
        ListAppLineProcessor listAppLineProcessor = new ListAppLineProcessor();
        ExecutionService executionService = this.createService("-listapps", listAppLineProcessor, new String[0]);
        Future future = executionService.run();
        try {
            Integer n = (Integer)future.get(300000L, TimeUnit.MILLISECONDS);
            if (n != 0) {
                return null;
            }
            List<String> list = listAppLineProcessor.getApps();
            TargetModuleID[] targetModuleIDArray = new TargetModuleID[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                targetModuleIDArray[i] = new WLTargetModuleID(targetArray[0], list.get(i));
            }
            return targetModuleIDArray;
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.INFO, null, executionException);
            return null;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (TimeoutException timeoutException) {
            LOGGER.log(Level.INFO, null, timeoutException);
            return null;
        }
    }

    private ExecutionService createService(String string, final LineProcessor lineProcessor, String ... executionDescriptor) {
        String string2 = this.ip.getProperty("username");
        String string3 = this.ip.getProperty("password");
        String string4 = this.ip.getProperty("url");
        String[] stringArray = string4.substring("deployer:WebLogic:http://".length()).split(":");
        String string5 = stringArray[0];
        String string6 = stringArray.length > 1 ? stringArray[1] : "";
        ExternalProcessBuilder externalProcessBuilder = new ExternalProcessBuilder(this.getJavaBinary()).addArgument("-cp").addArgument(this.getClassPath()).addArgument("weblogic.Deployer").addArgument("-adminurl").addArgument("t3://" + string5 + ":" + string6).addArgument("-username").addArgument(string2).addArgument("-password").addArgument(string3).addArgument(string);
        for (String string7 : executionDescriptor) {
            externalProcessBuilder = externalProcessBuilder.addArgument(string7);
        }
        ExecutionDescriptor executionDescriptor2 = new ExecutionDescriptor().inputVisible(true).outLineBased(true);
        if (lineProcessor != null) {
            executionDescriptor2 = executionDescriptor2.outProcessorFactory(new ExecutionDescriptor.InputProcessorFactory(){

                public InputProcessor newInputProcessor(InputProcessor inputProcessor) {
                    return InputProcessors.proxy((InputProcessor[])new InputProcessor[]{inputProcessor, InputProcessors.bridge((LineProcessor)lineProcessor)});
                }
            });
        }
        if (!showConsole) {
            executionDescriptor2 = executionDescriptor2.inputOutput(InputOutput.NULL);
        }
        return ExecutionService.newService((Callable)externalProcessBuilder, (ExecutionDescriptor)executionDescriptor2, (String)("weblogic.Deployer " + string));
    }

    private String getClassPath() {
        File file;
        String string = this.ip.getProperty("serverRoot");
        if (string != null && (file = new File(string, WEBLOGIC_JAR_PATH)).exists() && file.isFile()) {
            return file.getAbsolutePath();
        }
        return "";
    }

    private String getJavaBinary() {
        FileObject fileObject;
        File file;
        JavaPlatform javaPlatform = JavaPlatformManager.getDefault().getDefaultPlatform();
        Collection collection = javaPlatform.getInstallFolders();
        String string = "java";
        if (collection.size() > 0 && (file = FileUtil.toFile((FileObject)(fileObject = (FileObject)collection.iterator().next()))) != null) {
            string = file.getAbsolutePath() + File.separator + "bin" + File.separator + "java";
        }
        return string;
    }

    private static void waitForUrlReady(WLDeploymentFactory wLDeploymentFactory, TargetModuleID targetModuleID, WLProgressObject wLProgressObject) throws InterruptedException, TimeoutException {
        TargetModuleID[] targetModuleIDArray;
        String string = targetModuleID.getWebURL();
        if (string == null && (targetModuleIDArray = targetModuleID.getChildTargetModuleID()) != null) {
            for (int i = 0; i < targetModuleIDArray.length && (string = targetModuleIDArray[i].getWebURL()) == null; ++i) {
            }
        }
        WLCommandDeployer.waitForUrlReady(wLDeploymentFactory, string, wLProgressObject);
    }

    private static void waitForUrlReady(WLDeploymentFactory wLDeploymentFactory, String string, WLProgressObject wLProgressObject) throws InterruptedException, TimeoutException {
        if (string != null) {
            try {
                URL uRL = new URL(string);
                String string2 = NbBundle.getMessage(WLCommandDeployer.class, (String)"MSG_Waiting_For_Url", (Object)uRL);
                wLProgressObject.fireProgressEvent(null, new WLDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, string2));
                for (int i = 0; i < 3; ++i) {
                    Thread.sleep(1000L);
                }
                long l = System.currentTimeMillis();
                while (System.currentTimeMillis() - l < 300000L && !URLWait.waitForUrlReady(wLDeploymentFactory.getExecutorService(), uRL, 1000)) {
                }
            }
            catch (MalformedURLException malformedURLException) {
                LOGGER.log(Level.INFO, "Malformed URL {0}", string);
            }
        }
    }

    private static WLTargetModuleID createModuleId(Target target, File file, String string, String string2) {
        WLTargetModuleID wLTargetModuleID = new WLTargetModuleID(target, file.getName());
        try {
            String string3 = "http://" + string + ":" + string2;
            if (file.getName().endsWith(".war")) {
                WLCommandDeployer.configureWarModuleId(wLTargetModuleID, file, string3);
            } else if (file.getName().endsWith(".ear")) {
                WLCommandDeployer.configureEarModuleId(wLTargetModuleID, file, string3);
            }
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
        }
        return wLTargetModuleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureWarModuleId(WLTargetModuleID wLTargetModuleID, File file, String string) {
        block8: {
            try {
                JarFileSystem jarFileSystem = new JarFileSystem();
                jarFileSystem.setJarFile(file);
                FileObject fileObject = jarFileSystem.getRoot().getFileObject("WEB-INF/weblogic.xml");
                if (fileObject != null) {
                    InputStream inputStream = fileObject.getInputStream();
                    try {
                        String[] stringArray = WeblogicWebApp.createGraph(inputStream).getContextRoot();
                        if (stringArray != null && stringArray.length > 0) {
                            wLTargetModuleID.setContextURL(string + stringArray[0]);
                        }
                        break block8;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                System.out.println("Cannot find file WEB-INF/weblogic.xml in " + file);
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, null, iOException);
            }
            catch (PropertyVetoException propertyVetoException) {
                LOGGER.log(Level.INFO, null, propertyVetoException);
            }
        }
    }

    private static void configureEarModuleId(WLTargetModuleID wLTargetModuleID, File file, String string) {
        try {
            JarFileSystem jarFileSystem = new JarFileSystem();
            jarFileSystem.setJarFile(file);
            FileObject fileObject = jarFileSystem.getRoot().getFileObject("META-INF/application.xml");
            if (fileObject != null) {
                Application application = DDProvider.getDefault().getDDRoot(fileObject);
                Module[] moduleArray = application.getModule();
                for (int i = 0; i < moduleArray.length; ++i) {
                    WLTargetModuleID wLTargetModuleID2 = new WLTargetModuleID(wLTargetModuleID.getTarget());
                    if (moduleArray[i].getWeb() != null) {
                        wLTargetModuleID2.setContextURL(string + moduleArray[i].getWeb().getContextRoot());
                    }
                    wLTargetModuleID.addChild(wLTargetModuleID2);
                }
            } else {
                for (FileObject fileObject2 : jarFileSystem.getRoot().getChildren()) {
                    if (!fileObject2.hasExt("war") && !fileObject2.hasExt("jar")) continue;
                    WLTargetModuleID wLTargetModuleID3 = new WLTargetModuleID(wLTargetModuleID.getTarget());
                    if (fileObject2.hasExt("war")) {
                        WLCommandDeployer.configureWarInEarModuleId(wLTargetModuleID3, fileObject2, string);
                    }
                    wLTargetModuleID.addChild(wLTargetModuleID3);
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
        catch (PropertyVetoException propertyVetoException) {
            LOGGER.log(Level.INFO, null, propertyVetoException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureWarInEarModuleId(WLTargetModuleID wLTargetModuleID, FileObject fileObject, String string) {
        try {
            String string2 = "/" + fileObject.getName();
            ZipInputStream zipInputStream = new ZipInputStream(fileObject.getInputStream());
            try {
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (!"WEB-INF/weblogic.xml".equals(zipEntry.getName())) continue;
                    String[] stringArray = WeblogicWebApp.createGraph(new ZipEntryInputStream(zipInputStream)).getContextRoot();
                    if (stringArray != null && stringArray.length > 0) {
                        string2 = stringArray[0];
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.INFO, "Error reading context-root", iOException);
            }
            finally {
                zipInputStream.close();
            }
            wLTargetModuleID.setContextURL(string + string2);
        }
        catch (IOException iOException) {
            LOGGER.log(Level.INFO, null, iOException);
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zipInputStream) {
            this.zis = zipInputStream;
        }

        @Override
        public int available() throws IOException {
            return this.zis.available();
        }

        @Override
        public void close() throws IOException {
            this.zis.closeEntry();
        }

        @Override
        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.zis.read(byArray, n, n2);
        }

        @Override
        public long skip(long l) throws IOException {
            return this.zis.skip(l);
        }
    }

    private static class ListAppLineProcessor
    implements LineProcessor {
        private List<String> apps = new ArrayList<String>();

        private ListAppLineProcessor() {
        }

        public synchronized List<String> getApps() {
            return this.apps;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processLine(String string) {
            Matcher matcher = LIST_APPS_PATTERN.matcher(string);
            if (matcher.matches()) {
                ListAppLineProcessor listAppLineProcessor = this;
                synchronized (listAppLineProcessor) {
                    this.apps.add(matcher.group(1));
                }
            }
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

