/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;

public class ProjectTreeElement
implements TreeElement {
    private final String name;
    private final Icon icon;
    private final CsmUID<CsmProject> prjUID;

    public ProjectTreeElement(CsmProject csmPrj) {
        Object prj = csmPrj.getPlatformProject();
        if (prj instanceof NativeProject && ((NativeProject)prj).getProject() instanceof Project) {
            Project p = (Project)((NativeProject)prj).getProject();
            ProjectInformation pi = ProjectUtils.getInformation((Project)p);
            this.name = pi.getDisplayName();
            this.icon = pi.getIcon();
        } else {
            this.icon = CsmImageLoader.getProjectIcon((CsmProject)csmPrj, (boolean)false);
            this.name = ((Object)csmPrj.getName()).toString();
        }
        this.prjUID = CsmRefactoringUtils.getHandler(csmPrj);
    }

    public TreeElement getParent(boolean isLogical) {
        return null;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean isLogical) {
        return this.name;
    }

    public Object getUserObject() {
        return this.prjUID.getObject();
    }
}

