/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.actions;

import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.MutablePositionRegion;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmIncludeHierarchyResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.actions.SyncDocumentRegion;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.utils.ui.UIGesturesSupport;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.spi.editor.highlighting.support.PositionsBag;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class InstantRenamePerformer
implements DocumentListener,
KeyListener {
    private SyncDocumentRegion region;
    private Document doc;
    private JTextComponent target;
    private final PositionsBag bag;
    private boolean inSync;
    private static InstantRenamePerformer instance = null;
    private static final AttributeSet COLORING = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, new Color(138, 191, 236)});

    InstantRenamePerformer(JTextComponent target, Collection<CsmReference> highlights, int caretOffset) throws BadLocationException {
        this.target = target;
        this.doc = target.getDocument();
        MutablePositionRegion mainRegion = null;
        ArrayList<MutablePositionRegion> regions = new ArrayList<MutablePositionRegion>();
        this.bag = new PositionsBag(this.doc);
        for (CsmReference h : highlights) {
            Position end;
            Position start = NbDocument.createPosition((Document)this.doc, (int)h.getStartOffset(), (Position.Bias)Position.Bias.Backward);
            MutablePositionRegion current = new MutablePositionRegion(start, end = NbDocument.createPosition((Document)this.doc, (int)h.getEndOffset(), (Position.Bias)Position.Bias.Forward));
            if (this.isIn(current, caretOffset)) {
                mainRegion = current;
            } else {
                regions.add(current);
            }
            this.bag.addHighlight(start, end, COLORING);
        }
        if (mainRegion == null) {
            throw new IllegalArgumentException("No highlight contains the caret.");
        }
        regions.add(0, mainRegion);
        this.region = new SyncDocumentRegion(this.doc, regions);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).addPostModificationDocumentListener((DocumentListener)this);
        }
        target.addKeyListener(this);
        target.putClientProperty(InstantRenamePerformer.class, this);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        target.select(mainRegion.getStartOffset(), mainRegion.getEndOffset());
    }

    private static String getString(String key) {
        return NbBundle.getMessage(InstantRenamePerformer.class, (String)key);
    }

    public static void invokeInstantRename(JTextComponent target) {
        try {
            Collection<CsmReference> changePoints;
            int caret = target.getCaretPosition();
            Document doc = target.getDocument();
            DataObject dobj = NbEditorUtilities.getDataObject((Document)doc);
            CsmFile file = CsmUtilities.getCsmFile((DataObject)dobj, (boolean)false, (boolean)false);
            if (file == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            CsmReference ref = CsmReferenceResolver.getDefault().findReference(file, caret);
            if (ref == null) {
                Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
                return;
            }
            boolean doFullRename = true;
            if (InstantRenamePerformer.allowInstantRename(ref, dobj.getPrimaryFile()) && !(changePoints = InstantRenamePerformer.computeChangePoints(ref)).isEmpty()) {
                doFullRename = false;
                InstantRenamePerformer.doInstantRename(changePoints, target, caret);
            }
            if (doFullRename) {
                InstantRenamePerformer.doFullRename(dobj, target);
            }
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static boolean allowInstantRename(CsmReference ref, FileObject fo) {
        if (CsmRefactoringUtils.isRefactorable(fo)) {
            return InstantRenamePerformer.allowInstantRename(ref);
        }
        return false;
    }

    static boolean allowInstantRename(CsmReference ref) {
        CsmReferenceResolver.Scope scope = CsmReferenceResolver.getDefault().fastCheckScope(ref);
        if (scope == CsmReferenceResolver.Scope.LOCAL) {
            return true;
        }
        if (scope == CsmReferenceResolver.Scope.FILE_LOCAL) {
            return CsmIncludeHierarchyResolver.getDefault().getFiles(ref.getContainingFile()).isEmpty();
        }
        return false;
    }

    private static void doFullRename(DataObject dobj, JTextComponent target) {
        EditorCookie ec = (EditorCookie)dobj.getCookie(EditorCookie.class);
        Node n = dobj.getNodeDelegate();
        if (n == null) {
            Utilities.setStatusBoldText((JTextComponent)target, (String)InstantRenamePerformer.getString("no-instant-rename"));
            return;
        }
        InstanceContent ic = new InstanceContent();
        if (ec != null) {
            ic.add((Object)ec);
        }
        ic.add((Object)n);
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        Action a = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)actionContext);
        a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
    }

    private static void doInstantRename(Collection<CsmReference> changePoints, JTextComponent target, int caret) throws BadLocationException {
        InstantRenamePerformer.performInstantRename(target, changePoints, caret);
    }

    static Collection<CsmReference> computeChangePoints(CsmReference ref) {
        CsmObject resolved = ref.getReferencedObject();
        if (resolved == null) {
            return Collections.emptyList();
        }
        CsmFile file = ref.getContainingFile();
        Collection out = CsmReferenceRepository.getDefault().getReferences(resolved, file, CsmReferenceKind.ALL, null);
        return out;
    }

    public static synchronized void performInstantRename(JTextComponent target, Collection<CsmReference> highlights, int caretOffset) throws BadLocationException {
        if (instance != null) {
            if (InstantRenamePerformer.instance.target != target) {
                instance.release();
            } else {
                return;
            }
        }
        UIGesturesSupport.submit((String)"USG_CND_REFACTORING", (Object[])new Object[]{"INSTANT_RENAME"});
        instance = new InstantRenamePerformer(target, highlights, caretOffset);
    }

    private boolean isIn(MutablePositionRegion region, int caretOffset) {
        return region.getStartOffset() <= caretOffset && caretOffset <= region.getEndOffset();
    }

    @Override
    public synchronized void insertUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public synchronized void removeUpdate(DocumentEvent e) {
        if (this.inSync) {
            return;
        }
        if (this.doc.getProperty("doc-replace-selection-property") != null) {
            return;
        }
        this.inSync = true;
        this.region.sync(0);
        InstantRenamePerformer.getHighlightsBag(this.doc).setHighlights(this.bag);
        this.inSync = false;
        this.target.repaint();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    public void caretUpdate(CaretEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getModifiers() == 0 || e.getKeyCode() == 10 && e.getModifiers() == 0) {
            this.release();
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    private synchronized void release() {
        this.target.putClientProperty(InstantRenamePerformer.class, null);
        if (this.doc instanceof BaseDocument) {
            ((BaseDocument)this.doc).removePostModificationDocumentListener((DocumentListener)this);
        }
        this.target.removeKeyListener(this);
        InstantRenamePerformer.getHighlightsBag(this.doc).clear();
        this.region = null;
        this.doc = null;
        this.target = null;
        instance = null;
    }

    public static PositionsBag getHighlightsBag(Document doc) {
        PositionsBag bag = (PositionsBag)doc.getProperty(InstantRenamePerformer.class);
        if (bag == null) {
            bag = new PositionsBag(doc);
            doc.putProperty(InstantRenamePerformer.class, bag);
        }
        return bag;
    }
}

