/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage.spi.support;

import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public final class StorageSupport {
    private static final Logger LOG = Logger.getLogger(StorageSupport.class.getName());
    private static Map<String, Integer> names;
    private static final String EMACS_CTRL = "Ctrl+";
    private static final String EMACS_ALT = "Alt+";
    private static final String EMACS_SHIFT = "Shift+";
    private static final String EMACS_META = "Meta+";

    private StorageSupport() {
    }

    public static String getLocalizingBundleMessage(FileObject fo, String key, String defaultValue) {
        return Utils.getLocalizedName(fo, key, defaultValue, false);
    }

    public static String keyStrokesToString(Collection<? extends KeyStroke> keys, boolean emacsStyle) {
        StringBuilder sb = new StringBuilder();
        Iterator<? extends KeyStroke> it = keys.iterator();
        while (it.hasNext()) {
            KeyStroke keyStroke = it.next();
            if (emacsStyle) {
                sb.append(Utilities.keyToString((KeyStroke)keyStroke, (boolean)true));
                if (!it.hasNext()) continue;
                sb.append('$');
                continue;
            }
            sb.append(StorageSupport.keyStrokeToHumanReadableString(keyStroke));
            if (!it.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static KeyStroke[] stringToKeyStrokes(String key, boolean emacsStyle) {
        assert (key != null) : "The parameter key must not be null";
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        String delimiter = emacsStyle ? "$" : " ";
        StringTokenizer st = new StringTokenizer(key, delimiter);
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = emacsStyle ? Utilities.stringToKey((String)ks) : StorageSupport.humanReadableStringToKeyStroke(ks);
            if (keyStroke != null) {
                result.add(keyStroke);
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Invalid keystroke string: '" + ks + "'");
            }
            return null;
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    private static KeyStroke humanReadableStringToKeyStroke(String keyStroke) {
        KeyStroke ks;
        int modifiers = 0;
        if (keyStroke.startsWith(EMACS_CTRL)) {
            modifiers |= 0x80;
            keyStroke = keyStroke.substring(EMACS_CTRL.length());
        }
        if (keyStroke.startsWith(EMACS_ALT)) {
            modifiers |= 0x200;
            keyStroke = keyStroke.substring(EMACS_ALT.length());
        }
        if (keyStroke.startsWith(EMACS_SHIFT)) {
            modifiers |= 0x40;
            keyStroke = keyStroke.substring(EMACS_SHIFT.length());
        }
        if (keyStroke.startsWith(EMACS_META)) {
            modifiers |= 0x100;
            keyStroke = keyStroke.substring(EMACS_META.length());
        }
        if ((ks = Utilities.stringToKey((String)keyStroke)) != null) {
            return KeyStroke.getKeyStroke(ks.getKeyCode(), modifiers);
        }
        Integer keyCode = StorageSupport.getName2Keycode().get(keyStroke);
        return keyCode != null ? KeyStroke.getKeyStroke(keyCode, modifiers) : null;
    }

    private static synchronized Map<String, Integer> getName2Keycode() {
        if (names != null) {
            return names;
        }
        Field[] fields = KeyEvent.class.getDeclaredFields();
        names = new HashMap<String, Integer>(fields.length * 4 / 3 + 5, 0.75f);
        for (Field f : fields) {
            if (!Modifier.isStatic(f.getModifiers())) continue;
            try {
                int numb = f.getInt(null);
                names.put(KeyEvent.getKeyText(numb), numb);
            }
            catch (IllegalArgumentException ex) {
            }
            catch (IllegalAccessException ex) {
                // empty catch block
            }
        }
        return names;
    }

    private static String keyStrokeToHumanReadableString(KeyStroke keyStroke) {
        int modifiers = keyStroke.getModifiers();
        StringBuilder sb = new StringBuilder();
        if ((modifiers & 0x80) > 0) {
            sb.append(EMACS_CTRL);
        }
        if ((modifiers & 0x200) > 0) {
            sb.append(EMACS_ALT);
        }
        if ((modifiers & 0x40) > 0) {
            sb.append(EMACS_SHIFT);
        }
        if ((modifiers & 0x100) > 0) {
            sb.append(EMACS_META);
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            sb.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return sb.toString();
    }
}

