/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class SourceRootsUi {
    private SourceRootsUi() {
    }

    public static DefaultTableModel createModel(SourceRoots roots) {
        String[] rootLabels = roots.getRootNames();
        String[] rootProps = roots.getRootProperties();
        URL[] rootURLs = roots.getRootURLs();
        Object[][] data = new Object[rootURLs.length][2];
        for (int i = 0; i < rootURLs.length; ++i) {
            data[i][0] = new File(URI.create(rootURLs[i].toExternalForm()));
            data[i][1] = roots.getRootDisplayName(rootLabels[i], rootProps[i]);
        }
        return new SourceRootsModel(data);
    }

    public static EditMediator registerEditMediator(Project master, SourceRoots sourceRoots, JTable rootsList, JButton addFolderButton, JButton removeButton, JButton upButton, JButton downButton, CellEditor rootsListEditor, boolean emptyTableIsValid) {
        EditMediator em = new EditMediator(master, sourceRoots, rootsList, addFolderButton, removeButton, upButton, downButton, emptyTableIsValid);
        addFolderButton.addActionListener(em);
        removeButton.addActionListener(em);
        upButton.addActionListener(em);
        downButton.addActionListener(em);
        rootsList.getSelectionModel().addListSelectionListener(em);
        DefaultCellEditor editor = (DefaultCellEditor)rootsListEditor;
        if (editor == null) {
            editor = new DefaultCellEditor(new JTextField());
        }
        editor.addCellEditorListener(em);
        rootsList.setDefaultRenderer(File.class, new FileRenderer(FileUtil.toFile((FileObject)master.getProjectDirectory())));
        rootsList.setDefaultEditor(String.class, editor);
        em.valueChanged(null);
        DefaultTableModel model = (DefaultTableModel)rootsList.getModel();
        Object[] columnNames = new String[]{NbBundle.getMessage(SourceRootsUi.class, (String)"CTL_PackageFolders"), NbBundle.getMessage(SourceRootsUi.class, (String)"CTL_PackageLabels")};
        model.setColumnIdentifiers(columnNames);
        rootsList.setSelectionMode(2);
        return em;
    }

    public static EditMediator registerEditMediator(Project master, SourceRoots sourceRoots, JTable rootsList, JButton addFolderButton, JButton removeButton, JButton upButton, JButton downButton) {
        return SourceRootsUi.registerEditMediator(master, sourceRoots, rootsList, addFolderButton, removeButton, upButton, downButton, null, true);
    }

    public static void showIllegalRootsDialog(Set roots) {
        JButton closeOption = new JButton(NbBundle.getMessage(SourceRootsUi.class, (String)"CTL_SourceRootsUi_Close"));
        closeOption.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceRootsUi.class, (String)"AD_SourceRootsUi_Close"));
        WarningDlg warning = new WarningDlg(roots);
        String message = NbBundle.getMessage(SourceRootsUi.class, (String)"MSG_InvalidRoot");
        JOptionPane optionPane = new JOptionPane(new Object[]{message, warning}, 2, 0, null, new Object[0], null);
        optionPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceRootsUi.class, (String)"AD_InvalidRootDlg"));
        DialogDescriptor dd = new DialogDescriptor((Object)optionPane, NbBundle.getMessage(SourceRootsUi.class, (String)"TITLE_InvalidRoot"), true, new Object[]{closeOption}, (Object)closeOption, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
    }

    private static class WarningDlg
    extends JPanel {
        private static final long serialVersionUID = 178428385251850014L;

        public WarningDlg(Set invalidRoots) {
            this.initGui(invalidRoots);
        }

        private void initGui(Set invalidRoots) {
            this.setLayout(new GridBagLayout());
            JLabel label = new JLabel();
            label.setText(NbBundle.getMessage(SourceRootsUi.class, (String)"LBL_InvalidRoot"));
            label.setDisplayedMnemonic(NbBundle.getMessage(SourceRootsUi.class, (String)"MNE_InvalidRoot").charAt(0));
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(12, 0, 6, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label, c);
            this.add(label);
            JList<Object> roots = new JList<Object>(invalidRoots.toArray());
            roots.setCellRenderer(new InvalidRootRenderer(true));
            JScrollPane p = new JScrollPane(roots);
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 1;
            c.anchor = 18;
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 12, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(p, c);
            this.add(p);
            label.setLabelFor(roots);
            roots.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SourceRootsUi.class, (String)"AD_InvalidRoot"));
            JLabel label2 = new JLabel();
            label2.setText(NbBundle.getMessage(SourceRootsUi.class, (String)"MSG_InvalidRoot2"));
            c = new GridBagConstraints();
            c.gridx = -1;
            c.gridy = -1;
            c.gridwidth = 0;
            c.fill = 2;
            c.anchor = 18;
            c.weightx = 1.0;
            c.insets = new Insets(0, 0, 0, 0);
            ((GridBagLayout)this.getLayout()).setConstraints(label2, c);
            this.add(label2);
        }

        private static class InvalidRootRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 194496879246810209L;
            private boolean projectConflict;

            public InvalidRootRenderer(boolean projectConflict) {
                this.projectConflict = projectConflict;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Project p;
                File f = (File)value;
                String message = f.getAbsolutePath();
                if (this.projectConflict && (p = FileOwnerQuery.getOwner((URI)f.toURI())) != null) {
                    ProjectInformation pi = ProjectUtils.getInformation((Project)p);
                    String projectName = pi.getDisplayName();
                    message = MessageFormat.format(NbBundle.getMessage(SourceRootsUi.class, (String)"TXT_RootOwnedByProject"), message, projectName);
                }
                return super.getListCellRendererComponent((JList<?>)list, message, index, isSelected, cellHasFocus);
            }
        }
    }

    private static class FileRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 19773973042472054L;
        private File projectFolder;

        public FileRenderer(File projectFolder) {
            this.projectFolder = projectFolder;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String displayName;
            if (value instanceof File) {
                File root = (File)value;
                String pfPath = this.projectFolder.getAbsolutePath() + File.separatorChar;
                String srPath = root.getAbsolutePath();
                displayName = srPath.startsWith(pfPath) ? srPath.substring(pfPath.length()) : srPath;
            } else {
                displayName = null;
            }
            Component c = super.getTableCellRendererComponent(table, displayName, isSelected, hasFocus, row, column);
            if (c instanceof JComponent) {
                ((JComponent)c).setToolTipText(displayName);
            }
            return c;
        }
    }

    private static class SourceRootsModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 139645020171023706L;

        public SourceRootsModel(Object[][] data) {
            super(data, new Object[]{"location", "label"});
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return File.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }
    }

    public static class EditMediator
    implements ActionListener,
    ListSelectionListener,
    CellEditorListener {
        final JTable rootsList;
        final JButton addFolderButton;
        final JButton removeButton;
        final JButton upButton;
        final JButton downButton;
        private final Project project;
        private final SourceRoots sourceRoots;
        private final Set<File> ownedFolders;
        private DefaultTableModel rootsModel;
        private EditMediator relatedEditMediator;
        private File lastUsedDir;
        private boolean emptyTableIsValid;

        public EditMediator(Project master, SourceRoots sourceRoots, JTable rootsList, JButton addFolderButton, JButton removeButton, JButton upButton, JButton downButton, boolean emptyTableIsValid) {
            this.emptyTableIsValid = emptyTableIsValid;
            if (!(rootsList.getModel() instanceof DefaultTableModel)) {
                throw new IllegalArgumentException("Jtable's model has to be of class DefaultTableModel");
            }
            this.rootsList = rootsList;
            this.addFolderButton = addFolderButton;
            this.removeButton = removeButton;
            this.upButton = upButton;
            this.downButton = downButton;
            this.ownedFolders = new HashSet<File>();
            this.project = master;
            this.sourceRoots = sourceRoots;
            this.ownedFolders.clear();
            this.rootsModel = (DefaultTableModel)rootsList.getModel();
            Vector<Vector> data = this.rootsModel.getDataVector();
            for (Vector row : data) {
                File f = (File)row.elementAt(0);
                this.ownedFolders.add(f);
            }
        }

        public void setRelatedEditMediator(EditMediator rem) {
            this.relatedEditMediator = rem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.addFolderButton) {
                int option;
                JFileChooser chooser = new JFileChooser();
                FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
                chooser.setFileSelectionMode(1);
                chooser.setMultiSelectionEnabled(true);
                if (this.sourceRoots.isTest()) {
                    chooser.setDialogTitle(NbBundle.getMessage(SourceRootsUi.class, (String)"LBL_TestFolder_DialogTitle"));
                } else {
                    chooser.setDialogTitle(NbBundle.getMessage(SourceRootsUi.class, (String)"LBL_SourceFolder_DialogTitle"));
                }
                File curDir = this.lastUsedDir;
                if (curDir == null) {
                    curDir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
                }
                if (curDir != null) {
                    chooser.setCurrentDirectory(curDir);
                }
                if ((option = chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this.addFolderButton))) == 0) {
                    curDir = chooser.getCurrentDirectory();
                    if (curDir != null) {
                        this.lastUsedDir = curDir;
                        if (this.relatedEditMediator != null) {
                            this.relatedEditMediator.lastUsedDir = curDir;
                        }
                    }
                    File[] files = chooser.getSelectedFiles();
                    this.addFolders(files);
                }
            } else if (source == this.removeButton) {
                this.removeElements();
            } else if (source == this.upButton) {
                this.moveUp();
            } else if (source == this.downButton) {
                this.moveDown();
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean remove;
            int[] si = this.rootsList.getSelectedRows();
            boolean bl = remove = si != null && si.length > 0;
            if (si != null && !this.emptyTableIsValid && remove) {
                remove = si.length < this.rootsList.getRowCount();
            }
            boolean up = si != null && si.length > 0 && si[0] != 0;
            boolean down = si != null && si.length > 0 && si[si.length - 1] != this.rootsList.getRowCount() - 1;
            this.removeButton.setEnabled(remove);
            this.upButton.setEnabled(up);
            this.downButton.setEnabled(down);
        }

        @Override
        public void editingCanceled(ChangeEvent e) {
        }

        @Override
        public void editingStopped(ChangeEvent e) {
        }

        private void addFolders(File[] files) {
            int[] si = this.rootsList.getSelectedRows();
            int lastIndex = si == null || si.length == 0 ? -1 : si[si.length - 1];
            ListSelectionModel selectionModel = this.rootsList.getSelectionModel();
            selectionModel.clearSelection();
            HashSet<File> rootsFromOtherProjects = new HashSet<File>();
            HashSet<File> rootsFromRelatedSourceRoots = new HashSet<File>();
            block0: for (int i = 0; i < files.length; ++i) {
                Project p;
                File normalizedFile = FileUtil.normalizeFile((File)files[i]);
                if (this.ownedFolders.contains(normalizedFile)) {
                    Vector<Vector> dataVector = this.rootsModel.getDataVector();
                    for (int j = 0; j < dataVector.size(); ++j) {
                        File f = (File)dataVector.elementAt(j).elementAt(0);
                        if (!f.equals(normalizedFile)) continue;
                        selectionModel.addSelectionInterval(j, j);
                    }
                } else if (this.relatedEditMediator != null && this.relatedEditMediator.ownedFolders.contains(normalizedFile)) {
                    rootsFromRelatedSourceRoots.add(normalizedFile);
                    continue;
                }
                if ((p = FileOwnerQuery.getOwner((URI)normalizedFile.toURI())) != null && !p.getProjectDirectory().equals(this.project.getProjectDirectory())) {
                    Sources sources = (Sources)p.getLookup().lookup(Sources.class);
                    if (sources == null) {
                        rootsFromOtherProjects.add(normalizedFile);
                        continue;
                    }
                    SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
                    SourceGroup[] javaGroups = sources.getSourceGroups("java");
                    SourceGroup[] groups = new SourceGroup[sourceGroups.length + javaGroups.length];
                    System.arraycopy(sourceGroups, 0, groups, 0, sourceGroups.length);
                    System.arraycopy(javaGroups, 0, groups, sourceGroups.length, javaGroups.length);
                    FileObject projectDirectory = p.getProjectDirectory();
                    FileObject fileObject = FileUtil.toFileObject((File)normalizedFile);
                    if (projectDirectory == null || fileObject == null) {
                        rootsFromOtherProjects.add(normalizedFile);
                        continue;
                    }
                    for (int j = 0; j < groups.length; ++j) {
                        FileObject sgRoot = groups[j].getRootFolder();
                        if (fileObject.equals(sgRoot)) {
                            rootsFromOtherProjects.add(normalizedFile);
                            continue block0;
                        }
                        if (projectDirectory.equals(sgRoot) || !FileUtil.isParentOf((FileObject)sgRoot, (FileObject)fileObject)) continue;
                        rootsFromOtherProjects.add(normalizedFile);
                        continue block0;
                    }
                }
                int current = lastIndex + 1 + i;
                this.rootsModel.insertRow(current, new Object[]{normalizedFile, this.sourceRoots.createInitialDisplayName(normalizedFile)});
                selectionModel.addSelectionInterval(current, current);
                this.ownedFolders.add(normalizedFile);
            }
            if (rootsFromOtherProjects.size() > 0 || rootsFromRelatedSourceRoots.size() > 0) {
                rootsFromOtherProjects.addAll(rootsFromRelatedSourceRoots);
                SourceRootsUi.showIllegalRootsDialog(rootsFromOtherProjects);
            }
        }

        private void removeElements() {
            int[] si = this.rootsList.getSelectedRows();
            if (si == null || si.length == 0) assert (false) : "Remove button should be disabled";
            for (int i = si.length - 1; i >= 0; --i) {
                this.ownedFolders.remove(this.rootsModel.getDataVector().elementAt(si[i]).elementAt(0));
                this.rootsModel.removeRow(si[i]);
            }
            if (this.rootsModel.getRowCount() != 0) {
                int selectedIndex = si[si.length - 1] - si.length + 1;
                if (selectedIndex > this.rootsModel.getRowCount() - 1) {
                    selectedIndex = this.rootsModel.getRowCount() - 1;
                }
                this.rootsList.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }

        private void moveUp() {
            int[] si = this.rootsList.getSelectedRows();
            if (si == null || si.length == 0) assert (false) : "MoveUp button should be disabled";
            ListSelectionModel selectionModel = this.rootsList.getSelectionModel();
            selectionModel.clearSelection();
            for (int i = 0; i < si.length; ++i) {
                Vector item = this.rootsModel.getDataVector().elementAt(si[i]);
                int newIndex = si[i] - 1;
                this.rootsModel.removeRow(si[i]);
                this.rootsModel.insertRow(newIndex, item);
                selectionModel.addSelectionInterval(newIndex, newIndex);
            }
        }

        private void moveDown() {
            int[] si = this.rootsList.getSelectedRows();
            if (si == null || si.length == 0) assert (false) : "MoveDown button should be disabled";
            ListSelectionModel selectionModel = this.rootsList.getSelectionModel();
            selectionModel.clearSelection();
            for (int i = si.length - 1; i >= 0; --i) {
                Vector item = this.rootsModel.getDataVector().elementAt(si[i]);
                int newIndex = si[i] + 1;
                this.rootsModel.removeRow(si[i]);
                this.rootsModel.insertRow(newIndex, item);
                selectionModel.addSelectionInterval(newIndex, newIndex);
            }
        }
    }
}

