/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.oauth.signature;

import com.sun.jersey.oauth.signature.OAuthRequest;
import com.sun.jersey.oauth.signature.URLCodec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthParameters
extends HashMap<String, String> {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String SCHEME = "OAuth";
    public static final String REALM = "realm";
    public static final String CONSUMER_KEY = "oauth_consumer_key";
    public static final String TOKEN = "oauth_token";
    public static final String SIGNATURE_METHOD = "oauth_signature_method";
    public static final String SIGNATURE = "oauth_signature";
    public static final String TIMESTAMP = "oauth_timestamp";
    public static final String NONCE = "oauth_nonce";
    public static final String VERSION = "oauth_version";
    public static final String VERIFIER = "oauth_verifier";
    public static final String CALLBACK = "oauth_callback";
    private static final String SCHEME_SPACE = "OAuth ";

    public String getRealm() {
        return (String)this.get(REALM);
    }

    public void setRealm(String realm) {
        this.put(REALM, realm);
    }

    public OAuthParameters realm(String realm) {
        this.setRealm(realm);
        return this;
    }

    public String getConsumerKey() {
        return (String)this.get(CONSUMER_KEY);
    }

    public void setConsumerKey(String consumerKey) {
        this.put(CONSUMER_KEY, consumerKey);
    }

    public OAuthParameters consumerKey(String consumerKey) {
        this.setConsumerKey(consumerKey);
        return this;
    }

    public String getToken() {
        return (String)this.get(TOKEN);
    }

    public void setToken(String token) {
        this.put(TOKEN, token);
    }

    public OAuthParameters token(String token) {
        this.setToken(token);
        return this;
    }

    public String getSignatureMethod() {
        return (String)this.get(SIGNATURE_METHOD);
    }

    public void setSignatureMethod(String signatureMethod) {
        this.put(SIGNATURE_METHOD, signatureMethod);
    }

    public OAuthParameters signatureMethod(String signatureMethod) {
        this.setSignatureMethod(signatureMethod);
        return this;
    }

    public String getSignature() {
        return (String)this.get(SIGNATURE);
    }

    public void setSignature(String signature) {
        this.put(SIGNATURE, signature);
    }

    public OAuthParameters signature(String signature) {
        this.setSignature(signature);
        return this;
    }

    public String getTimestamp() {
        return (String)this.get(TIMESTAMP);
    }

    public void setTimestamp(String timestamp) {
        this.put(TIMESTAMP, timestamp);
    }

    public OAuthParameters timestamp(String timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    public void setTimestamp() {
        this.setTimestamp(new Long(System.currentTimeMillis() / 1000L).toString());
    }

    public OAuthParameters timestamp() {
        this.setTimestamp();
        return this;
    }

    public String getNonce() {
        return (String)this.get(NONCE);
    }

    public void setNonce(String nonce) {
        this.put(NONCE, nonce);
    }

    public OAuthParameters nonce(String nonce) {
        this.setNonce(nonce);
        return this;
    }

    public void setNonce() {
        this.setNonce(UUID.randomUUID().toString());
    }

    public OAuthParameters nonce() {
        this.setNonce();
        return this;
    }

    public String getVersion() {
        return (String)this.get(VERSION);
    }

    public void setVersion(String version) {
        this.put(VERSION, version);
    }

    public OAuthParameters version(String version) {
        this.setVersion(version);
        return this;
    }

    private void setVersion() {
        this.setVersion("1.0");
    }

    public OAuthParameters version() {
        this.setVersion();
        return this;
    }

    private String getVerifier() {
        return (String)this.get(VERIFIER);
    }

    private void setVerifier(String verifier) {
        this.put(VERIFIER, verifier);
    }

    public OAuthParameters verifier(String verifier) {
        this.setVerifier(verifier);
        return this;
    }

    private String getCallback() {
        return (String)this.get(CALLBACK);
    }

    private void setCallback(String callback) {
        this.put(CALLBACK, callback);
    }

    public OAuthParameters callback(String callback) {
        this.setCallback(callback);
        return this;
    }

    private static String dequote(String value) {
        int length = value.length();
        return length >= 2 && value.charAt(0) == '\"' && value.charAt(length - 1) == '\"' ? value.substring(1, length - 1) : value;
    }

    public OAuthParameters readRequest(OAuthRequest request) {
        for (String param : request.getParameterNames()) {
            Iterator<String> i;
            List<String> values;
            if (!param.startsWith("oauth_") || (values = request.getParameterValues(param)) == null || !(i = values.iterator()).hasNext()) continue;
            this.put(param, i.next());
        }
        List<String> headers = request.getHeaderValues(AUTHORIZATION_HEADER);
        if (headers == null) {
            return this;
        }
        for (String header : headers) {
            if (!header.regionMatches(true, 0, SCHEME_SPACE, 0, SCHEME_SPACE.length())) continue;
            for (String param : header.substring(SCHEME_SPACE.length()).trim().split(",(?=(?:[^\"]*\"[^\"]*\")+$)")) {
                String[] nv = param.split("=", 2);
                if (nv.length != 2) continue;
                this.put(URLCodec.decode(nv[0].trim()), URLCodec.decode(OAuthParameters.dequote(nv[1].trim())));
            }
        }
        return this;
    }

    public OAuthParameters writeRequest(OAuthRequest request) {
        StringBuffer buf = new StringBuffer(SCHEME);
        boolean comma = false;
        for (String key : this.keySet()) {
            String value = (String)this.get(key);
            if (value == null) continue;
            buf.append(comma ? ", " : " ").append(URLCodec.encode(key));
            buf.append("=\"").append(URLCodec.encode(value)).append('\"');
            comma = true;
        }
        request.addHeaderValue(AUTHORIZATION_HEADER, buf.toString());
        return this;
    }
}

