/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.kenai.Support;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiSupport;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiService;

class KenaiProjectImpl
extends KenaiProject {
    private org.netbeans.modules.kenai.api.KenaiProject project;
    private KenaiSupport.BugtrackingType type;
    private KenaiFeature feature;

    public static String getProjectKey(org.netbeans.modules.kenai.api.KenaiProject project) {
        return project.getKenai().getUrl().toString() + ":" + project.getName();
    }

    private KenaiProjectImpl(org.netbeans.modules.kenai.api.KenaiProject project) {
        assert (project != null);
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KenaiProjectImpl getInstance(org.netbeans.modules.kenai.api.KenaiProject project) {
        HashMap<String, WeakReference<KenaiProjectImpl>> hashMap = Support.getInstance().projectsCache;
        synchronized (hashMap) {
            String projectKey = KenaiProjectImpl.getProjectKey(project);
            WeakReference<KenaiProjectImpl> wr = Support.getInstance().projectsCache.get(projectKey);
            KenaiProjectImpl result = null;
            if (wr == null || (result = (KenaiProjectImpl)((Object)wr.get())) == null) {
                result = new KenaiProjectImpl(project);
                Support.getInstance().projectsCache.put(KenaiProjectImpl.getProjectKey(project), new WeakReference<KenaiProjectImpl>(result));
            } else {
                result = (KenaiProjectImpl)((Object)wr.get());
                result.project = project;
            }
            return result;
        }
    }

    public URL getWebLocation() {
        return this.project.getWebLocation();
    }

    public String getFeatureLocation() {
        KenaiFeature f = this.getFeature();
        return f != null ? f.getLocation() : null;
    }

    public org.netbeans.modules.kenai.api.KenaiProject getProject() {
        return this.project;
    }

    public KenaiSupport.BugtrackingType getType() {
        if (this.type == null) {
            this.setupFeature();
        }
        return this.type;
    }

    public String getName() {
        return this.project.getName();
    }

    public String getDisplayName() {
        return this.project.getDisplayName();
    }

    private KenaiFeature getFeature() {
        if (this.feature == null) {
            this.setupFeature();
        }
        return this.feature;
    }

    private void setupFeature() {
        block4: {
            try {
                KenaiFeature[] features;
                for (KenaiFeature f : features = this.project.getFeatures(KenaiService.Type.ISSUES)) {
                    if (!"bugzilla".equals(f.getService())) continue;
                    this.type = KenaiSupport.BugtrackingType.BUGZILLA;
                    this.feature = f;
                    break;
                }
                if (this.type != null) break block4;
                for (KenaiFeature f : features) {
                    if (!"jira".equals(f.getService())) continue;
                    this.type = KenaiSupport.BugtrackingType.JIRA;
                    this.feature = f;
                    break;
                }
            }
            catch (KenaiException kenaiException) {
                Support.LOG.log(Level.SEVERE, kenaiException.getMessage(), kenaiException);
            }
        }
    }
}

