/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.netbeans.modules.bugtracking.kenai.KenaiProjectImpl;
import org.netbeans.modules.bugtracking.kenai.Support;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiManager;
import org.netbeans.modules.kenai.api.KenaiProjectMember;
import org.netbeans.modules.kenai.api.KenaiUser;
import org.netbeans.modules.kenai.ui.api.NbModuleOwnerSupport;
import org.netbeans.modules.kenai.ui.spi.Dashboard;
import org.netbeans.modules.kenai.ui.spi.KenaiUserUI;
import org.netbeans.modules.kenai.ui.spi.ProjectHandle;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class KenaiAccessorImpl
extends KenaiAccessor {
    private Map<String, DelegateKenaiListener> kenaiListeners;

    static KenaiAccessorImpl getInstance() {
        return (KenaiAccessorImpl)((Object)Lookup.getDefault().lookup(KenaiAccessorImpl.class));
    }

    public void logKenaiUsage(Object ... parameters) {
        UIUtils.logKenaiUsage((Object[])parameters);
    }

    public boolean isLoggedIn(String url) {
        boolean loggedIn = false;
        if (url == null) {
            for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
                if (kenai.getPasswordAuthentication() == null) continue;
                loggedIn = true;
                break;
            }
        } else {
            Kenai kenai = KenaiAccessorImpl.getKenai(url);
            loggedIn = kenai != null && kenai.getPasswordAuthentication() != null;
        }
        return loggedIn;
    }

    public boolean showLogin() {
        return KenaiAccessorImpl.showLoginIntern();
    }

    public Collection<RepositoryUser> getProjectMembers(KenaiProject kp) throws IOException {
        List<Object> members = null;
        if (kp instanceof KenaiProjectImpl) {
            KenaiProjectMember[] kenaiMembers = ((KenaiProjectImpl)kp).getProject().getMembers();
            members = new ArrayList<RepositoryUser>(kenaiMembers.length);
            for (KenaiProjectMember member : kenaiMembers) {
                KenaiUser user = member.getKenaiUser();
                members.add(new RepositoryUser(user.getUserName(), user.getFirstName() + " " + user.getLastName()));
            }
            if (members == null) {
                members = Collections.emptyList();
            }
            return members;
        }
        return Collections.EMPTY_LIST;
    }

    public PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        Kenai kenai = KenaiAccessorImpl.getKenai(url);
        if (kenai == null) {
            Support.LOG.log(Level.INFO, "no kenai for url : [{0}]", url);
            return null;
        }
        return KenaiAccessorImpl.getPasswordAuthentication(kenai, forceLogin);
    }

    public boolean isNetbeansKenaiRegistered() {
        Collection kenais = KenaiManager.getDefault().getKenais();
        for (Kenai kenai : kenais) {
            URL url = kenai.getUrl();
            if (!BugtrackingUtil.isNbRepository((String)url.toString())) continue;
            return true;
        }
        return false;
    }

    public JLabel createUserWidget(String userName, String host, String chatMessage) {
        KenaiUserUI ku = new KenaiUserUI(userName + "@" + host);
        ku.setMessage(chatMessage);
        return ku.createUserWidget();
    }

    public OwnerInfo getOwnerInfo(Node node) {
        NbModuleOwnerSupport.OwnerInfo ownerInfo = NbModuleOwnerSupport.getInstance().getOwnerInfo(node);
        return ownerInfo != null ? new OwnerInfoImpl(ownerInfo) : null;
    }

    public OwnerInfo getOwnerInfo(File file) {
        NbModuleOwnerSupport.OwnerInfo ownerInfo = NbModuleOwnerSupport.getInstance().getOwnerInfo(NbModuleOwnerSupport.NB_BUGZILLA_CONFIG, file);
        return ownerInfo != null ? new OwnerInfoImpl(ownerInfo) : null;
    }

    public KenaiProject[] getDashboardProjects() {
        ProjectHandle[] handles = Dashboard.getDefault().getOpenProjects();
        if (handles == null || handles.length == 0) {
            return new KenaiProjectImpl[0];
        }
        LinkedList<KenaiProjectImpl> kenaiProjects = new LinkedList<KenaiProjectImpl>();
        for (ProjectHandle handle : handles) {
            org.netbeans.modules.kenai.api.KenaiProject project = handle.getKenaiProject();
            if (project != null) {
                kenaiProjects.add(KenaiProjectImpl.getInstance(project));
                continue;
            }
            Support.LOG.warning("No Kenai project is available for ProjectHandle [" + handle.getId() + ", " + handle.getDisplayName() + "]");
        }
        return kenaiProjects.toArray(new KenaiProjectImpl[kenaiProjects.size()]);
    }

    public KenaiProject getKenaiProjectForRepository(String url) throws IOException {
        org.netbeans.modules.kenai.api.KenaiProject kp = org.netbeans.modules.kenai.api.KenaiProject.forRepository((String)url);
        return kp != null ? KenaiProjectImpl.getInstance(kp) : null;
    }

    public KenaiProject getKenaiProject(String url, String projectName) throws IOException {
        Kenai kenai = KenaiAccessorImpl.getKenai(url);
        if (kenai == null) {
            Support.LOG.log(Level.INFO, "no kenai for url : [{0}]", url);
            return null;
        }
        org.netbeans.modules.kenai.api.KenaiProject kp = kenai.getProject(projectName);
        return kp != null ? KenaiProjectImpl.getInstance(kp) : null;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener, String kenaiHostUrl) {
        Kenai kenai = KenaiAccessorImpl.getKenai(kenaiHostUrl);
        if (kenai != null) {
            this.addPropertyChangeListener(listener, kenai);
        } else {
            Support.LOG.warning("trying to unregister on a unknown kenai host " + kenaiHostUrl);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener, String kenaiHostUrl) {
        Kenai kenai = KenaiAccessorImpl.getKenai(kenaiHostUrl);
        if (kenai != null) {
            this.removePropertyChangeListener(listener, kenai);
        } else {
            Support.LOG.warning("trying to unregister on a unknown kenai host " + kenaiHostUrl);
        }
    }

    static boolean isLoggedIn(Kenai kenai) {
        return kenai.getPasswordAuthentication() != null;
    }

    static Kenai getKenai(String url) {
        Kenai kenaiCandidate = KenaiManager.getDefault().getKenai(url);
        if (kenaiCandidate != null) {
            return kenaiCandidate;
        }
        try {
            org.netbeans.modules.kenai.api.KenaiProject kp = org.netbeans.modules.kenai.api.KenaiProject.forRepository((String)url);
            if (kp != null) {
                return kp.getKenai();
            }
        }
        catch (KenaiException ex) {
            Support.LOG.log(Level.FINE, url, ex);
        }
        for (Kenai kenai : KenaiManager.getDefault().getKenais()) {
            String kenaiUrl = kenai.getUrl().toString();
            if (!url.startsWith(kenaiUrl)) continue;
            Support.LOG.log(Level.FINE, "getKenai: url {0} matches kenai url {1}", new String[]{url, kenaiUrl});
            return kenai;
        }
        return null;
    }

    static PasswordAuthentication getPasswordAuthentication(Kenai kenai, boolean forceLogin) {
        PasswordAuthentication a = kenai.getPasswordAuthentication();
        if (a != null) {
            return a;
        }
        if (!forceLogin) {
            return null;
        }
        if (!KenaiAccessorImpl.showLoginIntern()) {
            return null;
        }
        return kenai.getPasswordAuthentication();
    }

    static boolean showLoginIntern() {
        return UIUtils.showLogin();
    }

    void addPropertyChangeListener(PropertyChangeListener listener, Kenai kenai) {
        this.getKenaiListener(kenai).add(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener, Kenai kenai) {
        this.getKenaiListener(kenai).remove(listener);
    }

    private synchronized DelegateKenaiListener getKenaiListener(Kenai kenai) {
        DelegateKenaiListener l;
        if (this.kenaiListeners == null) {
            this.kenaiListeners = new HashMap<String, DelegateKenaiListener>();
        }
        if ((l = this.kenaiListeners.get(kenai.getUrl().toString())) == null) {
            l = new DelegateKenaiListener(kenai);
            this.kenaiListeners.put(kenai.getUrl().toString(), l);
        }
        return l;
    }

    private class DelegateKenaiListener
    implements PropertyChangeListener {
        private final Collection<PropertyChangeListener> delegates = new LinkedList<PropertyChangeListener>();
        private final Kenai kenai;

        public DelegateKenaiListener(Kenai kenai) {
            this.kenai = kenai;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("login")) {
                PropertyChangeListener[] la;
                Collection<PropertyChangeListener> collection = this.delegates;
                synchronized (collection) {
                    la = this.delegates.toArray(new PropertyChangeListener[this.delegates.size()]);
                }
                for (PropertyChangeListener l : la) {
                    l.propertyChange(new PropertyChangeEvent(evt.getSource(), "kenai.login.changed", evt.getOldValue(), evt.getNewValue()));
                }
            }
        }

        private synchronized void add(PropertyChangeListener l) {
            this.delegates.add(l);
            if (this.delegates.size() == 1) {
                this.kenai.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private synchronized void remove(PropertyChangeListener l) {
            this.delegates.remove(l);
            if (this.delegates.isEmpty()) {
                this.kenai.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private class OwnerInfoImpl
    extends OwnerInfo {
        private final NbModuleOwnerSupport.OwnerInfo delegate;

        public OwnerInfoImpl(NbModuleOwnerSupport.OwnerInfo delegate) {
            this.delegate = delegate;
        }

        public String getOwner() {
            return this.delegate.getOwner();
        }

        public List<String> getExtraData() {
            return this.delegate.getExtraData();
        }
    }
}

