/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.project;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.wizards.ImportWizard;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class ImportAction
extends NodeAction {
    public ImportAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(ImportAction.class, (String)"BK0006");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean enable(Node[] nodes) {
        if (nodes.length == 1) {
            FileStatusCache cache = Subversion.getInstance().getStatusCache();
            File dir = this.lookupImportDirectory(nodes[0]);
            if (dir != null && dir.isDirectory()) {
                FileInformation status = cache.getCachedStatus(dir);
                if (!(SvnUtils.isManaged(dir) || status != null && (status.getStatus() & 0xFFFFFFFE) != 0)) {
                    FileObject fo = FileUtil.toFileObject((File)dir);
                    Project p = FileOwnerQuery.getOwner((FileObject)fo);
                    if (p == null) {
                        return true;
                    }
                    FileObject projectDir = p.getProjectDirectory();
                    return !FileUtil.isParentOf((FileObject)projectDir, (FileObject)fo);
                }
            }
        }
        return false;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] nodes) {
        File importDirectory;
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Utils.logVCSActionEvent((String)"SVN");
        if (nodes.length == 1 && (importDirectory = this.lookupImportDirectory(nodes[0])) != null) {
            ArrayList<File> list = new ArrayList<File>(1);
            list.add(importDirectory);
            Context context = new Context(Context.getEmptyList(), list, Context.getEmptyList());
            ImportWizard wizard = new ImportWizard(context);
            wizard.show();
        }
    }

    public boolean cancel() {
        return true;
    }

    private File lookupImportDirectory(Node node) {
        File importDirectory = null;
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("generic");
            if (groups.length == 1) {
                FileObject root = groups[0].getRootFolder();
                importDirectory = FileUtil.toFile((FileObject)root);
            } else {
                importDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
            }
        } else {
            File f;
            FileObject fo = null;
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                fo = (FileObject)fileObjects.iterator().next();
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    fo = dataObject.getPrimaryFile();
                }
            }
            if (fo != null && (f = FileUtil.toFile((FileObject)fo)) != null && f.isDirectory()) {
                importDirectory = f;
            }
        }
        return importDirectory;
    }
}

